/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class AbstractColorbar {
    protected static final String PATH_SEP = System.getProperty("file.separator");
    protected URL url;
    protected String identifier;
    protected String name;
    protected Color[] colors;
    protected int[] rgbValues;
    protected int colorCount;
    protected int minBin;
    protected int maxBin;
    protected int minOutlierBin;
    protected int maxOutlierBin;

    protected AbstractColorbar() throws IOException {
    }

    protected AbstractColorbar(File f) throws IOException, FileNotFoundException {
        if (f == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.url = f.toURL();
        this.identifier = this.url.toString();
        this.makeName(this.identifier);
    }

    protected AbstractColorbar(URL url) throws IOException, FileNotFoundException {
        if (url == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        this.url = url;
        this.identifier = url.toString();
        this.makeName(this.identifier);
    }

    public AbstractColorbar(byte[] b, String identifier) throws IOException, FileNotFoundException {
    }

    protected byte[] readBytes(File f, int min, int max) throws IOException, FileNotFoundException {
        return this.readBytes(new FileInputStream(f), min, max);
    }

    protected byte[] readBytes(URL url, int min, int max) throws IOException, FileNotFoundException {
        return this.readBytes(new DataInputStream(new BufferedInputStream(url.openStream())), min, max);
    }

    private byte[] readBytes(InputStream is, int min, int max) throws IOException {
        byte[] b = new byte[max];
        int bytesRead = is.read(b);
        is.close();
        if (bytesRead < min) {
            throw new IOException("Invalid color table.  Could not read at least " + min + " bytes.");
        }
        return b;
    }

    protected void makeName(String src) {
        StringBuffer dst = new StringBuffer("");
        int lastSeparator = src.lastIndexOf(PATH_SEP);
        int lastSlash = src.lastIndexOf("/");
        int lastDot = src.lastIndexOf(".");
        if (lastSlash > lastSeparator) {
            lastSeparator = lastSlash;
        }
        if (lastDot < lastSeparator) {
            lastDot = -1;
        }
        if (lastDot > -1) {
            dst.append(src.substring(lastSeparator + 1, lastDot));
        } else {
            dst.append(src.substring(lastSeparator + 1));
        }
        this.name = dst.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.getName();
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public Color getColorAt(int bin) {
        if (bin < 0 || bin >= this.colorCount) {
            return Color.black;
        }
        return this.colors[this.minBin + bin];
    }

    public Color getColorAt(int bin, boolean flipped) {
        if (bin < 0 || bin >= this.colorCount) {
            return Color.black;
        }
        if (flipped) {
            return this.colors[this.maxBin - bin];
        }
        return this.colors[this.minBin + bin];
    }

    public int getRGBAt(int bin) {
        if (bin < 0 || bin >= this.colorCount) {
            return 0;
        }
        return this.rgbValues[this.minBin + bin];
    }

    public int getRGBAt(int bin, boolean flipped) {
        if (bin < 0 || bin >= this.colorCount) {
            return 0;
        }
        if (flipped) {
            return this.rgbValues[this.maxBin - bin];
        }
        return this.rgbValues[this.minBin + bin];
    }

    public Color getMinOutlierColor() {
        return this.colors[this.minOutlierBin];
    }

    public Color getMinOutlierColor(boolean flipped) {
        if (flipped) {
            return this.colors[this.maxOutlierBin];
        }
        return this.colors[this.minOutlierBin];
    }

    public int getMinOutlierRGB() {
        return this.rgbValues[this.minOutlierBin];
    }

    public int getMinOutlierRGB(boolean flipped) {
        if (flipped) {
            return this.rgbValues[this.maxOutlierBin];
        }
        return this.rgbValues[this.minOutlierBin];
    }

    public Color getMaxOutlierColor() {
        return this.colors[this.maxOutlierBin];
    }

    public Color getMaxOutlierColor(boolean flipped) {
        if (flipped) {
            return this.colors[this.minOutlierBin];
        }
        return this.colors[this.maxOutlierBin];
    }

    public int getMaxOutlierRGB() {
        return this.rgbValues[this.maxOutlierBin];
    }

    public int getMaxOutlierRGB(boolean flipped) {
        if (flipped) {
            return this.rgbValues[this.minOutlierBin];
        }
        return this.rgbValues[this.maxOutlierBin];
    }
}

