/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colorbar;

import gov.nasa.giss.graphics.colorbar.AbstractColorbar;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class CWCColorbar
extends AbstractColorbar {
    public CWCColorbar(File f) throws IOException, FileNotFoundException {
        super(f);
        byte[] b = this.readBytes(f, 2070, 2070);
        this.fillColorTable(b);
    }

    public CWCColorbar(URL url) throws IOException, FileNotFoundException {
        super(url);
        byte[] b = this.readBytes(url, 2070, 2070);
        this.fillColorTable(b);
    }

    public CWCColorbar(byte[] b, String identifier) throws IOException {
        this.identifier = identifier;
        this.makeName(identifier);
        this.fillColorTable(b);
    }

    private void fillColorTable(byte[] b) throws IOException {
        if (b.length < 2070) {
            throw new IOException("Not a valid CWC color table");
        }
        this.colorCount = 256;
        this.minBin = 0;
        this.maxBin = 255;
        this.minOutlierBin = 0;
        this.maxOutlierBin = 255;
        this.colors = new Color[this.colorCount];
        this.rgbValues = new int[this.colorCount];
        int i = 0;
        while (i < 256) {
            this.colors[i] = new Color(0xFF & b[22 + i * 8 + 2], 0xFF & b[22 + i * 8 + 4], 0xFF & b[22 + i * 8 + 4 + 2]);
            this.rgbValues[i] = this.colors[i].getRGB();
            ++i;
        }
    }

    public String getName() {
        return super.getName() + " CWC";
    }
}

