/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.gui.TreeTableModel;
import gov.nasa.giss.gui.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    protected TreeTableModelAdapter ttmAdapter;
    private boolean allowEditing = false;
    static /* synthetic */ Class class$gov$nasa$giss$gui$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public JTreeTable(TreeTableModel model) {
        this.tree = new TreeTableCellRenderer(model);
        this.ttmAdapter = new TreeTableModelAdapter(model, this.tree);
        super.setModel(this.ttmAdapter);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(class$gov$nasa$giss$gui$TreeTableModel == null ? (class$gov$nasa$giss$gui$TreeTableModel = JTreeTable.class$("gov.nasa.giss.gui.TreeTableModel")) : class$gov$nasa$giss$gui$TreeTableModel, this.tree);
        this.setDefaultEditor(class$gov$nasa$giss$gui$TreeTableModel == null ? (class$gov$nasa$giss$gui$TreeTableModel = JTreeTable.class$("gov.nasa.giss.gui.TreeTableModel")) : class$gov$nasa$giss$gui$TreeTableModel, new TreeTableCellEditor());
        this.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = JTreeTable.class$("java.lang.String")) : class$java$lang$String, new AlignedCellRenderer(model));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(20);
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setDefaultEditor(class$gov$nasa$giss$gui$TreeTableModel == null ? (class$gov$nasa$giss$gui$TreeTableModel = JTreeTable.class$("gov.nasa.giss.gui.TreeTableModel")) : class$gov$nasa$giss$gui$TreeTableModel, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public void addSelectionPath(TreePath path) {
        this.tree.addSelectionPath(path);
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public Object getLastSelectedPathComponent() {
        return this.tree.getLastSelectedPathComponent();
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.tree.addTreeSelectionListener(l);
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$gov$nasa$giss$gui$TreeTableModel == null ? (class$gov$nasa$giss$gui$TreeTableModel = JTreeTable.class$("gov.nasa.giss.gui.TreeTableModel")) : class$gov$nasa$giss$gui$TreeTableModel) ? -1 : this.editingRow;
    }

    public Object nodeForRow(int row) {
        return this.ttmAdapter.nodeForRow(row);
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void sizeColumnsToFit(int resizingColumn) {
        if (resizingColumn == -1 && this.getColumnClass(0) == (class$gov$nasa$giss$gui$TreeTableModel == null ? (class$gov$nasa$giss$gui$TreeTableModel = JTreeTable.class$("gov.nasa.giss.gui.TreeTableModel")) : class$gov$nasa$giss$gui$TreeTableModel)) {
            super.getColumnModel().getColumn(0).setPreferredWidth(this.tree.getPreferredSize().width);
            super.sizeColumnsToFit(-1);
        }
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == (class$gov$nasa$giss$gui$TreeTableModel == null ? (class$gov$nasa$giss$gui$TreeTableModel = JTreeTable.class$("gov.nasa.giss.gui.TreeTableModel")) : class$gov$nasa$giss$gui$TreeTableModel)) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean isVisible) {
        this.tree.setRootVisible(isVisible);
    }

    public void setLeafIcon(ImageIcon icon) {
        TreeCellRenderer tcr = this.tree.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            ((DefaultTreeCellRenderer)tcr).setLeafIcon(icon);
        }
    }

    public void setClosedIcon(ImageIcon icon) {
        TreeCellRenderer tcr = this.tree.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            ((DefaultTreeCellRenderer)tcr).setClosedIcon(icon);
        }
    }

    public void setOpenIcon(ImageIcon icon) {
        TreeCellRenderer tcr = this.tree.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            ((DefaultTreeCellRenderer)tcr).setOpenIcon(icon);
        }
    }

    public boolean isExpanded(int row) {
        return this.tree.isExpanded(row);
    }

    public void expandRow(int row) {
        this.tree.expandRow(row);
    }

    public void expandPath(TreePath path) {
        this.tree.expandPath(path);
    }

    public int getRowForPath(TreePath path) {
        return this.tree.getRowForPath(path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class AlignedCellRenderer
    extends DefaultTableCellRenderer {
        protected TreeTableModel model;

        public AlignedCellRenderer(TreeTableModel model) {
            this.model = model;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(this.model.getColumnAlignment(column));
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        public void reshape(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.reshape(newX, y, w - (newX - x), h);
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableTextField());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            JTree t = JTreeTable.this.getTree();
            boolean rv = t.isRootVisible();
            int offsetRow = rv ? r : r - 1;
            Rectangle bounds = t.getRowBounds(offsetRow);
            int offset = bounds.x;
            TreeCellRenderer tcr = t.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                Icon icon = t.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (JTreeTable.this.tree.isExpanded(offsetRow) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
                if (icon != null) {
                    offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                }
            }
            ((TreeTableTextField)this.getComponent()).offset = offset;
            return component;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                    int col = JTreeTable.this.getColumnCount() - 1;
                    while (col >= 0) {
                        if (JTreeTable.this.getColumnClass(col) == (class$gov$nasa$giss$gui$TreeTableModel == null ? JTreeTable.class$("gov.nasa.giss.gui.TreeTableModel") : class$gov$nasa$giss$gui$TreeTableModel)) {
                            MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)col, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                            JTreeTable.this.tree.dispatchEvent(newME);
                            break;
                        }
                        --col;
                    }
                }
                return JTreeTable.this.allowEditing && me.getClickCount() >= 5;
            }
            return JTreeTable.this.allowEditing && e == null;
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.setSelectionMode(1);
            this.getListSelectionModel().setSelectionMode(0);
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    if (min != -1 && max != -1) {
                        int counter = min;
                        while (counter <= max) {
                            TreePath p;
                            if (this.listSelectionModel.isSelectedIndex(counter) && (p = JTreeTable.this.tree.getPathForRow(counter)) != null) {
                                this.addSelectionPath(p);
                            }
                            ++counter;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setBorderSelectionColor(null);
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rh) {
            if (rh > 0) {
                super.setRowHeight(rh);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rh) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foreground;
            Color background;
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.highlightBorder = null;
            if (JTreeTable.this.realEditingRow() == row && JTreeTable.this.getEditingColumn() == column) {
                if (JTreeTable.this.allowEditing) {
                    background = UIManager.getColor("Table.focusCellBackground");
                    foreground = UIManager.getColor("Table.focusCellForeground");
                }
            } else if (hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
                if (JTreeTable.this.allowEditing && JTreeTable.this.isCellEditable(row, column)) {
                    background = UIManager.getColor("Table.focusCellBackground");
                    foreground = UIManager.getColor("Table.focusCellForeground");
                }
            }
            this.visibleRow = row;
            this.setBackground(background);
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (isSelected) {
                    dtcr.setTextSelectionColor(foreground);
                    dtcr.setBackgroundSelectionColor(background);
                } else {
                    dtcr.setTextNonSelectionColor(foreground);
                    dtcr.setBackgroundNonSelectionColor(background);
                }
            }
            return this;
        }
    }
}

