/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;

public class LineBorder2
extends AbstractBorder {
    protected Color color;
    protected int left;
    protected int top;
    protected int right;
    protected int bottom;

    public LineBorder2(Color color) {
        this(color, 1);
    }

    public LineBorder2(Color color, int thickness) {
        this(color, thickness, thickness, thickness, thickness);
    }

    public LineBorder2(Color color, Rectangle r) {
        this(color, r.x, r.y, r.width, r.height);
    }

    public LineBorder2(Color color, int left, int top, int right, int bottom) {
        this.color = color;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.color);
        if (this.top > 0) {
            g.fillRect(x, y, width, this.top);
        }
        if (this.left > 0) {
            g.fillRect(x, y, this.left, height);
        }
        if (this.bottom > 0) {
            g.fillRect(x, height - this.bottom, width, this.bottom);
        }
        if (this.right > 0) {
            g.fillRect(width - this.right, y, this.right, height);
        }
        g.setColor(oldColor);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this.left;
        insets.top = this.top;
        insets.right = this.right;
        insets.bottom = this.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.color;
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

