/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.PointDouble;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

abstract class AbstractProjection
extends Component {
    public static double RAD_PER_DEG = Math.PI / 180;
    public static double DEG_PER_RAD = 57.29577951308232;
    protected static final double ONE_OVER_PI = 0.3183098861837907;
    protected static final double TWO_OVER_PI = 0.6366197723675814;
    protected static final double HALFPI = 1.5707963267948966;
    protected static final double PI_SQUARE = Math.PI * Math.PI;
    protected static final double ONE_OVER_PI_SQUARE = 0.10132118364233778;
    protected static final double UNKNOWN = 9999.0;
    protected static final double DEFAULT_COP_LON = 0.0;
    protected static final double DEFAULT_COP_LAT = 45.0;
    protected static final Color DEFAULT_BGCOLOR = Color.black;
    protected static final double REAL_SMALL = 1.0E-5;
    protected Image source;
    protected int srcWidth;
    protected int srcHeight;
    protected double srcXPixPerDeg;
    protected double srcYPixPerDeg;
    protected int dstWidth;
    protected int dstHeight;
    protected int xCenter;
    protected int yCenter;
    protected int xMargin;
    protected int yMargin;
    protected int useWidth;
    protected int useHeight;
    protected int[] invArray;
    protected Color bgcolor;
    protected int bgcolorRGB;
    protected Color fgcolor;
    protected int fgcolorRGB;
    protected boolean drawMapBorder = false;
    protected double copLon;
    protected double copLat;
    protected double cosCOPLat;
    protected double sinCOPLat;
    protected Color gridColor = Color.black;
    protected boolean gridLabeled = false;
    protected Color outlineColor;
    protected PointDouble[] outlinePoints;
    protected boolean needsUpdate = true;

    protected void init(int dw, int dh, int xm, int ym, double lon, double lat) {
        this.dstWidth = dw;
        this.dstHeight = dh;
        this.xMargin = xm;
        this.yMargin = ym;
        this.srcXPixPerDeg = (double)this.srcWidth / 360.0;
        this.srcYPixPerDeg = (double)this.srcHeight / 180.0;
        this.xCenter = (short)(0.5 * (double)this.dstWidth);
        this.yCenter = (short)(0.5 * (double)this.dstHeight);
        this.useWidth = this.dstWidth - 2 * this.xMargin;
        this.useHeight = this.dstHeight - 2 * this.yMargin;
        this.setCenter(lon, lat);
        this.setBackgroundColor(DEFAULT_BGCOLOR);
        this.needsUpdate = true;
    }

    public Image getSourceMap() {
        return this.source;
    }

    public void setSourceMap(Image i) {
        if (i == null) {
            throw new IllegalArgumentException("Source map iamge must not be null.");
        }
        this.source = i;
        int oldWidth = this.srcWidth;
        int oldHeight = this.srcHeight;
        this.srcWidth = this.source.getWidth(this);
        this.srcHeight = this.source.getHeight(this);
        this.srcXPixPerDeg = (double)this.srcWidth / 360.0;
        this.srcYPixPerDeg = (double)this.srcHeight / 180.0;
        if (this.srcWidth != oldWidth || this.srcHeight != oldHeight) {
            this.needsUpdate = true;
        }
    }

    public Point getCenter() {
        return new Point(this.xCenter, this.yCenter);
    }

    public void setCenter(double lon, double lat) {
        this.copLon = lon;
        this.copLat = lat;
        this.cosCOPLat = Math.cos(AbstractProjection.toRadians(this.copLat));
        this.sinCOPLat = Math.sin(AbstractProjection.toRadians(this.copLat));
        this.needsUpdate = true;
    }

    public void setCenter(double lon) {
        this.copLon = lon;
        this.copLat = 0.0;
        this.cosCOPLat = 1.0;
        this.sinCOPLat = 0.0;
        this.needsUpdate = true;
    }

    public void setBackgroundColor(Color bgcolor) {
        this.bgcolor = bgcolor;
        this.bgcolorRGB = bgcolor.getRGB();
        this.fgcolorRGB = this.bgcolorRGB ^ 0xFFFFFF;
        this.fgcolor = new Color(this.fgcolorRGB);
    }

    public void drawMap(Image src, Graphics g) {
        this.setSourceMap(src);
        this.drawMap(g);
    }

    public void drawMap(Graphics g) {
        if (this.needsUpdate) {
            this.calculateInverseArray();
        }
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.dstWidth, this.dstHeight);
        this.drawMapUsingInvArray(g);
    }

    protected void drawMapUsingInvArray(Graphics g) {
        if (this.source == null) {
            throw new IllegalArgumentException("Source map image has not been provided.");
        }
        if (this.drawMapBorder) {
            int row = 0;
            while (row < this.yCenter) {
                int col = 0;
                while (col < this.xCenter) {
                    int poff = row * this.dstWidth + col;
                    if (this.invArray[poff] == -1 && (this.invArray[poff + 1] >= 0 || this.invArray[poff + this.dstWidth] >= 0 || this.invArray[poff + this.dstWidth + 1] >= 0)) {
                        this.invArray[poff] = -100;
                    } else if (this.invArray[poff] >= 0) break;
                    ++col;
                }
                ++row;
            }
            int row2 = this.yCenter;
            while (row2 < this.dstHeight) {
                int col = 0;
                while (col < this.xCenter) {
                    int poff = row2 * this.dstWidth + col;
                    if (this.invArray[poff] == -1 && (this.invArray[poff + 1] >= 0 || this.invArray[poff - this.dstWidth] >= 0 || this.invArray[poff - this.dstWidth + 1] >= 0)) {
                        this.invArray[poff] = -100;
                    } else if (this.invArray[poff] >= 0) break;
                    ++col;
                }
                ++row2;
            }
            int row3 = 0;
            while (row3 < this.yCenter) {
                int col = this.dstWidth - 1;
                while (col > this.xCenter - 1) {
                    int poff = row3 * this.dstWidth + col;
                    if (this.invArray[poff] == -1 && (this.invArray[poff - 1] >= 0 || this.invArray[poff + this.dstWidth] >= 0 || this.invArray[poff + this.dstWidth - 1] >= 0)) {
                        this.invArray[poff] = -100;
                    } else if (this.invArray[poff] >= 0) break;
                    --col;
                }
                ++row3;
            }
            int row4 = this.yCenter;
            while (row4 < this.dstHeight) {
                int col = this.dstWidth - 1;
                while (col > this.xCenter - 1) {
                    int poff = row4 * this.dstWidth + col;
                    if (this.invArray[poff] == -1 && (this.invArray[poff - 1] >= 0 || this.invArray[poff - this.dstWidth] >= 0 || this.invArray[poff - this.dstWidth - 1] >= 0)) {
                        this.invArray[poff] = -100;
                    } else if (this.invArray[poff] >= 0) break;
                    --col;
                }
                ++row4;
            }
        }
        int offset = 0;
        int maxSrcPixels = this.srcWidth * this.srcHeight;
        int maxDstPixels = this.dstWidth * this.dstHeight;
        int[] srcPixels = new int[maxSrcPixels];
        int[] dstPixels = new int[maxDstPixels];
        try {
            PixelGrabber grabber = new PixelGrabber(this.source, 0, 0, this.srcWidth, this.srcHeight, srcPixels, 0, this.srcWidth);
            try {
                grabber.grabPixels();
            }
            catch (Exception ignore) {
                return;
            }
            int row = 0;
            while (row < this.dstHeight) {
                int col = 0;
                while (col < this.dstWidth) {
                    offset = row * this.dstWidth + col;
                    if (this.invArray[offset] - 1 > 0 && this.invArray[offset] < maxSrcPixels) {
                        dstPixels[offset] = srcPixels[this.invArray[offset]];
                    } else if (this.invArray[offset] == -100) {
                        dstPixels[offset] = this.fgcolorRGB;
                    }
                    ++col;
                }
                ++row;
            }
            g.setColor(this.bgcolor);
            g.fillRect(0, 0, this.dstWidth, this.dstHeight);
            g.drawImage(this.createImage(new MemoryImageSource(this.dstWidth, this.dstHeight, dstPixels, 0, this.dstWidth)), 0, 0, this);
        }
        catch (Exception exc) {
            System.out.println("drawMapUsingInvArray error : " + exc.toString());
        }
    }

    public void setDrawBorder(boolean choice) {
        this.drawMapBorder = choice;
    }

    public void drawLLGrid(Graphics g, int spacing) {
    }

    protected abstract void calculateInverseArray();

    protected void clearInverseArray() {
        if (this.invArray == null) {
            this.invArray = new int[this.dstWidth * this.dstHeight];
        }
        int j = 0;
        while (j < this.dstHeight) {
            int i = 0;
            while (i < this.dstWidth) {
                this.invArray[j * this.dstWidth + i] = -1;
                ++i;
            }
            ++j;
        }
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void setGridLabeled(boolean choice) {
        this.gridLabeled = choice;
    }

    public void setOutlinePoints(PointDouble[] dots) {
        this.outlinePoints = dots;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    /*
     * Unable to fully structure code
     */
    public void drawOutline(Graphics g) {
        if (this.outlinePoints == null || this.outlinePoints.length == 0) {
            return;
        }
        if (this.outlineColor == null) {
            g.setColor(Color.black);
        } else {
            g.setColor(this.outlineColor);
        }
        while (this.copLon < 0.0) {
            this.copLon += 360.0;
        }
        while (this.copLon >= 360.0) {
            this.copLon -= 360.0;
        }
        leftEdge = this.copLon - 180.0;
        rightEdge = this.copLon + 180.0;
        center = this.getCenter();
        lastX = 9999;
        lastY = 9999;
        if (this.outlinePoints[0].x != 9999.0 && (dot = this.transformLL2XY(this.outlinePoints[0].x, this.outlinePoints[0].y)) != null) {
            lastX = dot.x;
            lastY = dot.y;
        }
        i = 1;
        while (i < this.outlinePoints.length) {
            block25: {
                block27: {
                    block26: {
                        block24: {
                            if (this.outlinePoints[i].x != 9999.0) break block24;
                            lastX = 9999;
                            lastY = 9999;
                            break block25;
                        }
                        dot = this.transformLL2XY(this.outlinePoints[i].x, this.outlinePoints[i].y);
                        if (dot != null) break block26;
                        lastX = 9999;
                        lastY = 9999;
                        break block25;
                    }
                    if (lastX != 9999) break block27;
                    lastX = dot.x;
                    lastY = dot.y;
                    break block25;
                }
                deltaX = Math.abs(dot.x - lastX);
                if (deltaX <= Math.abs(dot.x - center.x)) ** GOTO lbl-1000
                dotA = null;
                dotB = null;
                deltaLong = Math.abs(this.outlinePoints[i].x - this.copLon) % 360.0;
                if (deltaLong > 90.0 && deltaLong < 270.0) {
                    while (this.outlinePoints[i].x <= leftEdge) {
                        this.outlinePoints[i].x += 360.0;
                    }
                    while (this.outlinePoints[i].x > rightEdge) {
                        this.outlinePoints[i].x -= 360.0;
                    }
                    while (this.outlinePoints[i - 1].x <= leftEdge) {
                        this.outlinePoints[i - 1].x += 360.0;
                    }
                    while (this.outlinePoints[i - 1].x > rightEdge) {
                        this.outlinePoints[i - 1].x -= 360.0;
                    }
                    if (Math.abs(this.outlinePoints[i].x - this.copLon) > 179.1) {
                        if (Math.abs(this.outlinePoints[i - 1].x - this.copLon) < 179.1) {
                            dotB = this.outlinePoints[i - 1].x < this.copLon ? this.transformLL2XY(leftEdge + 0.1, this.outlinePoints[i - 1].y) : this.transformLL2XY(rightEdge - 0.1, this.outlinePoints[i - 1].y);
                        }
                    } else if (this.outlinePoints[i].x > this.copLon) {
                        if (this.outlinePoints[i].x < rightEdge - 0.1) {
                            dotA = this.transformLL2XY(rightEdge - 0.1, this.outlinePoints[i].y);
                        }
                        if (this.outlinePoints[i - 1].x > leftEdge + 0.1) {
                            dotB = this.transformLL2XY(leftEdge + 0.1, this.outlinePoints[i - 1].y);
                        }
                    } else {
                        if (this.outlinePoints[i].x > leftEdge + 0.1) {
                            dotA = this.transformLL2XY(leftEdge + 0.1, this.outlinePoints[i].y);
                        }
                        if (this.outlinePoints[i - 1].x < rightEdge - 0.1) {
                            dotB = this.transformLL2XY(rightEdge - 0.1, this.outlinePoints[i - 1].y);
                        }
                    }
                    if (dotA != null) {
                        g.drawLine(dot.x, dot.y, dotA.x, dotA.y);
                    }
                    if (dotB != null) {
                        g.drawLine(lastX, lastY, dotB.x, dotB.y);
                    }
                    lastX = dot.x;
                    lastY = dot.y;
                } else lbl-1000:
                // 2 sources

                {
                    g.drawLine(lastX, lastY, dot.x, dot.y);
                    lastX = dot.x;
                    lastY = dot.y;
                }
            }
            ++i;
        }
    }

    public PointDouble transformXY2LL(int x, int y) {
        if (this.needsUpdate) {
            this.calculateInverseArray();
        }
        double longitude = 0.0;
        double latitude = 0.0;
        int offset = y * this.dstWidth + x;
        if (this.invArray[offset] < 0) {
            return null;
        }
        double toffset = this.invArray[offset];
        longitude = 180.0 - toffset % (double)this.srcWidth / this.srcXPixPerDeg;
        latitude = 90.0 - toffset / (double)this.srcWidth / this.srcYPixPerDeg;
        PointDouble latlong = new PointDouble(longitude, latitude);
        return latlong;
    }

    public abstract Point transformLL2XY(double var1, double var3);

    public static final double toDegrees(double radians) {
        return radians * DEG_PER_RAD;
    }

    public static final double toRadians(double degrees) {
        return degrees * RAD_PER_DEG;
    }
}

