/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Eckert6
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Eckert VI";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TWO_PLUS_PI = 5.141592653589793;
    private static final double TERM1 = Math.sqrt(5.141592653589793);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TERM2 = 2.0 * ONE_OVER_TERM1;
    private static final double TERM3 = 0.5 * TERM2 * TERM2;
    private static final double FIT_WIDTH = 2.0 * ONE_OVER_TERM1 * Math.PI;
    private static final double FIT_HEIGHT = ONE_OVER_TERM1 * Math.PI;
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;
    private double twoOverRS;

    public Eckert6(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Eckert6(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Eckert6(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
        this.twoOverRS = 2.0 * this.oneOverRS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double thetaRad = (double)y * this.oneOverRS / TERM2;
            double sinTheta = Math.sin(thetaRad);
            double onePlusCosTheta = 1.0 + Math.cos(thetaRad);
            double phi = AbstractProjection.toDegrees(Math.asin((thetaRad + sinTheta) * TERM3));
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = 2.0 * this.oneOverRS / (TERM2 * onePlusCosTheta);
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double phiFactor = 2.5707963267948966 * Math.sin(AbstractProjection.toRadians(lat));
        double thetaRad = AbstractProjection.toRadians(lat);
        int i = 0;
        while (i < 25) {
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = -(thetaRad + sinTheta - phiFactor) / (1.0 + cosTheta);
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
            ++i;
        }
        double dlambda = lon - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * AbstractProjection.toRadians(dlambda) * (1.0 + Math.cos(thetaRad)) * ONE_OVER_TERM1;
        double y = 2.0 * this.rS * thetaRad * ONE_OVER_TERM1;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

