/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class FlatPolarQuartic
extends AbstractProjection {
    private static final String PROJECTION_NAME = "M.T. Flat-Polar Quartic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TWO_PLUS_SQRT2 = 2.0 + Math.sqrt(2.0);
    private static final double TERM1 = 2.0 * Math.sqrt(3.0 / TWO_PLUS_SQRT2);
    private static final double ONE_OVER_TERM1 = 1.0 / TERM1;
    private static final double TERM2 = Math.sqrt(6.0 + 3.0 * Math.sqrt(2.0));
    private static final double ONE_OVER_TERM2 = 1.0 / TERM2;
    private static final double FIT_WIDTH = 0.5 * TERM1 * Math.PI;
    private static final double FIT_HEIGHT = TERM1 * Math.sqrt(0.5);
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public FlatPolarQuartic(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public FlatPolarQuartic(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public FlatPolarQuartic(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int maxY = (int)(0.5 + FIT_HEIGHT * this.radius);
        if (maxY > this.yCenter) {
            maxY = this.yCenter;
        }
        int y = 0;
        while (y < maxY) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double thetaRad = 2.0 * Math.asin((double)y * this.oneOverRS * ONE_OVER_TERM1);
            double phi = AbstractProjection.toDegrees(Math.asin(2.0 * (Math.sin(thetaRad) + Math.sin(0.5 * thetaRad)) / TWO_PLUS_SQRT2));
            if (phi >= 90.0 || phi <= -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = AbstractProjection.toDegrees(this.oneOverRS * TERM2 / (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = (double)(-x) * xFactor;
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double phiTerm = 0.5 * TWO_PLUS_SQRT2 * Math.sin(AbstractProjection.toRadians(lat));
        double thetaRad = AbstractProjection.toRadians(lat);
        int i = 0;
        while (i < 25) {
            double dthetaRad = -(Math.sin(0.5 * thetaRad) + Math.sin(thetaRad) - phiTerm) / (0.5 * Math.cos(0.5 * thetaRad) + Math.cos(thetaRad));
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
            ++i;
        }
        double dlambda = lon - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * AbstractProjection.toRadians(dlambda) * (1.0 + 2.0 * Math.cos(thetaRad) / Math.cos(0.5 * thetaRad)) * ONE_OVER_TERM2;
        double y = this.rS * TERM1 * Math.sin(0.5 * thetaRad);
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

