/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class NellHammer
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Nell-Hammer";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double FIT_WIDTH = Math.PI;
    private static final double FIT_HEIGHT = 1.1415926535897931;
    public static final double ASPECT_RATIO = 2.751938393884109;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public NellHammer(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public NellHammer(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public NellHammer(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / 1.1415926535897931, 0.5 * (double)this.useWidth / Math.PI);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.751938393884109;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double PI_OVER_HEIGHT = Math.PI / (double)this.useHeight;
        double phiRad = 0.0;
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            double halfY = 0.5 * this.oneOverRS * (double)y;
            int i = 0;
            while (i < 12) {
                double halfPhi = 0.5 * phiRad;
                double cosHalfPhi = Math.cos(halfPhi);
                double dphiRad = (phiRad - Math.tan(halfPhi) - halfY) / (1.0 - 0.5 / (cosHalfPhi * cosHalfPhi));
                phiRad -= dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
                ++i;
            }
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            int ySrc = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int ySrcF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = this.oneOverRS * 2.0 / (1.0 + Math.cos(phiRad));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xSrc = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xSrcF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xSrc >= this.srcWidth) {
                    xSrc -= this.srcWidth;
                }
                while (xSrcF >= this.srcWidth) {
                    xSrcF -= this.srcWidth;
                }
                while (xSrc < 0) {
                    xSrc += this.srcWidth;
                }
                while (xSrcF < 0) {
                    xSrcF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = ySrc * this.srcWidth + xSrc;
                this.invArray[row * this.dstWidth + colF] = ySrc * this.srcWidth + xSrcF;
                this.invArray[rowF * this.dstWidth + col] = ySrcF * this.srcWidth + xSrc;
                this.invArray[rowF * this.dstWidth + colF] = ySrcF * this.srcWidth + xSrcF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double phiRad = AbstractProjection.toRadians(latitude);
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * 0.5 * AbstractProjection.toRadians(dlambda) * (1.0 + Math.cos(phiRad));
        double y = this.rS * 2.0 * (phiRad - Math.tan(0.5 * phiRad));
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

