/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Wagner2
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Wagner II";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMA = 0.92483;
    private static final double TERMB = 1.38725;
    private static final double TERMC = 0.88022;
    private static final double TERMD = 0.8855;
    private static final double ONE_OVER_TERMB = 0.7208506037123805;
    private static final double ONE_OVER_TERMD = 1.129305477131564;
    private static final double FIT_WIDTH = 2.9054391338194483;
    private static final double FIT_HEIGHT = 1.38725 * Math.asin(0.88022 * Math.sin(1.3909401473768808));
    private double scaleFactor = 1.0;
    public static final double ASPECT_RATIO = 2.9054391338194483 / FIT_HEIGHT;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Wagner2(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Wagner2(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Wagner2(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / 2.9054391338194483);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double thetaRad = this.oneOverRS * (double)y * 0.7208506037123805;
            double phiRad = Math.asin(Math.sin(thetaRad) / 0.88022) * 1.129305477131564;
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = this.oneOverRS / (0.92483 * Math.cos(thetaRad));
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double lon, double lat) {
        double phiRad = AbstractProjection.toRadians(lat);
        double thetaRad = Math.asin(0.88022 * Math.sin(0.8855 * phiRad));
        double dlambda = lon - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -this.rS * 0.92483 * AbstractProjection.toRadians(dlambda) * Math.cos(thetaRad);
        double y = this.rS * 1.38725 * thetaRad;
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

