/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import java.awt.Point;

public class Wagner4
extends AbstractProjection {
    private static final String PROJECTION_NAME = "Wagner IV";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM_P = 1.0471975511965976;
    private static final double CSUBP = 2.0943951023931953 + Math.sin(2.0943951023931953);
    private static final double ONE_OVER_CSUBP = 1.0 / CSUBP;
    private static final double TERM_R = Math.sqrt(Math.PI * 2 * Math.sin(1.0471975511965976) * ONE_OVER_CSUBP);
    private static final double CSUBX = TERM_R * 0.6366197723675814;
    private static final double CSUBY = TERM_R / Math.sin(1.0471975511965976);
    private static final double ONE_OVER_CSUBX = 1.0 / CSUBX;
    private static final double ONE_OVER_CSUBY = 1.0 / CSUBY;
    private static final double FIT_WIDTH = CSUBX * Math.PI;
    private static final double FIT_HEIGHT = CSUBY * Math.sin(1.0471975511965976);
    public static final double ASPECT_RATIO = FIT_WIDTH / FIT_HEIGHT;
    private double scaleFactor = 1.0;
    private double radius;
    private double rS;
    private double oneOverR;
    private double oneOverRS;

    public Wagner4(int dw, int dh) {
        this(dw, dh, 0, 0, 0.0);
    }

    public Wagner4(Integer dw, Integer dh, Integer xm, Integer ym, Double longitude) {
        this((int)dw, (int)dh, (int)xm, (int)ym, (double)longitude);
    }

    public Wagner4(int dw, int dh, int xm, int ym, double longitude) {
        this.init(dw, dh, xm, ym, longitude, 0.0);
        this.radius = Math.min(0.5 * (double)this.useHeight / FIT_HEIGHT, 0.5 * (double)this.useWidth / FIT_WIDTH);
        this.oneOverR = 1.0 / this.radius;
        this.rS = this.radius * this.scaleFactor;
        this.oneOverRS = 1.0 / this.rS;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        int y = 0;
        while ((double)y < 0.5 * (double)this.useHeight) {
            int row = this.yCenter - y;
            int rowF = this.yCenter + y;
            double halfThetaRad = Math.asin((double)y * this.oneOverRS * ONE_OVER_CSUBY);
            double thetaRad = 2.0 * halfThetaRad;
            double phiRad = Math.asin((thetaRad + Math.sin(thetaRad)) * ONE_OVER_CSUBP);
            double phi = AbstractProjection.toDegrees(phiRad);
            if (phi > 90.0 || phi < -90.0) break;
            int yMap = (int)(this.srcYPixPerDeg * (90.0 - phi));
            int yMapF = (int)(this.srcYPixPerDeg * (90.0 + phi));
            double xFactor = this.oneOverRS * ONE_OVER_CSUBX / Math.cos(halfThetaRad);
            int x = 0;
            while (x < this.xCenter) {
                double dlambda = -AbstractProjection.toDegrees((double)x * xFactor);
                if (dlambda > 180.0 || dlambda < -180.0) break;
                int col = this.xCenter + x;
                int colF = this.xCenter - x;
                int xMap = (int)(this.srcXPixPerDeg * (180.0 - this.copLon - dlambda));
                int xMapF = (int)(this.srcXPixPerDeg * (180.0 - this.copLon + dlambda));
                while (xMap >= this.srcWidth) {
                    xMap -= this.srcWidth;
                }
                while (xMapF >= this.srcWidth) {
                    xMapF -= this.srcWidth;
                }
                while (xMap < 0) {
                    xMap += this.srcWidth;
                }
                while (xMapF < 0) {
                    xMapF += this.srcWidth;
                }
                this.invArray[row * this.dstWidth + col] = yMap * this.srcWidth + xMap;
                this.invArray[row * this.dstWidth + colF] = yMap * this.srcWidth + xMapF;
                this.invArray[rowF * this.dstWidth + col] = yMapF * this.srcWidth + xMap;
                this.invArray[rowF * this.dstWidth + colF] = yMapF * this.srcWidth + xMapF;
                ++x;
            }
            ++y;
        }
        this.needsUpdate = false;
    }

    public Point transformLL2XY(double longitude, double latitude) {
        double phiFactor = CSUBP * Math.sin(AbstractProjection.toRadians(latitude));
        double thetaRad = AbstractProjection.toRadians(latitude);
        int i = 0;
        while (i < 25) {
            double dthetaRad = (thetaRad + Math.sin(thetaRad) - phiFactor) / (1.0 + Math.cos(thetaRad));
            thetaRad -= dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
            ++i;
        }
        double dlambda = longitude - this.copLon;
        while (dlambda > 180.0) {
            dlambda -= 360.0;
        }
        while (dlambda < -180.0) {
            dlambda += 360.0;
        }
        double x = -CSUBX * this.rS * AbstractProjection.toRadians(dlambda) * Math.cos(0.5 * thetaRad);
        double y = CSUBY * this.rS * Math.sin(0.5 * thetaRad);
        return new Point(this.xCenter + (int)x, this.yCenter - (int)y);
    }
}

