/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.graphics.NatCubicClosed;
import gov.nasa.giss.math.Mathlib;
import gov.nasa.giss.time.EarthTime;
import gov.nasa.giss.time.MarsTime;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class M24OrbitPlotter {
    private static final int ORBIT_STEPS = 12;
    private static final long MARS_YEAR_MILLIS = 59443200000L;
    private static final long EARTH_YEAR_MILLIS = 31536000000L;
    private static final long MARS_STEP_MILLIS = 4953600000L;
    private static final long EARTH_STEP_MILLIS = 2628000000L;
    private static final int FHGT_LRG = 20;
    private static final int FHGT_SML = 12;
    private static final Font FONT_LRG = new Font("Courier", 1, 20);
    private static final Font FONT_SML = new Font("Courier", 1, 12);
    private int width;
    private int height;
    private int sunX;
    private int sunY;
    private double pixelPerAU;
    private double j2000;
    private double angleDeg;
    private double angleRad;
    private double cosAngle;
    private double sinAngle;
    private double periRad;
    private double r;
    private double lambdaRad;
    private double shortR;
    private double longR;
    private int dx;
    private int dy;
    private long startTime;
    private long oneYear;
    private long stepSecs;

    public M24OrbitPlotter(int w, int h) {
        this.width = w;
        this.height = h;
        this.sunX = this.width / 2;
        this.sunY = this.height / 2;
        this.pixelPerAU = ((double)this.sunY - 20.0) / 1.6;
    }

    public void draw(Graphics g, long millis) {
        this.draw(g, millis, new MarsTime(millis), new EarthTime(millis));
    }

    public void draw(Graphics g, long millis, MarsTime mTime, EarthTime eTime) {
        this.j2000 = eTime.getJDate(1);
        g.setFont(FONT_SML);
        FontMetrics fm = g.getFontMetrics();
        g.setColor(new Color(0, 0, 0));
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.yellow);
        g.fillOval(this.sunX - 4, this.sunY - 4, 9, 9);
        g.setColor(Color.white);
        int i = 0;
        while (i < 4) {
            this.angleDeg = (double)i * 90.0 - 4.6E-5 * eTime.getDelta2000();
            this.angleRad = Mathlib.toRadians(this.angleDeg);
            this.cosAngle = Math.cos(this.angleRad);
            this.sinAngle = Math.sin(this.angleRad);
            this.r = this.getEarthOrbitalRadius(this.angleRad - this.periRad);
            if (i == 0) {
                this.shortR = this.r - 10.0;
                this.longR = this.r + 10.0;
            } else {
                this.shortR = this.r - 3.0;
                this.longR = this.r + 1.0;
            }
            g.drawLine(this.sunX - (int)(this.cosAngle * this.shortR), this.sunY + (int)(this.sinAngle * this.shortR), this.sunX - (int)(this.cosAngle * this.longR), this.sunY + (int)(this.sinAngle * this.longR));
            if (i == 0) {
                g.drawString("nhve", this.sunX - (int)this.shortR + 2, this.sunY + fm.getHeight() / 2);
            }
            ++i;
        }
        this.angleDeg = 282.9317 + 4.7076E-5 * this.j2000 - 4.6E-5 * eTime.getDelta2000();
        this.periRad = Mathlib.toRadians(this.angleDeg);
        this.cosAngle = Math.cos(this.periRad);
        this.sinAngle = Math.sin(this.periRad);
        this.r = this.getEarthOrbitalRadius(0.0);
        this.shortR = this.r - 10.0;
        this.longR = this.r + 10.0;
        g.setColor(Color.white);
        g.drawLine(this.sunX - (int)(this.cosAngle * this.shortR), this.sunY + (int)(this.sinAngle * this.shortR), this.sunX - (int)(this.cosAngle * this.longR), this.sunY + (int)(this.sinAngle * this.longR));
        g.drawString("peri", this.sunX - (int)(this.cosAngle * this.shortR), this.sunY + (int)(this.sinAngle * this.shortR) + fm.getHeight() - 3);
        this.angleRad = this.periRad + Math.PI;
        this.cosAngle = Math.cos(this.angleRad);
        this.sinAngle = Math.sin(this.angleRad);
        this.r = this.getEarthOrbitalRadius(Math.PI);
        this.shortR = this.r - 3.0;
        this.longR = this.r + 1.0;
        g.drawLine(this.sunX - (int)(this.cosAngle * this.shortR), this.sunY + (int)(this.sinAngle * this.shortR), this.sunX - (int)(this.cosAngle * this.longR), this.sunY + (int)(this.sinAngle * this.longR));
        NatCubicClosed earthOrbit = new NatCubicClosed();
        g.setColor(Color.green);
        this.startTime = millis - millis % 31536000000L;
        int k = 0;
        while (k < 12) {
            EarthTime et = new EarthTime(this.startTime + (long)k * 2628000000L);
            this.lambdaRad = Mathlib.toRadians(et.getHeliocentricLongitude() + 180.0);
            this.r = et.getHeliocentricDistance() * this.pixelPerAU;
            this.dx = (int)(this.r * Math.cos(this.lambdaRad));
            this.dy = (int)(this.r * Math.sin(this.lambdaRad));
            earthOrbit.addPoint(this.sunX - this.dx, this.sunY + this.dy);
            ++k;
        }
        earthOrbit.paint(g);
        this.lambdaRad = Mathlib.toRadians(eTime.getHeliocentricLongitude() + 180.0);
        this.r = eTime.getHeliocentricDistance() * this.pixelPerAU;
        this.dx = (int)(this.r * Math.cos(this.lambdaRad));
        this.dy = (int)(this.r * Math.sin(this.lambdaRad));
        g.fillOval(this.sunX - this.dx - 4, this.sunY + this.dy - 4, 8, 8);
        g.setFont(FONT_LRG);
        fm = g.getFontMetrics();
        if (this.dx * this.dy < 0) {
            g.drawString("E", this.sunX - this.dx + 4, this.sunY + this.dy + 2 + 20);
        } else {
            g.drawString("E", this.sunX - this.dx + 4, this.sunY + this.dy - 4);
        }
        double h = mTime.getHeliocentricLongitude() + 180.0;
        double ls = mTime.getSolarLongitude();
        double ve = h - ls;
        this.angleDeg = ve + (250.999 + this.j2000 * 1.765E-5);
        this.periRad = Mathlib.toRadians(this.angleDeg);
        this.cosAngle = Math.cos(this.periRad);
        this.sinAngle = Math.sin(this.periRad);
        this.r = this.getMarsOrbitalRadius(0.0);
        this.shortR = this.r - 10.0;
        this.longR = this.r + 10.0;
        g.setColor(Color.white);
        g.setFont(FONT_SML);
        g.drawLine(this.sunX - (int)(this.cosAngle * this.shortR), this.sunY + (int)(this.sinAngle * this.shortR), this.sunX - (int)(this.cosAngle * this.longR), this.sunY + (int)(this.sinAngle * this.longR));
        g.drawString("peri", this.sunX - (int)(this.cosAngle * this.longR), this.sunY + (int)(this.sinAngle * this.longR) + fm.getHeight() - 3);
        this.angleRad = this.periRad + Math.PI;
        this.cosAngle = Math.cos(this.angleRad);
        this.sinAngle = Math.sin(this.angleRad);
        this.r = this.getMarsOrbitalRadius(Math.PI);
        this.shortR = this.r - 3.0;
        this.longR = this.r + 1.0;
        g.drawLine(this.sunX - (int)(this.cosAngle * this.shortR), this.sunY + (int)(this.sinAngle * this.shortR), this.sunX - (int)(this.cosAngle * this.longR), this.sunY + (int)(this.sinAngle * this.longR));
        int i2 = 0;
        while (i2 < 4) {
            this.angleDeg = ve + (double)(i2 * 90);
            this.angleRad = Mathlib.toRadians(this.angleDeg);
            this.cosAngle = Math.cos(this.angleRad);
            this.sinAngle = Math.sin(this.angleRad);
            this.lambdaRad = this.angleRad - this.periRad;
            this.r = this.getMarsOrbitalRadius(this.lambdaRad);
            if (i2 == 0) {
                this.shortR = this.r - 10.0;
                this.longR = this.r + 10.0;
            } else {
                this.shortR = this.r - 3.0;
                this.longR = this.r + 1.0;
            }
            g.drawLine(this.sunX - (int)(this.cosAngle * this.shortR), this.sunY + (int)(this.sinAngle * this.shortR), this.sunX - (int)(this.cosAngle * this.longR), this.sunY + (int)(this.sinAngle * this.longR));
            if (i2 == 0) {
                g.drawString("nhve", this.sunX - (int)(this.cosAngle * this.longR) + 3, this.sunY + (int)(this.sinAngle * this.longR) + 2);
            }
            ++i2;
        }
        NatCubicClosed marsOrbit = new NatCubicClosed();
        this.startTime = millis - millis % 59443200000L;
        g.setColor(Color.red);
        int k2 = 0;
        while (k2 < 12) {
            MarsTime mt = new MarsTime(this.startTime + (long)k2 * 4953600000L);
            this.lambdaRad = Mathlib.toRadians(mt.getHeliocentricLongitude() + 180.0);
            this.r = mt.getHeliocentricDistance() * this.pixelPerAU;
            this.dx = (int)(this.r * Math.cos(this.lambdaRad));
            this.dy = (int)(this.r * Math.sin(this.lambdaRad));
            marsOrbit.addPoint(this.sunX - this.dx, this.sunY + this.dy);
            ++k2;
        }
        marsOrbit.paint(g);
        this.lambdaRad = Mathlib.toRadians(mTime.getHeliocentricLongitude() + 180.0);
        this.r = mTime.getHeliocentricDistance() * this.pixelPerAU;
        this.dx = (int)(this.r * Math.cos(this.lambdaRad));
        this.dy = (int)(this.r * Math.sin(this.lambdaRad));
        g.setFont(FONT_LRG);
        fm = g.getFontMetrics();
        g.fillOval(this.sunX - this.dx - 4, this.sunY + this.dy - 4, 8, 8);
        if (this.dx * this.dy < 0) {
            g.drawString("M", this.sunX - this.dx + 4, this.sunY + this.dy + 4 + 20);
        } else {
            g.drawString("M", this.sunX - this.dx + 4, this.sunY + this.dy - 4);
        }
    }

    private double getMarsOrbitalRadius(double angleFromPerihelion) {
        return 1.524 * this.pixelPerAU * 0.99127644 / (1.0 + 0.0934 * Math.cos(angleFromPerihelion));
    }

    private double getEarthOrbitalRadius(double angleFromPerihelion) {
        return 1.0 * this.pixelPerAU * 0.99972111 / (1.0 + 0.0167 * Math.cos(angleFromPerihelion));
    }
}

