/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24.application;

import com.skatecity.gui.FGConstraint;
import com.skatecity.gui.FlexingGridLayout;
import gov.nasa.giss.mapping.PointDouble;
import gov.nasa.giss.mapping.proj.Projection;
import gov.nasa.giss.mars24.Landmark;
import gov.nasa.giss.mars24.LandmarkList;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.application.M24PlotPanel;
import gov.nasa.giss.mars24.application.M24TimePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class M24ControlsPanel
extends JPanel
implements MouseListener {
    private static final EmptyBorder EMPTY6_BORDER = new EmptyBorder(6, 6, 6, 6);
    private static final int GAP = 6;
    private static final DecimalFormat FORMAT_X2 = new DecimalFormat("0.00");
    private M24Timekeeper timekeeper;
    private M24PlotPanel plotPanel;
    private M24TimePanel timePanel;
    private LandmarkList landmarks;
    private JRadioButton useCurrentTimeButton;
    private JRadioButton useOffsetTimeButton;
    private JRadioButton useFixedTimeButton;
    private JTextField fixedDateTF = new JTextField("July 20, 1976");
    private JTextField fixedTimeTF = new JTextField("11:53:06");
    private JTextField dOffsetTF = new JTextField("0", 4);
    private JTextField hOffsetTF = new JTextField("0", 4);
    private JTextField mOffsetTF = new JTextField("0", 4);
    private JTextField sOffsetTF = new JTextField("0", 4);
    private JRadioButton useLonlatCOP;
    private JRadioButton showLonlatTimeButton;
    private JTextField timeSiteLonTF = new JTextField("0.0", 5);
    private JTextField timeSiteLatTF = new JTextField("0.0", 5);
    private JRadioButton showMERATimeButton;
    private JRadioButton showMERBTimeButton;
    private JRadioButton showMERABTimeButton;
    private JRadioButton showBeagleTimeButton;
    private JComboBox displayMenu;
    private JPanel currentDisplay;
    private JComboBox copMenu;
    private JTextField copLonTF = new JTextField("0.0", 5);
    private JTextField copLatTF = new JTextField("0.0", 5);
    private JLabel copLabel3 = new JLabel(", latitude ");
    private JLabel copLabel4 = new JLabel("\u00b0N ");
    private JCheckBox markLLGridCB;

    public M24ControlsPanel() {
        throw new IllegalArgumentException("Use another constructor");
    }

    public M24ControlsPanel(M24Timekeeper tk, M24PlotPanel p1, M24TimePanel p2, LandmarkList ll) {
        if (tk == null) {
            throw new IllegalArgumentException("Timekeeper cannot be null");
        }
        if (p1 == null) {
            throw new IllegalArgumentException("Plot panel cannot be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Time panel cannot be null");
        }
        this.timekeeper = tk;
        this.plotPanel = p1;
        this.timePanel = p2;
        this.landmarks = ll;
        JTabbedPane mainTPane = new JTabbedPane(1);
        mainTPane.setName("[main tpane]");
        mainTPane.addTab("Mars Time", this.createMarsTimeControls());
        mainTPane.addTab("Earth Time", this.createEarthTimeControls());
        mainTPane.addTab("Graphic DIsplay", this.createDisplayControls());
        mainTPane.setMaximumSize(mainTPane.getPreferredSize());
        mainTPane.setMinimumSize(mainTPane.getPreferredSize());
        this.add(mainTPane);
        this.plotPanel.addMouseListener(this);
    }

    private JPanel createEarthTimeControls() {
        JPanel panel = new JPanel();
        panel.setBorder(EMPTY6_BORDER);
        JLabel hed1 = new JLabel("For all calculations, set Earth time to:");
        JLabel hed2 = new JLabel("Display:");
        this.useCurrentTimeButton = new JRadioButton("", this.timekeeper.getMethod() == 1);
        this.useOffsetTimeButton = new JRadioButton("", this.timekeeper.getMethod() == 2);
        this.useFixedTimeButton = new JRadioButton("", this.timekeeper.getMethod() == 3);
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.useCurrentTimeButton);
        methodGroup.add(this.useFixedTimeButton);
        methodGroup.add(this.useOffsetTimeButton);
        JLabel useCurrentTimeLabel = new JLabel("Current date and time");
        JLabel useOffsetTimeLabel = new JLabel("Offset: To current date and time, add:");
        JLabel useFixedTimeLabel = new JLabel("Fixed date and time:");
        Box offsetTimeBox = Box.createHorizontalBox();
        JLabel dLabel = new JLabel("day + ");
        JLabel hLabel = new JLabel("hour + ");
        JLabel mLabel = new JLabel("min + ");
        JLabel sLabel = new JLabel("sec");
        offsetTimeBox.add(this.dOffsetTF);
        offsetTimeBox.add(dLabel);
        offsetTimeBox.add(this.hOffsetTF);
        offsetTimeBox.add(hLabel);
        offsetTimeBox.add(this.mOffsetTF);
        offsetTimeBox.add(mLabel);
        offsetTimeBox.add(this.sOffsetTF);
        offsetTimeBox.add(sLabel);
        offsetTimeBox.add(Box.createHorizontalGlue());
        JLabel utcLabel = new JLabel("Set UTC = ", 4);
        JLabel onLabel = new JLabel(" on ");
        Dimension tfsize = this.fixedTimeTF.getPreferredSize();
        if (tfsize.width < this.fixedDateTF.getPreferredSize().width + 10) {
            tfsize.width = this.fixedDateTF.getPreferredSize().width + 10;
        }
        this.fixedTimeTF.setMinimumSize(tfsize);
        this.fixedDateTF.setMinimumSize(tfsize);
        this.fixedTimeTF.setPreferredSize(tfsize);
        this.fixedDateTF.setPreferredSize(tfsize);
        Box fixedTimeBox = Box.createHorizontalBox();
        fixedTimeBox.add(utcLabel);
        fixedTimeBox.add(this.fixedTimeTF);
        fixedTimeBox.add(onLabel);
        fixedTimeBox.add(this.fixedDateTF);
        fixedTimeBox.add(Box.createHorizontalGlue());
        JCheckBox doyCB = new JCheckBox("Show date as day-of-year", this.timekeeper.getShowDateAsDOY());
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(2, 13), 2, 4);
        fgl.setColumnWeight(0, 0.0f);
        fgl.setColumnWeight(1, 1.0f);
        fgl.setRowWeight(12, 100.0f);
        panel.setLayout(fgl);
        panel.add((Component)hed1, new FGConstraint(new Rectangle(0, 0, 2, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 1, 2, 1), 0.0, 0.5));
        panel.add((Component)this.useCurrentTimeButton, new FGConstraint(new Rectangle(0, 2, 1, 1), 0.5, 0.5));
        panel.add((Component)useCurrentTimeLabel, new FGConstraint(new Rectangle(1, 2, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 3, 2, 1), 0.0, 0.5));
        panel.add((Component)this.useOffsetTimeButton, new FGConstraint(new Rectangle(0, 4, 1, 1), 0.5, 0.5));
        panel.add((Component)useOffsetTimeLabel, new FGConstraint(new Rectangle(1, 4, 1, 1), 0.0, 0.5));
        panel.add((Component)offsetTimeBox, new FGConstraint(new Rectangle(1, 5, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 6, 2, 1), 0.0, 0.5));
        panel.add((Component)this.useFixedTimeButton, new FGConstraint(new Rectangle(0, 7, 1, 1), 0.5, 0.5));
        panel.add((Component)useFixedTimeLabel, new FGConstraint(new Rectangle(1, 7, 1, 1), 0.0, 0.5));
        panel.add((Component)fixedTimeBox, new FGConstraint(new Rectangle(1, 8, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 9, 2, 1), 0.0, 0.5));
        panel.add((Component)hed2, new FGConstraint(new Rectangle(0, 10, 2, 1), 0.0, 0.5));
        panel.add((Component)doyCB, new FGConstraint(new Rectangle(0, 11, 2, 1), 0.0, 0.5));
        panel.add(Box.createVerticalGlue(), new FGConstraint(new Rectangle(0, 12, 2, 1), 0.5, 0.5));
        ActionListener timeMethodAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (M24ControlsPanel.this.useCurrentTimeButton.isSelected()) {
                    if (e.getSource() == M24ControlsPanel.this.useCurrentTimeButton) {
                        M24ControlsPanel.this.timekeeper.setShowCurrent();
                    }
                } else if (M24ControlsPanel.this.useFixedTimeButton.isSelected()) {
                    M24ControlsPanel.this.timekeeper.setShowFixed(M24ControlsPanel.this.fixedDateTF.getText() + " " + M24ControlsPanel.this.fixedTimeTF.getText());
                } else if (M24ControlsPanel.this.useOffsetTimeButton.isSelected()) {
                    M24ControlsPanel.this.handleOffsetTimeFields();
                }
            }
        };
        FocusListener fixedTimeFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (M24ControlsPanel.this.useFixedTimeButton.isSelected()) {
                    M24ControlsPanel.this.timekeeper.setShowFixed(M24ControlsPanel.this.fixedDateTF.getText() + " " + M24ControlsPanel.this.fixedTimeTF.getText());
                }
            }
        };
        FocusListener offsetTimeFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (M24ControlsPanel.this.useOffsetTimeButton.isSelected()) {
                    M24ControlsPanel.this.handleOffsetTimeFields();
                }
            }
        };
        this.useCurrentTimeButton.addActionListener(timeMethodAL);
        this.useFixedTimeButton.addActionListener(timeMethodAL);
        this.useOffsetTimeButton.addActionListener(timeMethodAL);
        this.fixedDateTF.addActionListener(timeMethodAL);
        this.fixedTimeTF.addActionListener(timeMethodAL);
        this.fixedDateTF.addFocusListener(fixedTimeFL);
        this.fixedTimeTF.addFocusListener(fixedTimeFL);
        this.dOffsetTF.addActionListener(timeMethodAL);
        this.hOffsetTF.addActionListener(timeMethodAL);
        this.mOffsetTF.addActionListener(timeMethodAL);
        this.sOffsetTF.addActionListener(timeMethodAL);
        this.dOffsetTF.addFocusListener(offsetTimeFL);
        this.mOffsetTF.addFocusListener(offsetTimeFL);
        this.hOffsetTF.addFocusListener(offsetTimeFL);
        this.sOffsetTF.addFocusListener(offsetTimeFL);
        doyCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                M24ControlsPanel.this.timekeeper.setShowDateAsDOY(((JCheckBox)e.getSource()).isSelected());
            }
        });
        return panel;
    }

    private JPanel createMarsTimeControls() {
        JPanel panel = new JPanel();
        panel.setBorder(EMPTY6_BORDER);
        JLabel hed1 = new JLabel("Display:");
        this.showLonlatTimeButton = new JRadioButton("", true);
        this.showMERATimeButton = new JRadioButton("", false);
        this.showMERBTimeButton = new JRadioButton("", false);
        this.showMERABTimeButton = new JRadioButton("", false);
        this.showBeagleTimeButton = new JRadioButton("", false);
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.showLonlatTimeButton);
        methodGroup.add(this.showMERATimeButton);
        methodGroup.add(this.showMERBTimeButton);
        methodGroup.add(this.showMERABTimeButton);
        methodGroup.add(this.showBeagleTimeButton);
        JLabel lonlatLabel = new JLabel("Local time at");
        JLabel merALabel = new JLabel("MER-A Spirit mission time");
        JLabel merBLabel = new JLabel("MER-B Opportunity mission time");
        JLabel merABLabel = new JLabel("Both MER-A and MER-B mission time");
        JLabel beagleLabel = new JLabel("Beagle 2 mission time");
        JLabel timeSiteLabel1 = new JLabel("Longitude ");
        JLabel timeSiteLabel2 = new JLabel("\u00b0W, latitude");
        JLabel timeSiteLabel3 = new JLabel("\u00b0N ");
        Box lonlatBox = Box.createHorizontalBox();
        lonlatBox.add(timeSiteLabel1);
        lonlatBox.add(this.timeSiteLonTF);
        lonlatBox.add(timeSiteLabel2);
        lonlatBox.add(this.timeSiteLatTF);
        lonlatBox.add(timeSiteLabel3);
        lonlatBox.add(Box.createHorizontalGlue());
        JLabel timeFormLabel = new JLabel("Format as ", 4);
        final JComboBox<String> timeFormMenu = new JComboBox<String>();
        timeFormMenu.addItem("Local Mean Solar Time (LMST)");
        timeFormMenu.addItem("Local True Solar Time (LTST)");
        timeFormMenu.addItem("Local Mean Zonal Time (LTZT)");
        Box formBox = Box.createHorizontalBox();
        formBox.add(timeFormLabel);
        formBox.add(timeFormMenu);
        formBox.add(Box.createHorizontalGlue());
        if (this.timePanel.getTimeForm() == 2) {
            timeFormMenu.setSelectedIndex(0);
        } else if (this.timePanel.getTimeForm() == 1) {
            timeFormMenu.setSelectedIndex(1);
        } else if (this.timePanel.getTimeForm() == 3) {
            timeFormMenu.setSelectedIndex(2);
        }
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(2, 13), 2, 2);
        fgl.setColumnWeight(0, 0.0f);
        fgl.setColumnWeight(1, 1.0f);
        fgl.setRowWeight(12, 100.0f);
        panel.setLayout(fgl);
        panel.add((Component)hed1, new FGConstraint(new Rectangle(0, 0, 2, 1), 0.0, 0.5));
        panel.add((Component)this.showLonlatTimeButton, new FGConstraint(new Rectangle(0, 1, 1, 1), 0.0, 0.5));
        panel.add((Component)lonlatLabel, new FGConstraint(new Rectangle(1, 1, 1, 1), 0.0, 0.5));
        panel.add((Component)lonlatBox, new FGConstraint(new Rectangle(1, 2, 1, 1), 0.0, 0.5));
        panel.add((Component)formBox, new FGConstraint(new Rectangle(1, 3, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 4, 2, 1), 0.0, 0.5));
        panel.add((Component)this.showMERATimeButton, new FGConstraint(new Rectangle(0, 5, 1, 1), 0.0, 0.5));
        panel.add((Component)merALabel, new FGConstraint(new Rectangle(1, 5, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 6, 2, 1), 0.0, 0.5));
        panel.add((Component)this.showMERBTimeButton, new FGConstraint(new Rectangle(0, 7, 1, 1), 0.0, 0.5));
        panel.add((Component)merBLabel, new FGConstraint(new Rectangle(1, 7, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 8, 2, 1), 0.0, 0.5));
        panel.add((Component)this.showMERABTimeButton, new FGConstraint(new Rectangle(0, 9, 1, 1), 0.0, 0.5));
        panel.add((Component)merABLabel, new FGConstraint(new Rectangle(1, 9, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 10, 2, 1), 0.0, 0.5));
        panel.add((Component)this.showBeagleTimeButton, new FGConstraint(new Rectangle(0, 11, 1, 1), 0.0, 0.5));
        panel.add((Component)beagleLabel, new FGConstraint(new Rectangle(1, 11, 1, 1), 0.0, 0.5));
        panel.add(Box.createVerticalGlue(), new FGConstraint(new Rectangle(0, 12, 2, 1), 0.0, 0.5));
        this.setTimeSiteFields(true);
        ActionListener timeButtonAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (M24ControlsPanel.this.showMERATimeButton.isSelected()) {
                    M24ControlsPanel.this.timePanel.setTimeForm(105);
                    M24ControlsPanel.this.timekeeper.setLandmarkSite("MERA");
                } else if (M24ControlsPanel.this.showMERBTimeButton.isSelected()) {
                    M24ControlsPanel.this.timePanel.setTimeForm(106);
                    M24ControlsPanel.this.timekeeper.setLandmarkSite("MERB");
                } else if (M24ControlsPanel.this.showMERABTimeButton.isSelected()) {
                    M24ControlsPanel.this.timePanel.setTimeForm(1001);
                    M24ControlsPanel.this.timekeeper.setLandmarkSite("MERA");
                } else if (M24ControlsPanel.this.showBeagleTimeButton.isSelected()) {
                    M24ControlsPanel.this.timePanel.setTimeForm(104);
                    M24ControlsPanel.this.timekeeper.setLandmarkSite("BEA");
                } else if (M24ControlsPanel.this.showLonlatTimeButton.isSelected()) {
                    M24ControlsPanel.this.timekeeper.setSite(M24ControlsPanel.this.timeSiteLonTF.getText(), M24ControlsPanel.this.timeSiteLatTF.getText());
                    String val = (String)timeFormMenu.getSelectedItem();
                    if (val.indexOf("Mean Solar") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(2);
                    } else if (val.indexOf("True Solar") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(1);
                    } else if (val.indexOf("Zonal") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(3);
                    } else if (val.indexOf("Coordinated") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(4);
                    }
                }
            }
        };
        this.showLonlatTimeButton.addActionListener(timeButtonAL);
        this.showMERATimeButton.addActionListener(timeButtonAL);
        this.showMERBTimeButton.addActionListener(timeButtonAL);
        this.showMERABTimeButton.addActionListener(timeButtonAL);
        this.showBeagleTimeButton.addActionListener(timeButtonAL);
        ActionListener timesiteAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (M24ControlsPanel.this.showLonlatTimeButton.isSelected()) {
                    M24ControlsPanel.this.timekeeper.setSite(M24ControlsPanel.this.timeSiteLonTF.getText(), M24ControlsPanel.this.timeSiteLatTF.getText());
                }
            }
        };
        this.timeSiteLonTF.addActionListener(timesiteAL);
        this.timeSiteLatTF.addActionListener(timesiteAL);
        FocusListener timeSiteFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (M24ControlsPanel.this.showLonlatTimeButton.isSelected()) {
                    M24ControlsPanel.this.timekeeper.setSite(M24ControlsPanel.this.timeSiteLonTF.getText(), M24ControlsPanel.this.timeSiteLatTF.getText());
                }
            }
        };
        this.timeSiteLonTF.addFocusListener(timeSiteFL);
        this.timeSiteLatTF.addFocusListener(timeSiteFL);
        timeFormMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (M24ControlsPanel.this.showLonlatTimeButton.isSelected() && e.getStateChange() == 1) {
                    String val = (String)timeFormMenu.getSelectedItem();
                    if (val.indexOf("Mean Solar") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(2);
                    } else if (val.indexOf("True Solar") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(1);
                    } else if (val.indexOf("Zonal") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(3);
                    } else if (val.indexOf("Coordinated") > 0) {
                        M24ControlsPanel.this.timePanel.setTimeForm(4);
                    }
                }
            }
        });
        return panel;
    }

    private JPanel createDisplayControls() {
        final JPanel displayPanel = new JPanel();
        displayPanel.setBorder(EMPTY6_BORDER);
        displayPanel.setLayout(new BoxLayout(displayPanel, 1));
        JLabel displayLabel = new JLabel("Show: ");
        this.displayMenu = new JComboBox<String>(M24PlotPanel.DISPLAY_CHOICES);
        this.displayMenu.setSelectedIndex(this.plotPanel.getDisplayID());
        this.displayMenu.setMaximumSize(this.displayMenu.getPreferredSize());
        final JPanel sunclockPanel = this.createSunclockControls();
        final JPanel orbitPanel = this.createOrbitControls();
        final JPanel horizonPanel = this.createHorizonControls();
        this.currentDisplay = this.plotPanel.getDisplayID() == 1 ? orbitPanel : (this.plotPanel.getDisplayID() == 2 ? horizonPanel : sunclockPanel);
        int minWidth = sunclockPanel.getPreferredSize().width;
        minWidth = Math.max(minWidth, orbitPanel.getPreferredSize().width);
        minWidth = Math.max(minWidth, horizonPanel.getPreferredSize().width);
        int minHeight = sunclockPanel.getPreferredSize().height;
        minHeight = Math.max(minHeight, orbitPanel.getPreferredSize().height);
        minHeight = Math.max(minHeight, horizonPanel.getPreferredSize().height);
        sunclockPanel.setMinimumSize(new Dimension(minWidth, sunclockPanel.getPreferredSize().height));
        orbitPanel.setMinimumSize(new Dimension(minWidth, orbitPanel.getPreferredSize().height));
        horizonPanel.setMinimumSize(new Dimension(minWidth, horizonPanel.getPreferredSize().height));
        sunclockPanel.setPreferredSize(sunclockPanel.getMinimumSize());
        orbitPanel.setPreferredSize(orbitPanel.getMinimumSize());
        horizonPanel.setPreferredSize(horizonPanel.getMinimumSize());
        Box menuBox = Box.createHorizontalBox();
        menuBox.add(Box.createHorizontalGlue());
        menuBox.add(displayLabel);
        menuBox.add(this.displayMenu);
        menuBox.add(Box.createHorizontalGlue());
        displayPanel.add(menuBox);
        displayPanel.add(Box.createVerticalStrut(6));
        displayPanel.add(this.currentDisplay);
        this.displayMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                int choice = M24ControlsPanel.this.displayMenu.getSelectedIndex();
                M24ControlsPanel.this.plotPanel.setDisplayID(choice);
                displayPanel.remove(M24ControlsPanel.this.currentDisplay);
                if (choice == 0) {
                    M24ControlsPanel.this.currentDisplay = sunclockPanel;
                } else if (choice == 1) {
                    M24ControlsPanel.this.currentDisplay = orbitPanel;
                } else if (choice == 2) {
                    M24ControlsPanel.this.currentDisplay = horizonPanel;
                }
                displayPanel.add(M24ControlsPanel.this.currentDisplay);
                displayPanel.revalidate();
                JFrame f = (JFrame)M24ControlsPanel.this.getTopLevelAncestor();
                if (f != null) {
                    f.pack();
                }
            }
        });
        return displayPanel;
    }

    private JPanel createOrbitControls() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Display Options"));
        JLabel msg = new JLabel("There are no options for this display.");
        panel.add(msg);
        return panel;
    }

    private JPanel createHorizonControls() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Display Options"));
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel horizonLabel = new JLabel("Centered ", 4);
        JComboBox<String> horizonMenu = new JComboBox<String>();
        horizonMenu.addItem("Looking South");
        horizonMenu.addItem("Looking North");
        horizonMenu.setMaximumSize(horizonMenu.getPreferredSize());
        if (this.plotPanel.getHorizonCenter() == 2) {
            horizonMenu.setSelectedIndex(0);
        } else {
            horizonMenu.setSelectedIndex(1);
        }
        Box menuBox = Box.createHorizontalBox();
        menuBox.add(horizonLabel);
        menuBox.add(horizonMenu);
        menuBox.add(Box.createHorizontalGlue());
        panel.add(menuBox);
        panel.add(Box.createVerticalGlue());
        horizonMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JComboBox menu = (JComboBox)e.getSource();
                    String val = (String)menu.getSelectedItem();
                    if (val.indexOf("North") > 0) {
                        M24ControlsPanel.this.plotPanel.setHorizonCenter(1);
                    } else {
                        M24ControlsPanel.this.plotPanel.setHorizonCenter(2);
                    }
                }
            }
        });
        return panel;
    }

    private JPanel createSunclockControls() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Options"));
        JLabel mapLabel = new JLabel("Map Projection: ");
        final JComboBox<Object> mapMenu = new JComboBox<Object>(M24PlotPanel.getMapChoices());
        mapMenu.setSelectedIndex(this.plotPanel.getMapID());
        mapMenu.setMaximumSize(mapMenu.getPreferredSize());
        Box menuBox = Box.createHorizontalBox();
        menuBox.add(mapLabel);
        menuBox.add(mapMenu);
        menuBox.add(Box.createHorizontalGlue());
        JLabel copLocLabel = new JLabel("Center of Map:");
        JPanel copPanel = this.makeSunclockCOPPanel();
        JLabel markLabel = new JLabel("Mark: ", 4);
        JCheckBox markSubsolarCB = new JCheckBox("Sun/time points ", false);
        this.markLLGridCB = new JCheckBox("Lon-lat grid ", false);
        ArrayList<JCheckBox> marks = new ArrayList<JCheckBox>();
        marks.add(markSubsolarCB);
        int i = 0;
        while (i < this.landmarks.count()) {
            final Landmark l = this.landmarks.getElement(i);
            if (l.getType() == 2 || l.getType() == 1) {
                l.addLandmarkListener(this.plotPanel);
                JCheckBox cb = new JCheckBox(l.getName(), l.isMarked());
                cb.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        l.setMarked(((JCheckBox)e.getSource()).isSelected());
                    }
                });
                marks.add(cb);
            }
            ++i;
        }
        marks.add(this.markLLGridCB);
        markSubsolarCB.setSelected(this.plotPanel.getMarkSubsolar());
        this.markLLGridCB.setSelected(this.plotPanel.getMarkLLGrid());
        markSubsolarCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                M24ControlsPanel.this.plotPanel.setMarkSubsolar(cb.isSelected());
            }
        });
        this.markLLGridCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                M24ControlsPanel.this.plotPanel.setMarkLLGrid(cb.isSelected());
            }
        });
        mapMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    M24ControlsPanel.this.plotPanel.setMapID(mapMenu.getSelectedIndex());
                    String mChoice = (String)mapMenu.getSelectedItem();
                    boolean azimuthal = Projection.isAzimuthal(mChoice);
                    M24ControlsPanel.this.copLatTF.setVisible(azimuthal);
                    M24ControlsPanel.this.copLatTF.setEnabled(azimuthal);
                    M24ControlsPanel.this.copLabel3.setVisible(azimuthal);
                    M24ControlsPanel.this.copLabel4.setVisible(azimuthal);
                    M24ControlsPanel.this.markLLGridCB.setVisible(mChoice.indexOf("Equirect") > -1);
                    M24ControlsPanel.this.markLLGridCB.setEnabled(mChoice.indexOf("Equirect") > -1);
                }
            }
        });
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(3, 6 + (marks.size() + 1) / 2), 2, 4);
        fgl.setColumnWeight(0, 0.0f);
        fgl.setColumnWeight(1, 0.0f);
        fgl.setColumnWeight(2, 1.0f);
        panel.setLayout(fgl);
        panel.add((Component)menuBox, new FGConstraint(new Rectangle(0, 0, 3, 1), 0.0, 0.5));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 1, 3, 1), 0.0, 0.5));
        panel.add((Component)copLocLabel, new FGConstraint(new Rectangle(0, 2, 3, 1), 0.0, 0.5));
        panel.add((Component)copPanel, new FGConstraint(new Rectangle(0, 3, 3, 1), 0.0, 0.0));
        panel.add(Box.createVerticalStrut(6), new FGConstraint(new Rectangle(0, 4, 3, 1), 0.0, 0.5));
        panel.add((Component)markLabel, new FGConstraint(new Rectangle(0, 5, 1, 1), 0.0, 0.5));
        int i2 = 0;
        while (i2 < marks.size()) {
            if (i2 % 2 == 0) {
                panel.add((Component)((JCheckBox)marks.get(i2)), new FGConstraint(new Rectangle(1, 5 + i2 / 2, 1, 1), 0.0, 0.5));
            } else {
                panel.add((Component)((JCheckBox)marks.get(i2)), new FGConstraint(new Rectangle(2, 5 + i2 / 2, 1, 1), 0.0, 0.5));
            }
            ++i2;
        }
        return panel;
    }

    private JPanel makeSunclockCOPPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        final JRadioButton useLandmarkCOP = new JRadioButton("", this.timekeeper.getMethod() == 2);
        this.useLonlatCOP = new JRadioButton("", this.timekeeper.getMethod() == 2);
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(useLandmarkCOP);
        methodGroup.add(this.useLonlatCOP);
        this.useLonlatCOP.setSelected(true);
        JLabel copLandmarkLabel = new JLabel("Landmark: ");
        this.copMenu = new JComboBox();
        int lsize = this.landmarks.count();
        int i = 0;
        while (i < lsize) {
            Landmark l = this.landmarks.getElement(i);
            if (l.getType() == 2) {
                this.copMenu.addItem(l.getName() + " site");
            } else if (l.getType() == 1) {
                this.copMenu.addItem(l.getName() + " site");
            } else if (l.getType() == 3) {
                this.copMenu.addItem(l.getName() + " site");
            } else if (l.getType() == 4) {
                this.copMenu.addItem(l.getName());
            }
            if (l.getName().indexOf("MER-A") > -1) {
                this.copMenu.setSelectedIndex(i);
            }
            ++i;
        }
        JLabel copLabel1 = new JLabel("Longitude ");
        JLabel copLabel2 = new JLabel("\u00b0W");
        this.copLonTF.setMaximumSize(this.copLonTF.getPreferredSize());
        this.copLatTF.setMaximumSize(this.copLatTF.getPreferredSize());
        Box landmarkBox = Box.createHorizontalBox();
        landmarkBox.add(useLandmarkCOP);
        landmarkBox.add(copLandmarkLabel);
        landmarkBox.add(this.copMenu);
        landmarkBox.add(Box.createHorizontalGlue());
        Box lonlatBox = Box.createHorizontalBox();
        lonlatBox.add(this.useLonlatCOP);
        lonlatBox.add(copLabel1);
        lonlatBox.add(this.copLonTF);
        lonlatBox.add(copLabel2);
        lonlatBox.add(this.copLabel3);
        lonlatBox.add(this.copLatTF);
        lonlatBox.add(this.copLabel4);
        lonlatBox.add(Box.createHorizontalGlue());
        panel.add(landmarkBox);
        panel.add(Box.createVerticalStrut(6));
        panel.add(lonlatBox);
        this.setCOPFields(true);
        ActionListener copAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (useLandmarkCOP.isSelected()) {
                    String val = (String)M24ControlsPanel.this.copMenu.getSelectedItem();
                    int i = 0;
                    while (i < M24ControlsPanel.this.landmarks.count()) {
                        Landmark l = M24ControlsPanel.this.landmarks.getElement(i);
                        if (val.indexOf(l.getName()) > -1) {
                            M24ControlsPanel.this.plotPanel.setCOP(l.getLongitude(), l.getLatitude());
                            break;
                        }
                        ++i;
                    }
                } else if (M24ControlsPanel.this.useLonlatCOP.isSelected()) {
                    M24ControlsPanel.this.plotPanel.setCOP(M24ControlsPanel.this.copLonTF.getText(), M24ControlsPanel.this.copLatTF.getText());
                }
            }
        };
        useLandmarkCOP.addActionListener(copAL);
        this.useLonlatCOP.addActionListener(copAL);
        this.copLonTF.addActionListener(copAL);
        this.copLatTF.addActionListener(copAL);
        this.copMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (useLandmarkCOP.isSelected() && e.getStateChange() == 1) {
                    String val = (String)M24ControlsPanel.this.copMenu.getSelectedItem();
                    int i = 0;
                    while (i < M24ControlsPanel.this.landmarks.count()) {
                        Landmark l = M24ControlsPanel.this.landmarks.getElement(i);
                        if (val.indexOf(l.getName()) > -1) {
                            M24ControlsPanel.this.plotPanel.setCOP(l.getLongitude(), l.getLatitude());
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        FocusListener copFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (M24ControlsPanel.this.useLonlatCOP.isSelected()) {
                    M24ControlsPanel.this.plotPanel.setCOP(M24ControlsPanel.this.copLonTF.getText(), M24ControlsPanel.this.copLatTF.getText());
                }
            }
        };
        this.copLonTF.addFocusListener(copFL);
        this.copLatTF.addFocusListener(copFL);
        return panel;
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (((String)this.displayMenu.getSelectedItem()).equals("Sunclock Map") && x < this.plotPanel.getSize().width && y < this.plotPanel.getSize().height) {
            PointDouble pd = this.plotPanel.transformXY2LL(x, y);
            if (pd == null) {
                return;
            }
            if (e.isShiftDown()) {
                this.plotPanel.setCOP(pd.x, pd.y);
                this.setCOPFields(true);
                this.useLonlatCOP.setSelected(true);
            } else if (e.isAltDown() && this.showLonlatTimeButton.isSelected()) {
                this.timekeeper.setSite(pd.x, pd.y);
                this.setTimeSiteFields(true);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void setTimeSiteFields(boolean roundOff) {
        double lon = this.timekeeper.getSiteLongitude();
        double lat = this.timekeeper.getSiteLatitude();
        if (roundOff) {
            this.timeSiteLonTF.setText(FORMAT_X2.format(lon));
            this.timeSiteLatTF.setText(FORMAT_X2.format(lat));
        } else {
            this.timeSiteLonTF.setText(lon + "");
            this.timeSiteLatTF.setText(lat + "");
        }
    }

    private void handleOffsetTimeFields() {
        try {
            double d = Double.parseDouble(this.dOffsetTF.getText());
            double h = Double.parseDouble(this.hOffsetTF.getText());
            double m = Double.parseDouble(this.mOffsetTF.getText());
            double s = Double.parseDouble(this.sOffsetTF.getText());
            this.timekeeper.setShowOffset((long)((d * 86400.0 + h * 3600.0 + m * 60.0 + s) * 1000.0));
        }
        catch (Exception exc) {
            this.timekeeper.setShowOffset(Long.MIN_VALUE);
        }
    }

    private void setCOPFields(boolean roundOff) {
        if (roundOff) {
            this.copLonTF.setText(FORMAT_X2.format(this.plotPanel.getCOPLongitude()));
            this.copLatTF.setText(FORMAT_X2.format(this.plotPanel.getCOPLatitude()));
        } else {
            this.copLonTF.setText(this.plotPanel.getCOPLongitude() + "");
            this.copLatTF.setText(this.plotPanel.getCOPLatitude() + "");
        }
    }
}

