/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCTreeTableNode;
import gov.nasa.giss.netcdf.NCVariable;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.conv.Convention;

public class NCDataset
extends NCTreeTableNode {
    private static final String PATH_SEP = System.getProperty("file.separator");
    private NetcdfFile ncf;
    private NetcdfDataset ncd;
    private URL url;
    private Object[] children;
    private boolean listAllVars = true;

    public NCDataset() throws IOException, FileNotFoundException, MalformedURLException {
        throw new IllegalArgumentException("Please use another constructor");
    }

    public NCDataset(File f) throws IOException, FileNotFoundException, MalformedURLException {
        this(f.toURL());
    }

    public NCDataset(URL url) throws IOException, FileNotFoundException {
        this.init(url);
    }

    private void init(URL url) throws IOException, FileNotFoundException {
        this.url = url;
        this.ncf = NetcdfDataset.factory((String)url.toString(), null);
        this.ncd = Convention.factory((NetcdfFile)this.ncf);
    }

    public URL getURL() {
        return this.url;
    }

    public NetcdfDataset getDataset() {
        return this.ncd;
    }

    public Dimension findDimension(String name) {
        return this.ncd.findDimension(name);
    }

    public Attribute findGlobalAttribute(String name) {
        return this.ncd.findGlobalAttribute(name);
    }

    public String getPathName() {
        return this.ncd.getPathName();
    }

    public VariableDS findVariable(String name) {
        return (VariableDS)this.ncd.findVariable(name);
    }

    public void close() throws IOException {
        this.ncd.close();
    }

    public void setListAllVariables(boolean listAllVars) {
        this.listAllVars = listAllVars;
        this.children = null;
        Object[] objectArray = this.getChildren();
    }

    public Object getObject() {
        return this;
    }

    public String getName() {
        String pathName = this.getPathName();
        int lastSeparator = pathName.lastIndexOf(PATH_SEP);
        if (lastSeparator > -1) {
            return pathName.substring(lastSeparator + 1);
        }
        return pathName;
    }

    public String getLongName() {
        try {
            return this.ncd.findGlobalAttribute("title").getStringValue();
        }
        catch (Exception exc) {
            return "-";
        }
    }

    public String getDetail() {
        StringBuffer sb = new StringBuffer("netCDF file \"");
        sb.append(this.getName()).append("\"\n");
        sb.append("--------\n");
        sb.append(this.ncd.toString());
        return sb.toString();
    }

    public int getChildCount() {
        if (this.children == null) {
            Object[] objectArray = this.getChildren();
        }
        return this.children.length;
    }

    public Object[] getChildren() {
        block7: {
            if (this.children != null) {
                return this.children;
            }
            ArrayList<String> childNames = new ArrayList<String>(20);
            try {
                Iterator iter = this.ncd.getVariableIterator();
                while (iter.hasNext()) {
                    VariableDS varDS = (VariableDS)iter.next();
                    if (!this.listAllVars && NCVariable.getPlottingType(varDS) == 0) continue;
                    childNames.add(varDS.getName());
                }
            }
            catch (Exception exc) {
                System.out.println("getChildren error " + exc.toString());
            }
            try {
                if (childNames.size() <= 0) break block7;
                Collections.sort(childNames);
                int isize = childNames.size();
                this.children = new NCTreeTableNode[isize];
                int i = 0;
                while (i < isize) {
                    this.children[i] = new NCVariable(this, (String)childNames.get(i));
                    ++i;
                }
            }
            catch (Exception exc) {}
        }
        return this.children;
    }

    public static File selectFile(Frame parent) throws IOException, FileNotFoundException, MalformedURLException {
        FileDialog fd = new FileDialog(parent, "Please select a netCDF dataset.", 0);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.toLowerCase().endsWith(".nc")) {
                    return true;
                }
                return new File(dir, name).isDirectory();
            }
        };
        fd.setFilenameFilter(filter);
        ((Component)fd).setVisible(true);
        if (fd.getFile() == null) {
            throw new FileNotFoundException("No file was selected.");
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        return f;
    }
}

