/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.netcdf;

import gov.nasa.giss.netcdf.NCDataset;
import gov.nasa.giss.netcdf.NCDimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.EventListenerList;
import ucar.nc2.Dimension;

public class NCDimensionChoice
extends JPanel
implements SwingConstants,
ActionListener,
FocusListener,
ItemListener {
    private EventListenerList listenerList = new EventListenerList();
    private NCDimension ncdim;
    private JComboBox menu;
    private JTextField indexTF;
    private int hAlignment = 2;
    private int vAlignment = 1;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public NCDimensionChoice(NCDataset dataset, String dimName) {
        this(dataset, dimName, false);
    }

    public NCDimensionChoice(NCDataset dataset, String dimName, boolean appendAvg) {
        this(dataset, dataset.findDimension(dimName), appendAvg);
    }

    public NCDimensionChoice(NCDataset dataset, Dimension dimension) {
        this(dataset, dimension, false);
    }

    public NCDimensionChoice(NCDataset dataset, Dimension dimension, boolean appendAvg) {
        this.ncdim = new NCDimension(dataset, dimension);
        this.setLayout(new BoxLayout(this, 0));
        String lname = this.getLongName();
        if (lname.indexOf(" (") > -1) {
            lname = lname.substring(0, lname.indexOf(" ("));
        }
        if (this.ncdim.getItemCount() == 1) {
            JLabel slabel = new JLabel(lname + ": 1 of 1 = " + this.ncdim.getValues()[0]);
            Font labelFont = slabel.getFont().deriveFont((float)(slabel.getFont().getSize() - 2));
            slabel.setFont(labelFont);
            slabel.setAlignmentY(0.5f);
            this.add(slabel);
            this.add(Box.createHorizontalGlue());
            return;
        }
        JLabel slabel = new JLabel(lname + ": ");
        int cols = 3;
        if (cols > 999) {
            cols = 5;
        } else if (cols > 99) {
            cols = 4;
        }
        this.indexTF = new JTextField("1", cols);
        this.menu = new JComboBox<Object>(this.ncdim.getValues());
        if (appendAvg) {
            this.menu.addItem("Average");
        }
        JLabel clabel = new JLabel(" of " + this.menu.getItemCount() + " = ");
        Font labelFont = slabel.getFont().deriveFont((float)(slabel.getFont().getSize() - 2));
        Font fieldFont = this.indexTF.getFont().deriveFont((float)(this.indexTF.getFont().getSize() - 2));
        Font comboFont = this.menu.getFont().deriveFont((float)(this.menu.getFont().getSize() - 2));
        slabel.setFont(labelFont);
        this.menu.setFont(comboFont);
        this.indexTF.setFont(fieldFont);
        clabel.setFont(labelFont);
        this.indexTF.setMinimumSize(this.indexTF.getPreferredSize());
        this.indexTF.setMaximumSize(this.indexTF.getPreferredSize());
        this.menu.setMaximumSize(this.menu.getPreferredSize());
        this.menu.addItemListener(this);
        this.indexTF.addActionListener(this);
        this.indexTF.addFocusListener(this);
        slabel.setAlignmentY(0.5f);
        this.menu.setAlignmentY(0.5f);
        this.indexTF.setAlignmentY(0.5f);
        clabel.setAlignmentY(0.5f);
        this.add(slabel);
        this.add(this.indexTF);
        this.add(clabel);
        this.add(this.menu);
        this.add(Box.createHorizontalGlue());
    }

    public String getLongName() {
        return this.ncdim.getLongName();
    }

    public String getUnits() {
        return this.ncdim.getUnits();
    }

    public int getItemCount() {
        return this.ncdim.getItemCount();
    }

    public int getSelectedIndex() {
        if (this.menu != null) {
            return this.menu.getSelectedIndex();
        }
        return 1;
    }

    public void setSelectedIndex(int index) {
        if (this.menu != null) {
            this.menu.setSelectedIndex(index);
            this.indexTF.setText(index + "");
        }
    }

    public Object getSelectedItem() {
        if (this.menu != null) {
            return this.menu.getSelectedItem();
        }
        return this.ncdim.getValues()[0];
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = NCDimensionChoice.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = NCDimensionChoice.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void fireAction() {
        ActionEvent e = new ActionEvent(this, 0, null);
        EventListener[] listeners = this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = NCDimensionChoice.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
        int i = 0;
        while (i < listeners.length) {
            ((ActionListener)listeners[i]).actionPerformed(e);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            int intval = Integer.parseInt(this.indexTF.getText());
            if (intval < 1) {
                intval = 1;
            }
            if (intval > this.menu.getItemCount()) {
                intval = this.menu.getItemCount();
            }
            if (this.menu != null) {
                this.menu.setSelectedIndex(intval - 1);
            }
            this.fireAction();
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.indexTF.setText(this.menu.getSelectedIndex() + 1 + "");
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        try {
            int intval = Integer.parseInt(this.indexTF.getText());
            if (intval < 1) {
                intval = 1;
            }
            if (intval > this.menu.getItemCount()) {
                intval = this.menu.getItemCount();
            }
            if (this.menu != null) {
                this.menu.setSelectedIndex(intval - 1);
            }
            this.fireAction();
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.indexTF.setText(this.menu.getSelectedIndex() + 1 + "");
    }

    public void itemStateChanged(ItemEvent e) {
        this.indexTF.setText(this.menu.getSelectedIndex() + 1 + "");
        this.fireAction();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

