/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.math.Constants;
import gov.nasa.giss.math.Mathlib;
import gov.nasa.giss.time.JulianDate;
import gov.nasa.giss.time.MissionTime;
import java.text.DecimalFormat;

public class MarsTime
extends JulianDate {
    private static final DecimalFormat FORMAT_20 = new DecimalFormat("00");
    public static final int MEAN_SOLAR = 1;
    public static final int TRUE_SOLAR = 2;
    public static final double TIME_RATIO = 1.027491252;
    private static final double[] PBS_A = new double[]{0.0, 0.0071, 0.0057, 0.0039, 0.0037, 0.0021, 0.002, 0.0018, 0.0};
    private static final double[] PBS_PHI = new double[]{0.0, 49.409, 168.173, 191.837, 21.736, 15.704, 95.528, 49.095, 0.0};
    private static final double DEG_DAY = 0.9856262833675564;
    private static final double[] PBS_TAU_INV = new double[]{0.9856262833675564, 0.4409369137778179, 0.3578500102993706, 0.8818343771741581, 0.062434361000313965, 0.4615651790613264, 0.399135937218578, 0.03000448360749107};
    private static final long MERA_LAUNCH = 1055267927000L;
    private static final long MERB_LAUNCH = 1057634295000L;
    private static final long BEAGLE_LAUNCH = 1054579526000L;
    public double meanAnomalyRad = 0.0;
    public double alphaFMS = 0.0;
    public double ellS = 0.0;
    public double ellSRad = 0.0;
    public double deltaS = 0.0;
    public double rM = 0.0;
    public double lambdaM = 0.0;
    public double psiM = 0.0;
    public double equationOfTime = 0.0;
    public double primeMeridian = 0.0;

    public MarsTime() {
        super(System.currentTimeMillis());
        this.calculate();
    }

    public MarsTime(long t) {
        super(t);
        this.calculate();
    }

    public void setTime(long t) {
        super.setTime(t);
        this.calculate();
    }

    private void calculate() {
        this.meanAnomalyRad = Mathlib.toRadians(19.387 + 0.52402075 * this.delta2000);
        double sin1MeanAnom = Math.sin(this.meanAnomalyRad);
        double sin2MeanAnom = Math.sin(2.0 * this.meanAnomalyRad);
        double sin3MeanAnom = Math.sin(3.0 * this.meanAnomalyRad);
        double sin4MeanAnom = Math.sin(4.0 * this.meanAnomalyRad);
        double sin5MeanAnom = Math.sin(5.0 * this.meanAnomalyRad);
        this.alphaFMS = 270.3863 + 0.5240384 * this.delta2000;
        double pbs = 0.0;
        int k = 1;
        while (k < 8) {
            pbs += PBS_A[k] * Math.cos((PBS_TAU_INV[k] * this.delta2000 + PBS_PHI[k]) * Constants.RAD_PER_DEG);
            ++k;
        }
        this.ellS = this.alphaFMS + (10.691 + 3.0E-7 * this.delta2000) * sin1MeanAnom + 0.623 * sin2MeanAnom + 0.05 * sin3MeanAnom + 0.005 * sin4MeanAnom + 5.0E-4 * sin5MeanAnom + pbs;
        while (this.ellS < 0.0) {
            this.ellS += 360.0;
        }
        while (this.ellS > 360.0) {
            this.ellS -= 360.0;
        }
        this.ellSRad = Mathlib.toRadians(this.ellS);
        this.deltaS = Mathlib.toDegrees(Math.asin(0.42565 * Math.sin(this.ellSRad))) + 0.25 * Math.sin(this.ellSRad);
        this.rM = 1.523679 * (1.00436 - 0.09309 * Math.cos(this.meanAnomalyRad) - 0.004336 * Math.cos(2.0 * this.meanAnomalyRad) - 3.1E-4 * Math.cos(3.0 * this.meanAnomalyRad) - 3.0E-5 * Math.cos(4.0 * this.meanAnomalyRad));
        this.lambdaM = this.ellS + 85.061 - 5.5E-6 * this.delta2000 - 0.015 * Math.sin(Mathlib.toRadians(2.0 * this.ellS + 71.0));
        while (this.lambdaM < 0.0) {
            this.lambdaM += 360.0;
        }
        while (this.lambdaM > 360.0) {
            this.lambdaM -= 360.0;
        }
        this.psiM = -(1.8497 - 2.23E-5 * this.delta2000) * Math.sin(Mathlib.toRadians(this.ellS - 144.5 + 2.57E-6 * this.delta2000));
        this.equationOfTime = 2.861 * Math.sin(2.0 * this.ellSRad) - 0.071 * Math.sin(4.0 * this.ellSRad) + 0.002 * Math.sin(6.0 * this.ellSRad) - ((10.691 + 3.0E-7 * this.delta2000) * sin1MeanAnom + 0.623 * sin2MeanAnom + 0.05 * sin3MeanAnom + 0.005 * sin4MeanAnom + 5.0E-4 * sin5MeanAnom + pbs);
        this.primeMeridian = 313.384 + 350.8919852 * this.delta2000;
        while (this.primeMeridian < 0.0) {
            this.primeMeridian += 360.0;
        }
        while (this.primeMeridian > 360.0) {
            this.primeMeridian -= 360.0;
        }
    }

    public double getSolarLongitude() {
        return this.ellS;
    }

    public double getSolarDeclination() {
        return this.deltaS;
    }

    public double getSubsolarLongitude() {
        double result = 15.0 * this.getTime(0.0, 2) - 180.0;
        while (result < 0.0) {
            result += 360.0;
        }
        while (result > 360.0) {
            result -= 360.0;
        }
        return result;
    }

    public double getHeliocentricLongitude() {
        return this.lambdaM;
    }

    public double getHeliocentricLatitude() {
        return this.psiM;
    }

    public double getHeliocentricDistance() {
        return this.rM;
    }

    public double getMarsSolDate() {
        return (this.jdTT - 2400000.5 - 51549.0) / 1.027491252 + 44796.0 - 9.6E-4;
    }

    public double getTime(double lon, int timeType) {
        double mst0 = 44795.99904 + (this.jdTT - 2451549.5) / 1.027491252;
        double mst = (mst0 - (double)((long)mst0)) * 24.0;
        double result = mst - lon * 0.06666666666666667;
        if (timeType == 2) {
            result += this.equationOfTime / 15.0;
        }
        while (result < 0.0) {
            result += 24.0;
        }
        while (result >= 24.0) {
            result -= 24.0;
        }
        return result;
    }

    public String getTimestr(double lon, int timeType) {
        return this.getTimestr(lon, timeType, true);
    }

    public String getTimestr(double lon, int timeType, boolean appendType) {
        double localTime = this.getTime(lon, timeType);
        long tHour = (long)localTime;
        long tMin = (long)((localTime - (double)tHour) * 60.0);
        long tSec = (long)(((localTime - (double)tHour) * 60.0 - (double)tMin) * 60.0);
        StringBuffer result = new StringBuffer(FORMAT_20.format(tHour) + ":" + FORMAT_20.format(tMin) + ":" + FORMAT_20.format(tSec));
        if (appendType) {
            if (timeType == 2) {
                result.append(" LTST");
            } else {
                result.append(" LMST");
            }
        }
        return result.toString();
    }

    public double getZenithAngle(double lon, double lat) {
        double subsolarLat = this.getSolarDeclination();
        double subsolarLong = this.getSubsolarLongitude();
        double cosLatitudeS = Math.cos(Mathlib.toRadians(subsolarLat));
        double sinLatitudeS = Math.sin(Mathlib.toRadians(subsolarLat));
        double cosDTheta = Math.cos(Mathlib.toRadians(subsolarLong - lon));
        double cosLatitudeX = Math.cos(Mathlib.toRadians(lat));
        double sinLatitudeX = Math.sin(Mathlib.toRadians(lat));
        return Mathlib.toDegrees(Math.acos(sinLatitudeS * sinLatitudeX + cosLatitudeS * cosLatitudeX * cosDTheta));
    }

    public double getAzimuthAngle(double lon, double lat) {
        double zenithAngle = this.getZenithAngle(lon, lat);
        if (zenithAngle > 0.0) {
            double subsolarLat = this.getSolarDeclination();
            double subsolarLong = this.getSubsolarLongitude();
            double cosLatitudeS = Math.cos(Mathlib.toRadians(subsolarLat));
            double sinLatitudeS = Math.sin(Mathlib.toRadians(subsolarLat));
            if (cosLatitudeS == 0.0) {
                return 0.0;
            }
            double hourAngle = lon - subsolarLong;
            if (hourAngle > 180.0) {
                hourAngle -= 360.0;
            } else if (hourAngle < -180.0) {
                hourAngle += 360.0;
            }
            double cosLatitudeX = Math.cos(Mathlib.toRadians(lat));
            double sinLatitudeX = Math.sin(Mathlib.toRadians(lat));
            double cosDTheta = Math.cos(Mathlib.toRadians(hourAngle));
            double sinDTheta = Math.sin(Mathlib.toRadians(hourAngle));
            return Mathlib.toDegrees(Math.atan2(sinDTheta, cosLatitudeX * sinLatitudeS / cosLatitudeS - sinLatitudeX * cosDTheta));
        }
        return 0.0;
    }

    public String getSeason(boolean inNorth) {
        String theSeason;
        long theSeasonNo;
        if (inNorth) {
            if (this.ellS >= 0.0 && this.ellS <= 0.5 || this.ellS >= 359.5 && this.ellS <= 360.0) {
                return "NH Vernal Equinox";
            }
            if (this.ellS >= 89.5 && this.ellS <= 90.5) {
                return "NH Summer Solstice";
            }
            if (this.ellS >= 179.5 && this.ellS <= 180.5) {
                return "NH Autumnal Equinox";
            }
            if (this.ellS >= 269.0 && this.ellS <= 270.5) {
                return "NH Winter Solstice";
            }
            theSeasonNo = (long)(this.ellS / 90.0);
            theSeason = theSeasonNo == 0L ? "NH Spring" : (theSeasonNo == 1L ? "NH Summer" : (theSeasonNo == 2L ? "NH Autumn" : "NH Winter"));
        } else {
            if (this.ellS >= 0.0 && this.ellS <= 0.5 || this.ellS >= 359.5 && this.ellS <= 360.0) {
                return "SH Autumnal Equinox";
            }
            if (this.ellS >= 89.5 && this.ellS <= 90.5) {
                return "SH Winter Solstice";
            }
            if (this.ellS >= 179.5 && this.ellS <= 180.5) {
                return "SH Vernal Equinox";
            }
            if (this.ellS >= 269.0 && this.ellS <= 270.5) {
                return "SH Summer Solstice";
            }
            theSeasonNo = (long)(this.ellS / 90.0);
            theSeason = theSeasonNo == 0L ? "SH Autumn" : (theSeasonNo == 1L ? "SH Winter" : (theSeasonNo == 2L ? "SH Spring" : "SH Summer"));
        }
        double theSection = this.ellS % 90.0;
        if (theSection < 30.0) {
            return "Early " + theSeason;
        }
        if (theSection < 60.0) {
            return "Mid " + theSeason;
        }
        return "Late " + theSeason;
    }

    public MissionTime getMissionTime(String landerID) {
        if (landerID == null) {
            throw new IllegalArgumentException("Null lander ID");
        }
        if (landerID.equals("MERA") || landerID.equals("MERB")) {
            double offset;
            double t0;
            if (landerID.equals("MERA")) {
                if (this.unixMillis < 1055267927000L) {
                    return new MissionTime();
                }
                t0 = 1.264096557E8;
                offset = 600.0;
            } else {
                if (this.unixMillis < 1057634295000L) {
                    return new MissionTime();
                }
                t0 = 1.282298048E8;
                offset = 780.0;
            }
            double lltSec = offset + (this.et2000 - t0) / 1.02749125;
            double llt = lltSec / 86400.0;
            if (llt > 0.0) {
                llt += 1.0;
            }
            long sol = (long)Math.floor(llt);
            return new MissionTime(sol, llt - (double)sol);
        }
        if (landerID.equals("BEA")) {
            long sx;
            if (this.unixMillis < 1054579526000L) {
                return new MissionTime();
            }
            double fraction = this.getTime(269.5, 2) / 24.0;
            long sol = (long)Math.floor((this.jdTT - 2452998.083046) / 1.027491252);
            if (fraction < 0.1) {
                long sx2 = (long)Math.floor((this.jdTT - 0.5 - 2452998.083046) / 1.027491252);
                if (sx2 == sol) {
                    ++sol;
                }
            } else if (fraction > 0.9 && (sx = (long)Math.floor((this.jdTT + 0.5 - 2452998.083046) / 1.027491252)) == sol) {
                --sol;
            }
            if (sol >= 0L) {
                ++sol;
            }
            return new MissionTime(sol, fraction);
        }
        throw new IllegalArgumentException("Unrecognized lander ID " + landerID);
    }
}

