/*
 * Decompiled with CFR 0.152.
 */
package bin;

import bin.Splash;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class AnimatedNotifier
extends JFrame {
    private static final long serialVersionUID = -1544117638651264444L;
    private boolean finished = true;
    private static BufferedImage[] animatingArray = new BufferedImage[26];
    private BufferedImage info;

    static {
        try {
            int n = 0;
            while (n < 26) {
                AnimatedNotifier.animatingArray[n] = ImageIO.read(new File("images/anims/sequence/" + n + ".jpg"));
                ++n;
            }
        }
        catch (Exception e) {
            System.exit(0);
        }
    }

    public AnimatedNotifier(String name) {
        try {
            this.info = ImageIO.read(new File("images/anims/" + name + ".jpg"));
        }
        catch (Exception e) {
            this.dispose();
        }
        this.setUndecorated(true);
        this.setSize(300, 200);
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(null);
    }

    public void stop() {
        if (!Splash.isNoWait()) {
            AnimatedNotifier.wait(750);
        }
        this.finished = true;
        this.dispose();
    }

    public void start() {
        this.finished = false;
        this.setVisible(true);
        this.createBufferStrategy(2);
        new Thread(){

            @Override
            public void run() {
                int n = 0;
                while (!AnimatedNotifier.this.finished || AnimatedNotifier.this.isVisible()) {
                    AnimatedNotifier.this.draw(n);
                    AnimatedNotifier.wait(20);
                    ++n;
                    n %= 26;
                }
            }
        }.start();
    }

    private void draw(int n) {
        Graphics2D g2d = (Graphics2D)this.getBufferStrategy().getDrawGraphics();
        if (g2d == null) {
            return;
        }
        g2d.setColor(Color.BLACK);
        g2d.fillRect(158, 0, 142, 200);
        g2d.drawImage(animatingArray[n], null, 0, 0);
        g2d.drawImage(this.info, null, 127, 25);
        g2d.dispose();
        this.getBufferStrategy().show();
    }

    public static void wait(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

