/*
 * Decompiled with CFR 0.152.
 */
package bin;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Paginator {
    private String[] pages;
    private int currentPage;

    public Paginator(String bufferText, FontMetrics metrics, int areaWidth, int areaHeight) {
        ArrayList<String> temp = new ArrayList<String>();
        StringTokenizer sT = new StringTokenizer(bufferText, " \n\t", true);
        int theAscent = metrics.getAscent();
        int spaceRemaining = areaWidth;
        int h = theAscent;
        String nT = "";
        String newPage = "";
        while (sT.hasMoreTokens()) {
            nT = sT.nextToken();
            int tokenWidth = metrics.stringWidth(nT);
            if (nT.equals(" ")) {
                if (spaceRemaining <= tokenWidth) {
                    newPage = String.valueOf(newPage) + "\n";
                    if ((h += theAscent) > areaHeight) {
                        temp.add(newPage);
                        newPage = "";
                        h = theAscent;
                    }
                    spaceRemaining = areaWidth;
                    continue;
                }
                newPage = String.valueOf(newPage) + " ";
                spaceRemaining -= tokenWidth;
                continue;
            }
            if (nT.equals("\n")) {
                newPage = String.valueOf(newPage) + "\n";
                if ((h += theAscent) > areaHeight) {
                    temp.add(newPage);
                    newPage = "";
                    h = theAscent;
                }
                spaceRemaining = areaWidth;
                continue;
            }
            if (nT.equals("\t")) {
                newPage = String.valueOf(newPage) + "\t";
                spaceRemaining = (spaceRemaining * 10 - 1) / areaWidth * areaWidth / 10;
                continue;
            }
            if (tokenWidth > areaWidth) {
                int i = 0;
                while (i < nT.length()) {
                    String oneLetter = nT.substring(i, i + 1);
                    int letterWidth = metrics.stringWidth(oneLetter);
                    if (metrics.stringWidth(String.valueOf(oneLetter) + "-") > spaceRemaining) {
                        newPage = String.valueOf(newPage) + "-\n";
                        if ((h += theAscent) > areaHeight) {
                            temp.add(newPage);
                            newPage = "";
                            h = theAscent;
                        }
                        spaceRemaining = areaWidth - letterWidth;
                        newPage = String.valueOf(newPage) + oneLetter;
                    } else {
                        newPage = String.valueOf(newPage) + oneLetter;
                        spaceRemaining -= letterWidth;
                    }
                    ++i;
                }
                continue;
            }
            if (tokenWidth > spaceRemaining) {
                newPage = String.valueOf(newPage) + "\n";
                if ((h += theAscent) > areaHeight) {
                    temp.add(newPage);
                    newPage = "";
                    h = theAscent;
                }
                spaceRemaining = areaWidth - tokenWidth;
                newPage = String.valueOf(newPage) + nT;
                continue;
            }
            newPage = String.valueOf(newPage) + nT;
            spaceRemaining -= tokenWidth;
        }
        if (newPage.length() > 0) {
            temp.add(newPage);
        }
        this.pages = new String[temp.size()];
        this.pages = temp.toArray(this.pages);
        this.currentPage = 0;
    }

    public String[] getPages() {
        return (String[])this.pages.clone();
    }

    public String getPage(int num) {
        if (this.pages.length == 0) {
            return "";
        }
        if (num < 0) {
            num = 0;
        } else if (num >= this.pages.length) {
            num = this.pages.length - 1;
        }
        this.currentPage = num;
        return this.pages[this.currentPage];
    }

    public String getNextPage() {
        if (this.currentPage < this.pages.length - 1) {
            ++this.currentPage;
        }
        return this.pages[this.currentPage];
    }

    public String getPrevPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        return this.pages[this.currentPage];
    }

    public int getPageCount() {
        return this.pages.length;
    }

    public int getCurrentPageNum() {
        return this.currentPage;
    }
}

