/**
 * @(#)LanguageGallery.java
 *
 * The LanguageGallery class to let the user 
 * select a language using a nice screen.
 * This class extends the abstract Gallery class.

 * @see Gallery
 * @author Devrim Sahin
 * @version 1.00 21.12.2009
 */

package bin;
 
public class LanguageGallery extends Gallery {
	
	/**
	 * <code>serialVersionUID</code><br>
	 * Created by Eclipse.
	 */
	private static final long serialVersionUID = -1239242952489118026L;
	
	/**
     * <code>d</code><br>
     * The Display object. Used when the new Language is applied.
     */
    private Display d;
	
    /**
     * The constructor. Takes a Display class as an argument and 
     * uses it when a Language item is clicked on to reload the 
     * Display object and see the change immediately.
     * @param d The Display object.
     */
    public LanguageGallery(Display d) {
    	// Call Gallery's constructor.
    	super(Language.getText(6),"languages",Language.languageCount(),255,255,255);
    	// Assign d
    	this.d = d;
    }
    
    /**
     * <code>onClick</code><br>
     * This method is called when a language is selected.
     * If the selected language is not the current one, 
     * the change is applied.
     * @param i Index of the selected language.
     */
    public void onClick(int i) {
    	// Hide this screen so that no one can play around
    	setVisible(false);
    	// If the current language is selected
    	if(i == Language.getLanguageIndex()) {
    		// Dispose the screen
    		dispose();
			// Return
	    	return;
    	}
    	// Change the font to i
    	Language.chooseLanguage(i);
		// Update everything
		d.updateConfig();
		// Create a new Display object
		new Display();
		// Dispose the current Display object
		d.dispose();
		// Dispose this gallery
		dispose();
    }
    
    /**
     * <code>onMouseOver</code><br>
     * This method is called when a language is hovered.
     * In this case, the name of the corresponding
     * language is returned to be shown.
     * @param i Index of the hovered language.
     */
    public String onMouseOver(int i) {
    	// Return the name of the corresponding language.
    	return Language.getLanguageName(i);
    }
}