package de.beagtex.control;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.CannotUndoException;

import de.beagtex.gui.Editor;

public class UndoAction extends AbstractAction {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param pEdtior:
	 *            the calling editor-object
	 */
	public UndoAction(Editor pEdtior) {
		this.editor = pEdtior;
		setEnabled(false);
	}

	public void actionPerformed(ActionEvent e) {

		actionPerformedEditor();
	}

	public void update() {

		updateEditor();
	}

	/**
	 * actionPerformed-method for Editor
	 * 
	 */
	private void actionPerformedEditor() {

		try {
			editor.getUndoMan().undo();
		} catch (CannotUndoException ex) {
			System.err.println("Kein weiterer Undo mglich!");
		}
		update();
		editor.redoAction.update();
	}

	/**
	 * update-Method for Editor
	 * 
	 */
	private void updateEditor() {

		if (editor.getUndoMan().canUndo()) {
			setEnabled(true);
			putValue(Action.NAME, editor.getUndoMan().getUndoPresentationName());
			editor.getBFrame().getBlButtons().getSaveB().setEnabled(true);
		} else {
			setEnabled(false);
			putValue(Action.NAME, "Undo");
		}
	}
}
