package de.beagtex.gui;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;

import de.beagtex.listener.format.StandardColorsListener;
import de.beagtex.listener.format.FormatListener;
import de.beagtex.listener.format.BGColorListener;
import de.beagtex.listener.format.TextSizeListener;

/**
 * Extended JToolBar filled with ComboBoxes for the different formatting-options
 * 
 * @author Benjamin Haag
 */
public class FormatBar extends JToolBar {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ComboBox for BackgroundColors
	 */
	JComboBox cbBgColors;

	/**
	 * ComboBox for Textsize
	 */
	JComboBox cbSize;

	/**
	 * ComboBox for Colors
	 */
	JComboBox cbColors;

	/**
	 * ComboBox for Formats
	 */
	JComboBox cbFormats;

	/**
	 * BFrame-Element
	 */
	BFrame bFrame;

	/**
	 * Constructor; a BFrame and orientation have to be passed
	 * 
	 * @param pBFrame :
	 *            related BFrame
	 * @param pOrientation :
	 *            0=horizontal, 1=vertical
	 */
	public FormatBar(BFrame pBFrame, int pOrientation) {
		super(pOrientation);
		this.bFrame = pBFrame;
		createContent(this);
	}

	/**
	 * Creates the Content
	 * 
	 * @param pFL :
	 *            the FormatBar to be filled
	 */
	private void createContent(FormatBar pFL) {

		String[] textSize = { "tiny", "scriptsize", "footnotesize", "small",
				"normalsize", "large", "Large", "LARGE", "huge", "Huge" };
		cbSize = new JComboBox(textSize);
		JLabel lSize = new JLabel(BFrame.get_prop().getProperty(
		 "beagtex.format.size") + "  ");
		cbSize.addActionListener(new TextSizeListener(bFrame.getEdit()));

		String[] formats = { "part", "part*", "chapter (book, report)",
				"chapter* (book, report)", "section", "section*", "subsection",
				"subsection*", "subsubsection", "subsubsection*" };
		cbFormats = new JComboBox(formats);
		JLabel lFormats = new JLabel("  " + BFrame.get_prop().getProperty(
		 "beagtex.format.formats")+ "   ");
		cbFormats.addActionListener(new FormatListener(bFrame.getEdit()));

		String[] colors = { "red", "yellow", "green", "blue", "black", "white" };
		cbColors = new JComboBox(colors);
		JLabel lColors = new JLabel( "  " + BFrame.get_prop().getProperty(
		 "beagtex.format.textcolor") + "  ");
		cbColors.addActionListener(new StandardColorsListener(bFrame.getEdit()));

		cbBgColors = new JComboBox(colors);
		JLabel bgColorL = new JLabel( "   " + BFrame.get_prop().getProperty(
		 "beagtex.format.bgcolor") + "  ");
		cbBgColors.addActionListener(new BGColorListener(bFrame
				.getEdit()));

		pFL.add(lSize);
		pFL.add(cbSize);
		pFL.add(lFormats);
		pFL.add(cbFormats);
		pFL.add(lColors);
		pFL.add(cbColors);
		pFL.add(bgColorL);
		pFL.add(cbBgColors);
	}
	
	/**
	 * Creates the Content in german
	 * 
	 * @param pFL :
	 *            the FormatBar to be filled
	 */
	//TODO fill in german
	private void createContent(FormatBar pFL, boolean isGerman) {

		String[] textSize = { "tiny", "scriptsize", "footnotesize", "small",
				"normalsize", "large", "Large", "LARGE", "huge", "Huge" };
		cbSize = new JComboBox(textSize);
		JLabel lSize = new JLabel("TextSize ");
		cbSize.addActionListener(new TextSizeListener(bFrame.getEdit()));

		String[] formats = { "part", "part*", "chapter (book, report)",
				"chapter* (book, report)", "section", "section*", "subsection",
				"subsection*", "subsubsection", "subsubsection*" };
		cbFormats = new JComboBox(formats);
		JLabel lFormats = new JLabel("    Formats ");
		cbFormats.addActionListener(new FormatListener(bFrame.getEdit()));

		String[] colors = { "red", "yellow", "green", "blue", "black", "white" };
		cbColors = new JComboBox(colors);
		JLabel lColors = new JLabel("    Text-Color ");
		cbColors.addActionListener(new StandardColorsListener(bFrame.getEdit()));

		cbBgColors = new JComboBox(colors);
		JLabel bgColorL = new JLabel("    Background-Color ");
		cbBgColors.addActionListener(new BGColorListener(bFrame
				.getEdit()));

		pFL.add(lSize);
		pFL.add(cbSize);
		pFL.add(lFormats);
		pFL.add(cbFormats);
		pFL.add(lColors);
		pFL.add(cbColors);
		pFL.add(bgColorL);
		pFL.add(cbBgColors);
	}

	// ab hier Getter/Setter
	public JComboBox getCbBgColors() {
		return cbBgColors;
	}

	public JComboBox getCbSize() {
		return cbSize;
	}

	public JComboBox getCbColors() {
		return cbColors;
	}

	public JComboBox getCbFormats() {
		return cbFormats;
	}
}
