package de.beagtex.gui;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

import de.beagtex.listener.gui.FormatFileOkListener;
import de.beagtex.listener.gui.TabCancelListener;

/**
 * Help for Creating Format-Files; askes for most relevant Format-File-Settings
 * and generates LaTex-Code
 * 
 * @author Benjamin Haag
 * 
 */
public class FormatFileWindow extends BWindow {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	// Editor editor;
	// EditorTab tab;
	BFrame bFrame;
	boolean isTab = false;

	Container conty;
	JPanel docStyleP;
	JPanel edgesP;
	JPanel restP;
	JPanel buttonsP;
	JPanel textP;

	ButtonGroup docStyleBG;
	public JRadioButton articleRB;
	public JRadioButton bookRB;
	public JRadioButton reportRB;
	public JRadioButton letterRB;
	JLabel docStyleL;

	JLabel edgesL;
	JLabel mmL;
	JLabel mm2L;
	JLabel mm3L;
	JLabel mm4L;
	JLabel emptyL;
	JLabel empty2L;
	JLabel topEdgeL;
	JLabel leftEdgeL;
	JLabel blockWidthL;
	JLabel blockheightL;
	public JTextField topEdgeTF;
	public JTextField leftEdgeTF;
	public JTextField blockwidthTF;
	public JTextField blockheightTF;

	public JCheckBox pageStyleCB;
	public JCheckBox absEinrueckCB;
	public JCheckBox absAbstCB;
	public JCheckBox standardPackCB;
	JLabel pageStyleL;
	JLabel lineGapL;
	JLabel parGapL;
	JLabel standardPackL;

	JButton okB;
	JButton cancelB;

	JLabel textL;
	JTextField textTF;
	public JComboBox textCoB;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public FormatFileWindow(BFrame pBFrame) {

		this.bFrame = pBFrame;
		paint();
	}

	/**
	 * Zeichnet das Format-Datei-Fenster auf den Bildschirm
	 */
	public void paint() {

		setTitle("Settings for Fomat-File");

		conty = new Container();
		// conty.setLayout(new GridLayout(2, 3, 5, 5));
		conty.setLayout(new FlowLayout(FlowLayout.LEFT, 50, 10));

		docStyleP = new JPanel();
		docStyleP.setLayout(new GridLayout(5, 4, 5, 5));

		edgesP = new JPanel();
		edgesP.setLayout(new GridLayout(5, 3, 5, 5));

		restP = new JPanel();
		restP.setLayout(new GridLayout(4, 2, 5, 5));
		// restP.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 10));

		buttonsP = new JPanel();
		buttonsP.setLayout(new GridLayout(2, 1, 5, 5));

		textP = new JPanel();
		textP.setLayout(new FlowLayout(FlowLayout.RIGHT, 5, 10));
		// schriftP.setLayout(new GridLayout(1, 2, 5, 5));

		// Panel 1 - Doc-Style
		docStyleBG = new ButtonGroup();
		articleRB = new JRadioButton("Article");
		articleRB.setSelected(true);
		bookRB = new JRadioButton("Book");
		reportRB = new JRadioButton("Report");
		letterRB = new JRadioButton("Letter");
		docStyleL = new JLabel("Doc-Style");
		docStyleBG.add(articleRB);
		docStyleBG.add(bookRB);
		docStyleBG.add(reportRB);
		docStyleBG.add(letterRB);
		docStyleP.add(docStyleL);
		docStyleP.add(articleRB);
		docStyleP.add(bookRB);
		docStyleP.add(reportRB);
		docStyleP.add(letterRB);

		// Panel 2 - Rnder
		edgesL = new JLabel("Edges");
		leftEdgeL = new JLabel("Left edge");
		topEdgeL = new JLabel("Top edge");
		blockWidthL = new JLabel("Blockwidth");
		blockheightL = new JLabel("Blockheight");
		mmL = new JLabel("mm");
		mm2L = new JLabel("mm");
		mm3L = new JLabel("mm");
		mm4L = new JLabel("mm");
		emptyL = new JLabel("");
		empty2L = new JLabel("");
		leftEdgeTF = new JTextField("0");
		topEdgeTF = new JTextField("0");
		blockwidthTF = new JTextField("0");
		blockheightTF = new JTextField("0");
		edgesP.add(emptyL);
		edgesP.add(edgesL);
		edgesP.add(empty2L);
		edgesP.add(topEdgeL);
		edgesP.add(topEdgeTF);
		edgesP.add(mmL);
		edgesP.add(leftEdgeL);
		edgesP.add(leftEdgeTF);
		edgesP.add(mm2L);
		edgesP.add(blockWidthL);
		edgesP.add(blockwidthTF);
		edgesP.add(mm3L);
		edgesP.add(blockheightL);
		edgesP.add(blockheightTF);
		edgesP.add(mm4L);

		// Panel 3 - Rest
		pageStyleCB = new JCheckBox();
		pageStyleCB.setSelected(true);
		absAbstCB = new JCheckBox();
		absEinrueckCB = new JCheckBox();
		standardPackCB = new JCheckBox();
		standardPackCB.setSelected(true);
		pageStyleL = new JLabel("PageStyle = scrheadings");
		parGapL = new JLabel("Double Paragraph-Gaps");
		lineGapL = new JLabel("Tab first line");
		standardPackL = new JLabel("Insert usepackages");
		restP.add(pageStyleL);
		restP.add(pageStyleCB);
		restP.add(lineGapL);
		restP.add(absEinrueckCB);
		restP.add(parGapL);
		restP.add(absAbstCB);
		restP.add(standardPackL);
		restP.add(standardPackCB);

		// Panel 4 - Buttons
		okB = new JButton("OK");
		cancelB = new JButton("cancel");
		buttonsP.add(okB);
		// Bercksichtigung, dass ein Tab auch aufrufen kann
		// if (isTab)
		// okB.addActionListener(new FormdatOkListener(this, tab));
		// else
		okB.addActionListener(new FormatFileOkListener(this, bFrame.getEdit()));
		buttonsP.add(cancelB);
		cancelB.addActionListener(new TabCancelListener(this));

		// Panel 5 - Schrift
		textL = new JLabel("Standard-Textsize");
		textTF = new JTextField(3);
		String[] size = { "8", "10", "12", "14", "16", "18" };

		textCoB = new JComboBox(size);
		textCoB.setSelectedIndex(2);
		textP.add(textL);
		textP.add(textCoB);

		conty.add(docStyleP);
		conty.add(edgesP);
		conty.add(restP);
		conty.add(textP);
		conty.add(buttonsP);

		getContentPane().add(conty);
	}
}
