package de.beagtex.gui;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import de.beagtex.listener.gui.ReplaceListener;
import de.beagtex.listener.gui.SearchTermListener;

/**
 * Inputwindow for Search-String, calls "SearchTermListener"
 * 
 * @author Benjamin Haag
 */
public class SearchWindow extends BWindow {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	Editor editor;

	JFrame newF;
	JPanel search;
	JLabel searchL;
	JLabel replaceL;
	public JTextField searchTF;
	public JTextField replaceTF;
	JButton searchB;
	public JButton replaceB;

	/**
	 * Constructor
	 * 
	 * @param pEditor:
	 *            the calling editor-object
	 */
	public SearchWindow(Editor pEditor) {

		this.editor = pEditor;
		paintEditor();

	}

	/**
	 * Paints the Search-Window --> Call is from an Editor-object
	 * 
	 */
	public void paintEditor() {

		setTitle(BFrame.get_prop().getProperty("beagtex.searchwindow.title"));
		setResizable(false);
		String frei = "                    ";
		searchL = new JLabel("  "
				+ BFrame.get_prop().getProperty(
						"beagtex.searchwindow.searchlabel") + frei + frei);
		search = new JPanel();
		search.setSize(100, 30);

		searchTF = new JTextField(25);
		searchTF.addActionListener(new SearchTermListener(this, editor));
		searchB = new JButton(BFrame.get_prop().getProperty(
				"beagtex.searchwindow.searchbutton"));
		searchB.addActionListener(new SearchTermListener(this, editor));

		replaceL = new JLabel("        "
				+ BFrame.get_prop().getProperty(
						"beagtex.searchwindow.replacelabel") + frei + frei
				+ frei);
		replaceTF = new JTextField(25);
		replaceTF.addActionListener(new ReplaceListener(this, editor));
		replaceB = new JButton(BFrame.get_prop().getProperty(
				"beagtex.searchwindow.replacebutton"));
		replaceB.addActionListener(new ReplaceListener(this, editor));
		replaceB.setEnabled(false);

		search.add(searchL);
		search.add(searchTF);
		search.add(searchB);
		search.add(replaceL);
		search.add(replaceTF);
		search.add(replaceB);
		getContentPane().add(search);
	}

	/**
	 * Paints the Search-Window with german text --> Call is from an
	 * Editor-object
	 * 
	 */
	public void paintEditor(boolean isGerman) {

		setTitle("Suchen");
		setResizable(false);
		String frei = "                    ";
		searchL = new JLabel("  Geben Sie hier den gesuchten Begriff ein ..."
				+ frei + frei);
		search = new JPanel();
		search.setSize(100, 30);

		searchTF = new JTextField(25);
		searchTF.addActionListener(new SearchTermListener(this, editor));
		searchB = new JButton("suchen");
		searchB.addActionListener(new SearchTermListener(this, editor));

		replaceL = new JLabel("        Geben Sie hier ihre Ersetzung ein ..."
				+ frei + frei + frei);
		replaceTF = new JTextField(25);
		replaceTF.addActionListener(new ReplaceListener(this, editor));
		replaceB = new JButton("ersetzen");
		replaceB.addActionListener(new ReplaceListener(this, editor));
		replaceB.setEnabled(false);

		search.add(searchL);
		search.add(searchTF);
		search.add(searchB);
		search.add(replaceL);
		search.add(replaceTF);
		search.add(replaceB);
		getContentPane().add(search);
	}
}
