package de.beagtex.listener.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;
import de.beagtex.gui.StartChoiceWindow;

/**
 * Listener for file-opening
 * 
 * @author Benjamin Haag
 */
public class OpenListener implements ActionListener {

	Editor editor;
	StartChoiceWindow startChoice;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor-object
	 */
	public OpenListener(Editor editor) {

		this.editor = editor;
	}

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor-object
	 * @param startchoice:
	 *            StartChoiceWindow
	 */
	public OpenListener(Editor editor, StartChoiceWindow startChoice) {

		this.startChoice = startChoice;
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		editor.open();
		startChoice.setVisible(false);
		editor.getBFrame().setVisible(true);

	}
}
