package de.beagtex.listener.format;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener centering in LaTex-Code
 * 
 * @author Benjamin Haag
 */
public class CenteredListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public CenteredListener(Editor editor) {

		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.getSelectedText() == null) {
			editor.insert(
					"\\begin{center}" + "\r\n" + "\r\n" + "\\end{center}",
					editor.getCaretPosition());
			editor.requestFocus();
			editor.setCaretPosition(editor.getCaretPosition() - 13);
		} else {
			editor.insert("\\begin{center}" + "\r\n", editor
					.getSelectionStart());
			editor.insert("\r\n" + "\\end{center}" + "\r\n", editor
					.getSelectionEnd());
			editor.requestFocus();
			editor.setCaretPosition(editor.getSelectionEnd());
		}
	}

}
