package de.beagtex.listener.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import de.beagtex.gui.Editor;
import de.beagtex.gui.FormatFileWindow;

/**
 * Listener for Ok-Button of FormatFileWindow; analyzes all entries and creates
 * proper LaTex-Code
 * 
 * @author Benjamin Haag
 * @see FormatFileWindow
 * 
 */
public class FormatFileOkListener implements ActionListener {

	Editor editor;

	/**
	 * the calling FormatFileWindow
	 */
	FormatFileWindow formwindow;

	/**
	 * Constructor
	 * 
	 * @param pFormwindow:
	 *            the calling FomratFileWindow
	 * @param pEditor:
	 *            the calling editor
	 */
	public FormatFileOkListener(FormatFileWindow pFormwindow, Editor pEditor) {

		this.formwindow = pFormwindow;
		this.editor = pEditor;
	}

	public void actionPerformed(ActionEvent e) {

		formwindow.setVisible(false);
		editor
				.insert("\\documentclass[a4paper, " + getSize() + "pt]{"
						+ getStyle() + "}" + "\r\n" + getUsepackeges()
						+ getPagestle() + getIndentation() + getGap()
						+ getTopEdge() + getLeftEdge() + getTextblockWidth()
						+ getTextblockHeight(), editor.getCaretPosition());
	}

	/**
	 * Provides the chosen size
	 * 
	 * @return size
	 */
	public int getSize() {
		int index = formwindow.textCoB.getSelectedIndex();
		int size = index;

		switch (index) {

		case 0:
			size = 8;
			break;

		case 1:
			size = 10;
			break;

		case 2:
			size = 12;
			break;

		case 3:
			size = 14;
			break;

		case 4:
			size = 16;
			break;

		case 5:
			size = 18;
			break;
		}
		return size;
	}

	/**
	 * Provides the chosen Document-Style
	 * 
	 * @return style: der ausgewhlte Stil
	 */
	public String getStyle() {

		String style = null;

		if (formwindow.articleRB.isSelected())
			style = "scrartcl";
		else if (formwindow.bookRB.isSelected())
			style = "scrbook";
		else if (formwindow.reportRB.isSelected())
			style = "scrreprt";
		else if (formwindow.letterRB.isSelected())
			style = "scrlttr2";
		return style;
	}

	/**
	 * provides the packages to use
	 * 
	 * @return: usepackeges: LaTex-Code fr die geforderten Pakete
	 */
	public String getUsepackeges() {

		String usepackages = null;
		if (formwindow.standardPackCB.isSelected())
			usepackages = "\\usepackage[T1]{fontenc}" + "\r\n"
					+ "\\usepackage[latin1]{inputenc}" + "\r\n"
					+ "\\usepackage{ngerman}" + "\r\n" + "\\usepackage{pifont}"
					+ "\r\n" + "\\usepackage{amsmath}" + "\r\n"
					+ "\\usepackage[right]{eurosym}" + "\r\n"
					+ "\\usepackage{scrpage2}" + "\r\n"
					+ "\\usepackage{graphicx}" + "\r\n" + "\\usepackage{color}"
					+ "\r\n" + "\\usepackage{makeidx}" + "\r\n" + "\\makeindex"
					+ "\r\n";
		else
			usepackages = "";
		return usepackages;
	}

	/**
	 * Analyzes the CheckBox for scrheadings and creates the command
	 * 
	 * @return pageStyle: String with proper Code
	 */
	public String getPagestle() {

		String pageStyle = null;
		if (formwindow.pageStyleCB.isSelected())
			pageStyle = "\\pagestyle{scrheadings}" + "\r\n";
		else
			pageStyle = "%\\pagestyle{scrheadings}" + "\r\n";
		return pageStyle;
	}

	/**
	 * Analyzes the CheckBox for indentation of paragraphs and creates the
	 * command
	 * 
	 * @return indent: String with proper Code
	 */
	public String getIndentation() {

		String indent = null;
		if (formwindow.absEinrueckCB.isSelected())
			indent = "\\setlength{\\parindent}{1em}" + "\r\n";
		else
			indent = "%\\setlength{\\parindent}{1em}" + "\r\n";
		return indent;
	}

	/**
	 * Analyzes the CheckBox for paragraph-gaps and creates the command
	 * 
	 * @return gap: String with proper Code
	 */
	public String getGap() {

		String gap = null;
		if (formwindow.absAbstCB.isSelected())
			gap = "\\setlength{\\parskip}{2.0ex plus 1.0ex minus 0.5ex}"
					+ "\r\n";
		else
			gap = "%\\setlength{\\parskip}{2.0ex plus 1.0ex minus 0.5ex}"
					+ "\r\n";
		return gap;
	}

	/**
	 * Analyzes the wanted edges
	 * 
	 * @return edge: proper Code
	 */
	public String getTopEdge() {

		String topEdge = null;

		int rOben = 0;
		try {
			rOben = Integer.parseInt(formwindow.topEdgeTF.getText());
		} catch (NumberFormatException e) {
			System.err.println("Insert-Error");
			JOptionPane
					.showMessageDialog(
							null,
							"The inserted values are not correct! "
									+ "All edges are initialized with 0.  "
									+ "\r\n"
									+ "You can change these values in the format-file.",
							"Incorrect insert", JOptionPane.WARNING_MESSAGE);
		}
		if (rOben == 0)
			topEdge = "%\\setlength{\\topmargin}{" + rOben + "mm}" + "\r\n";
		else
			topEdge = "\\setlength{\\topmargin}{" + rOben + "mm}" + "\r\n";
		return topEdge;

	}

	/**
	 * Analyzes the wanted edges
	 * 
	 * @return rand: proper Code
	 */
	public String getLeftEdge() {

		String leftEdge = null;
		int rLinks = 0;
		try {
			rLinks = Integer.parseInt(formwindow.leftEdgeTF.getText());
		} catch (NumberFormatException e) {
			System.err.println("Insert-Error");
			JOptionPane
					.showMessageDialog(
							null,
							"The inserted values are not correct! "
									+ "All edges are initialized with 0.  "
									+ "\r\n"
									+ "You can change these values in the format-file.",
							"Incorrect insert", JOptionPane.WARNING_MESSAGE);
		}
		if (rLinks == 0)
			leftEdge = "%\\setlength{\\oddsidemargin}{" + rLinks + "mm}"
					+ "\r\n";
		else
			leftEdge = "\\setlength{\\oddsidemargin}{" + rLinks + "mm}"
					+ "\r\n";
		return leftEdge;
	}

	/**
	 * Analyzes the wanted textblockwidth
	 * 
	 * @return textblockwidth: passender Code
	 */
	public String getTextblockWidth() {

		String textblockwidth = null;
		int width = 0;
		try {
			width = Integer.parseInt(formwindow.blockwidthTF.getText());
		} catch (NumberFormatException e) {
			System.err.println("Insert-Error");
			JOptionPane
					.showMessageDialog(
							null,
							"The inserted values are not correct! "
									+ "All edges are initialized with 0.  "
									+ "\r\n"
									+ "You can change these values in the format-file.",
							"Incorrect insert", JOptionPane.WARNING_MESSAGE);
		}
		if (width == 0)
			textblockwidth = "%\\setlength{\\textwidth}{" + width + "mm}"
					+ "\r\n";
		else
			textblockwidth = "\\setlength{\\textwidth}{" + width + "mm}" + "\r\n";
		return textblockwidth;
	}

	/**
	 * Analyzes the wanted textblockheight
	 * 
	 * @return textblockheight: proper Code
	 */
	public String getTextblockHeight() {

		String textblockheight = null;
		int height = 0;
		try {
			height = Integer.parseInt(formwindow.blockheightTF.getText());
		} catch (NumberFormatException e) {
			System.err.println("Insert-Error");
			JOptionPane
					.showMessageDialog(
							null,
							"The inserted values are not correct! "
									+ "All edges are initialized with 0.  "
									+ "mit 0 initialisiert."
									+ "\r\n"
									+ "You can change these values in the format-file.",
							"Incorrect insert", JOptionPane.WARNING_MESSAGE);
		}
		if (height == 0)
			textblockheight = "%\\setlength{\\textheight}{" + height + "mm}" + "\r\n";
		else
			textblockheight = "\\setlength{\\textheight}{" + height + "mm}" + "\r\n";
		return textblockheight;
	}
}
