package de.beagtex.listener.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;

/**
 * Listener for opening a new file in a new editor-window
 * 
 * @author Benjamin Haag
 */
public class OpenButtonListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public OpenButtonListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent arg0) {

		if (editor.getText().length() < 1)
			editor.open();
		else {
			BFrame bFrame = new BFrame();
			bFrame.setLocation(150, 150);
			bFrame.getEdit().open();
			bFrame.setVisible(true);
			Editor.incrementNumber();
			// System.out.println("OpenInc" + Editor.getAnzahl());
		}
	}
}
