package de.beagtex.listener.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;
import de.beagtex.gui.SearchWindow;

/**
 * Listener for replace-function; calls method replace(SearchWindow) from Edotor
 * 
 * @author Benjamin Haag
 */
public class ReplaceListener implements ActionListener {

	Editor editor;
	SearchWindow searchWindow;

	/**
	 * Constructor
	 * 
	 * @param searchWindow :
	 *            the calling searchwindow
	 * @param editor :
	 *            the calling editor
	 */
	public ReplaceListener(SearchWindow searchWindow, Editor editor) {
		this.searchWindow = searchWindow;
		this.editor = editor;
	}

	/**
	 * Call of replace-method from Editor
	 */
	public void actionPerformed(ActionEvent arg0) {

		editor.replace(searchWindow);
	}

}
