package de.beagtex.listener.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import de.beagtex.gui.Editor;
import de.beagtex.gui.TableCreateWindow;

/**
 * Listener for OK-Button of TableCreator
 * 
 * @author Benajmin Haag
 */
public class TabOkListener implements ActionListener {

	TableCreateWindow tabby;
	Editor editor;
	boolean isGerman = false;

	/**
	 * Constructor
	 * 
	 * @param tabby:
	 *            calling TableCreateWindow
	 * @param editor:
	 *            matching editor
	 */
	public TabOkListener(TableCreateWindow tabby, Editor editor) {

		this.tabby = tabby;
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {

		try {
			/*
			 * From Tab-creator independent part of table-definition; open the
			 * table-environment
			 */
			tabby.setVisible(false);
			int spaltenAnz = Integer.parseInt(tabby.columnTF.getText());
			int zeilenAnz = Integer.parseInt(tabby.lineTF.getText());
			editor.insert("\\begin{table}[h]\\begin{center}" + "\r\n"
					+ "\\begin{tabular}{", editor.getCaretPosition());

			/* Read number of columnes and create columns */
			for (int i = 0; i < spaltenAnz; i++) {
				if (tabby.verticalCB.isSelected())
					editor.insert("l|", editor.getCaretPosition());
				else
					editor.insert("l", editor.getCaretPosition());
			}

			editor.insert("}\\\\ \\hline" + "\r\n", editor.getCaretPosition());

			/* Read number of lines and create lines */
			for (int i = 0; i < zeilenAnz; i++) {
				editor.insert("LINE " + i + ": ", editor.getCaretPosition());

				for (int k = 0; k < spaltenAnz; k++) {
					editor
							.insert("FIELD " + (k + 1), editor
									.getCaretPosition());
					if (k != spaltenAnz - 1)
						editor.insert(" &", editor.getCaretPosition());
					else if (tabby.horizontalCB.isSelected())
						editor.insert("\\\\ \\hline" + "\r\n", editor
								.getCaretPosition());
					else
						editor.insert("\r\n", editor.getCaretPosition());
				}

			}
			/* close table-environment */
			editor.insert("\\end{tabular}" + "\r\n"
					+ "%HERE YOU CAN FILL IN A CAPTION " + "\r\n"
					+ "\\end{center}\\end{table}" + "\r\n", editor
					.getCaretPosition());

		} catch (NumberFormatException e1) {
			System.err.println("Input-Error");
			JOptionPane.showMessageDialog(null,
					"PLease insert correct values!", "Incorrect value-input",
					JOptionPane.WARNING_MESSAGE);
			tabby.setVisible(true);
		}

	}

	public void actionPerformed(ActionEvent e, boolean isGerman) {

		try {
			/*
			 * From Tab-creator independent part of table-definition; open the
			 * table-environment
			 */
			tabby.setVisible(false);
			int spaltenAnz = Integer.parseInt(tabby.columnTF.getText());
			int zeilenAnz = Integer.parseInt(tabby.lineTF.getText());
			editor.insert("\\begin{table}[h]\\begin{center}" + "\r\n"
					+ "\\begin{tabular}{", editor.getCaretPosition());

			/* Read number of columns and create columns */
			for (int i = 0; i < spaltenAnz; i++) {
				if (tabby.verticalCB.isSelected())
					editor.insert("l|", editor.getCaretPosition());
				else
					editor.insert("l", editor.getCaretPosition());
			}

			editor.insert("}\\\\ \\hline" + "\r\n", editor.getCaretPosition());

			/* Read number of lines and create lines */
			for (int i = 0; i < zeilenAnz; i++) {
				editor.insert("ZEILE " + i + ": ", editor.getCaretPosition());

				for (int k = 0; k < spaltenAnz; k++) {
					editor.insert("FELD " + (k + 1), editor.getCaretPosition());
					if (k != spaltenAnz - 1)
						editor.insert(" &", editor.getCaretPosition());
					else if (tabby.horizontalCB.isSelected())
						editor.insert("\\\\ \\hline" + "\r\n", editor
								.getCaretPosition());
					else
						editor.insert("\r\n", editor.getCaretPosition());
				}

			}
			/* close table-environment */
			editor
					.insert(
							"\\end{tabular}"
									+ "\r\n"
									+ "%HIER KNNEN SIE EINE BESCHRIFTUNG FR DIE TABELLE EINFGEN "
									+ "\r\n" + "\\end{center}\\end{table}"
									+ "\r\n", editor.getCaretPosition());

		} catch (NumberFormatException e1) {
			System.err.println("Eingabefehler");
			JOptionPane.showMessageDialog(null,
					"Bitte geben Sie korrekte Werte an!",
					"Unkorrekte Wert-Eingabe", JOptionPane.WARNING_MESSAGE);
			tabby.setVisible(true);
		}

	}

}
