package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.beagtex.gui.Editor;

/**
 * Listener for inserting a numbered listing in LaTex-Code; standard is three
 * items
 * 
 * @author Benjamin Haag
 */
public class NumberedListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public NumberedListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {

		editor.insert("\\begin{enumerate}" + "\r\n" + "\\item " + "\r\n"
				+ "\\item " + "\r\n" + "\\item " + "\r\n" + "\\end{enumerate}",
				editor.getCaretPosition());
		editor.requestFocus();
		editor.setCaretPosition(editor.getCaretPosition() - 32);
	}

}
