/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.EditCursor;
import com.sonoransoft.codequill.EditDisplayInt;
import com.sonoransoft.codequill.EditEngine;
import com.sonoransoft.codequill.Line;
import com.sonoransoft.codequill.LinkedList;
import com.sonoransoft.codequill.MarkedArea;
import com.sonoransoft.codequill.Options;
import com.sonoransoft.codequill.ScrollTimer;
import com.sonoransoft.codequill.TimerListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class EditDisplay
extends Canvas
implements FocusListener,
AdjustmentListener,
MouseListener,
MouseMotionListener,
TimerListener {
    private boolean markHighlightStartValid = false;
    private int markHighlightStartLine;
    private int markHighlightStartX;
    private boolean markHighlightEndValid = false;
    private int markHighlightEndLine;
    private int markHighlightEndX;
    private Font defaultFont;
    private FontMetrics fontMetrics;
    private String fillText = new String("~");
    private Line fillLine = new Line(this.fillText);
    private int cursorLine;
    private int cursorColumn;
    private int horizontalOffset = 0;
    private int numberOfLines;
    private int numberOfColumns;
    private int fontWidth = 0;
    private int spaceWidth = 0;
    private int fontHeight = 0;
    private int baseLineOffset = 0;
    private int cursorHorizontalOffset = 0;
    private LinkedList fileList;
    private EditEngine editEngine;
    private int windowStartLine;
    private Options options;
    private Insets insets = new Insets(2, 4, 2, 4);
    static final int CURSOR_UNDERLINE = 1;
    static final int CURSOR_VERTICAL_BAR = 0;
    private int cursorStyle;
    private boolean windowNeedsUpdate = false;
    private int lineNeedsUpdate = -1;
    private Scrollbar horizontalScrollbar;
    private Scrollbar verticalScrollbar;
    private boolean scrollMode = false;
    private static int MAX_COLUMN = 512;
    private int horizontalSize = MAX_COLUMN * 8;
    private int bubble = 0;
    private static int HORIZONTAL_UNIT_INCREMENT = 8;
    private static int VERTICAL_UNIT_INCREMENT = 1;
    private boolean markAreaValid = false;
    private int startMarkAreaColumn;
    private int endMarkAreaColumn;
    private int startMarkAreaAbsoluteX;
    private int endMarkAreaLine;
    private int endMarkAreaAbsoluteX;
    private int lastEndMarkAreaLine;
    private int lastEndMarkAreaAbsoluteX;
    private int startMarkAreaLine;
    private int mouseMarkColumn;
    private int mouseMarkAbsoluteX;
    private int mouseMarkLine;
    private boolean pressedRat = false;
    private Image imageBuffer;
    private int imageBufferWidth = 0;
    private int imageBufferHeight = 0;
    private Graphics imageGraphics;
    private EditDisplayInt session;
    private EditCursor cursor;
    private boolean metricsChanged = true;
    private int scrollEventX;
    private int scrollEventY;
    private int scrollEventLine;
    ScrollTimer scrollTimer = null;
    boolean scrollEnabled = false;
    private boolean inhibitAutoScroll = false;
    boolean mouseInBounds = true;
    int scrollRetryCount = 0;
    Color textColor;
    Color backgroundColor;
    boolean focus = false;
    MarkedArea markedArea = new MarkedArea();

    EditDisplay(EditDisplayInt editDisplayInt, LinkedList linkedList, EditEngine editEngine, Options options, Scrollbar scrollbar, Scrollbar scrollbar2, MarkedArea markedArea) {
        this.options = options;
        this.horizontalScrollbar = scrollbar;
        this.session = editDisplayInt;
        this.markedArea = markedArea;
        scrollbar.setUnitIncrement(HORIZONTAL_UNIT_INCREMENT);
        scrollbar2.setUnitIncrement(VERTICAL_UNIT_INCREMENT);
        this.verticalScrollbar = scrollbar2;
        scrollbar.addAdjustmentListener(this);
        scrollbar2.addAdjustmentListener(this);
        this.defaultFont = options.isFontBold() ? new Font(options.getFontName(), 1, options.getFontPoint()) : new Font(options.getFontName(), 0, options.getFontPoint());
        this.setFont(this.defaultFont);
        this.textColor = options.getTextColor().equals("Default") ? SystemColor.windowText : this.text2Color(options.getTextColor());
        this.backgroundColor = options.getBackgroundColor().equals("Default") ? SystemColor.window : this.text2Color(options.getBackgroundColor());
        this.fileList = linkedList;
        this.editEngine = editEngine;
        this.setupNumberOfLines();
        this.setupNumberOfColumns();
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.markAreaSetEnabled(false);
        this.cursor = new EditCursor(this);
        this.scrollTimer = ScrollTimer.getScrollTimer();
        this.scrollTimer.addTimerListener(this);
    }

    public void processTimerEvent() {
        if (this.scrollEnabled) {
            this.autoScroll();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focus = true;
        if (this.cursor != null) {
            this.cursor.setBlinkEnabled(false);
            this.cursor.setEnabled(true);
            this.writeCursor();
            this.cursor.setBlinkEnabled(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focus = false;
        if (this.cursor != null) {
            this.cursor.setEnabled(false);
            this.cursor.erase();
        }
    }

    public void disableCursor() {
        if (this.cursor != null) {
            this.cursor.setBlinkEnabled(false);
            this.cursor.setEnabled(false);
        }
    }

    public void update(Graphics graphics) {
        boolean bl = false;
        if (this.imageBuffer == null) {
            this.imageBuffer = this.createImage(800, 600);
            this.imageGraphics = this.imageBuffer.getGraphics();
        }
        if (this.imageBuffer == null) {
            return;
        }
        if (this.cursor != null) {
            this.cursor.setBlinkEnabled(false);
        }
        this.inhibitAutoScroll = true;
        if (this.cursor != null) {
            this.cursor.erase(graphics);
        }
        if (this.metricsChanged) {
            this.setupMetrics();
        }
        this.setupHorizontalOffset(graphics);
        if (this.windowNeedsUpdate) {
            this.drawAllLines(this.imageGraphics);
            this.windowNeedsUpdate = false;
            if (this.markAreaValid) {
                this.setMarkedArea(false);
                this.highlightMarkedArea(this.imageGraphics, false);
            }
            graphics.drawImage(this.imageBuffer, 0, 0, this);
        } else if (this.lineNeedsUpdate != -1) {
            this.drawLine(this.imageGraphics, graphics);
            this.lineNeedsUpdate = -1;
        }
        if (!this.scrollMode) {
            this.verticalScrollbar.setValues(this.windowStartLine, this.numberOfLines, 0, this.fileList.getSize() + this.numberOfLines - 1);
            this.horizontalScrollbar.setValues(this.horizontalOffset, this.bubble, 0, this.horizontalSize);
        }
        if (this.cursor != null) {
            this.writeCursor(graphics);
            this.cursor.setBlinkEnabled(true);
        }
        this.inhibitAutoScroll = false;
    }

    public void autoScroll() {
        boolean bl = false;
        if (this.inhibitAutoScroll) {
            ++this.scrollRetryCount;
            return;
        }
        int n = this.scrollRetryCount + 1;
        this.scrollRetryCount = 0;
        if (this.scrollEventX < this.insets.left) {
            if (this.horizontalOffset > 0) {
                bl = true;
                this.horizontalOffset -= this.fontWidth * n;
                if (this.horizontalOffset < 0) {
                    this.horizontalOffset = 0;
                }
            }
        } else {
            Dimension dimension = this.getSize();
            if (this.scrollEventX > dimension.width - this.insets.right) {
                bl = true;
                this.horizontalOffset += this.fontWidth * n;
                if (this.horizontalOffset + dimension.width > this.horizontalSize) {
                    this.horizontalOffset = this.horizontalSize - dimension.width;
                }
            }
        }
        if (this.scrollEventLine < this.windowStartLine) {
            if (this.windowStartLine > 0) {
                bl = true;
                this.windowStartLine -= 1 * n;
            }
        } else if (this.scrollEventLine >= this.windowStartLine + this.numberOfLines) {
            bl = true;
            this.windowStartLine += n;
        }
        if (bl) {
            if (this.cursor != null) {
                this.cursor.setBlinkEnabled(false);
            }
            this.editEngine.setWindowPosition(this.windowStartLine);
            this.setMouseMarks(this.scrollEventX, this.scrollEventY);
            this.endMarkAreaColumn = this.mouseMarkColumn;
            this.endMarkAreaAbsoluteX = this.mouseMarkAbsoluteX;
            this.endMarkAreaLine = this.mouseMarkLine;
            this.windowNeedsUpdate = true;
            if (this.cursor != null) {
                this.cursor.setBlinkEnabled(true);
            }
            this.repaint();
            if (!this.pressedRat) {
                this.scrollEnabled = false;
                this.mouseInBounds = true;
            }
        } else if (!this.pressedRat || this.mouseInBounds) {
            this.repaint();
            this.scrollEnabled = false;
        }
    }

    private void setupMetrics() {
        this.metricsChanged = false;
        this.setFontMetrics();
        this.setCursorMetrics();
        this.setupNumberOfLines();
        this.setupNumberOfColumns();
        this.setScrollMetrics();
        if (this.scrollMode) {
            int n = this.editEngine.getWindowStartLine();
            this.editEngine.setWindowSizeInLines(this.numberOfLines);
            this.editEngine.setWindowPosition(n);
        } else {
            this.editEngine.setWindowSizeInLines(this.numberOfLines);
        }
        this.windowStartLine = this.editEngine.getWindowStartLine();
    }

    public void paint(Graphics graphics) {
        this.setupMetrics();
        this.checkImageBuffer();
        if (this.imageBuffer == null) {
            return;
        }
        if (this.cursor != null) {
            this.cursor.setBlinkEnabled(false);
            this.cursor.reset();
        }
        this.setupHorizontalOffset(graphics);
        this.drawAllLines(this.imageGraphics);
        if (this.markAreaValid) {
            this.setMarkedArea(false);
            this.highlightMarkedArea(this.imageGraphics, false);
        }
        graphics.drawImage(this.imageBuffer, 0, 0, this);
        if (this.cursor != null) {
            this.writeCursor(graphics);
            this.cursor.setBlinkEnabled(true);
        }
        this.verticalScrollbar.setValues(this.windowStartLine, this.numberOfLines, 0, this.fileList.getSize() + this.numberOfLines - 1);
        this.horizontalScrollbar.setValues(this.horizontalOffset, this.bubble, 0, this.horizontalSize);
    }

    private void setupHorizontalOffset(Graphics graphics) {
        int n;
        int n2;
        this.fileList.push();
        this.fileList.setTo(this.cursorLine);
        String string = ((Line)this.fileList.get()).getText();
        this.fileList.pop();
        int n3 = this.horizontalOffset;
        if (string.length() == 0) {
            n2 = this.spaceWidth * this.cursorColumn - string.length();
            n = this.spaceWidth;
        } else if (this.cursorColumn < string.length()) {
            n2 = this.fontMetrics.stringWidth(string.substring(0, this.cursorColumn));
            n = this.fontMetrics.charWidth(string.charAt(this.cursorColumn));
        } else {
            n2 = this.fontMetrics.stringWidth(string);
            n2 += this.spaceWidth * (this.cursorColumn - string.length());
            n = this.spaceWidth;
        }
        if (!this.scrollMode && !this.pressedRat) {
            if (this.insets.left + n2 + n + this.insets.right > n3 + this.getSize().width) {
                n3 = this.insets.right + n2 + n + this.insets.right - this.getSize().width;
                this.windowNeedsUpdate = true;
            } else if (n2 < n3) {
                n3 = n2;
                this.windowNeedsUpdate = true;
            }
        }
        this.cursorHorizontalOffset = n2;
        this.horizontalOffset = n3;
    }

    private void drawAllLines(Graphics graphics) {
        int n = 0;
        if (graphics != null) {
            int n2 = this.insets.top;
            int n3 = this.fontHeight;
            this.windowStartLine = this.editEngine.getWindowStartLine();
            n = this.horizontalOffset;
            this.fileList.push();
            this.fileList.setTo(this.windowStartLine);
            Dimension dimension = this.getSize();
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.textColor);
            int n4 = 0;
            Line line = (Line)this.fileList.get();
            while (line != null && n4 < this.numberOfLines) {
                String string = line.getText();
                graphics.drawString(string, this.insets.left - n, n2 + this.baseLineOffset);
                n2 += n3;
                line = (Line)this.fileList.getNext();
                ++n4;
            }
            this.fileList.pop();
            while (n4++ < this.numberOfLines) {
                graphics.drawString(this.fillText, this.insets.left, n2 + this.baseLineOffset);
                n2 += n3;
            }
        }
    }

    private void drawLine(Graphics graphics, Graphics graphics2) {
        if (graphics != null) {
            int n = this.insets.top;
            int n2 = this.fontHeight;
            this.windowStartLine = this.editEngine.getWindowStartLine();
            int n3 = this.horizontalOffset;
            this.fileList.push();
            this.fileList.setTo(this.lineNeedsUpdate);
            Dimension dimension = this.getSize();
            Line line = (Line)this.fileList.get();
            this.fileList.pop();
            if (line == null || this.lineNeedsUpdate - this.windowStartLine > this.numberOfLines) {
                return;
            }
            String string = line.getText();
            n = this.insets.top + n2 * (this.lineNeedsUpdate - this.windowStartLine);
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, n, dimension.width, this.fontHeight);
            graphics.setColor(this.textColor);
            graphics.drawString(string, this.insets.left - n3, n + this.baseLineOffset);
            graphics2.drawImage(this.imageBuffer, 0, n, dimension.width, n + n2, 0, n, dimension.width, n + n2, this);
        }
    }

    private void copyLineArea(Graphics graphics, int n) {
        if (graphics != null) {
            int n2 = this.insets.top;
            int n3 = this.fontHeight;
            this.windowStartLine = this.editEngine.getWindowStartLine();
            int n4 = this.horizontalOffset;
            if (n - this.windowStartLine > this.numberOfLines) {
                return;
            }
            Dimension dimension = this.getSize();
            n2 = this.insets.top + n3 * (n - this.windowStartLine);
            graphics.drawImage(this.imageBuffer, 0, n2, dimension.width, n2 + n3, 0, n2, dimension.width, n2 + n3, this);
        }
    }

    public int lineCount() {
        this.setFontMetrics();
        return this.numberOfLines;
    }

    public void highlight(int n, int n2, int n3, int n4) {
    }

    public void setLineUpdate(int n) {
        if (this.markAreaValid) {
            this.markAreaSetEnabled(false);
            this.windowNeedsUpdate = true;
        }
        if (this.scrollMode) {
            this.scrollMode = false;
            this.windowNeedsUpdate = true;
        } else if (this.lineNeedsUpdate == -1) {
            this.lineNeedsUpdate = n;
        } else {
            this.windowNeedsUpdate = true;
            this.lineNeedsUpdate = -1;
        }
    }

    public void setWindowUpdate() {
        this.scrollMode = false;
        this.windowNeedsUpdate = true;
    }

    public void setCursor(int n, int n2) {
        this.setCursor(n, n2, true);
    }

    private void setCursor(int n, int n2, boolean bl) {
        if (bl && this.scrollMode) {
            this.scrollMode = false;
            this.windowNeedsUpdate = true;
        }
        this.cursorLine = n;
        this.cursorColumn = n2;
    }

    private void writeCursor(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        if (graphics != null) {
            n = this.horizontalOffset;
            n2 = this.cursorHorizontalOffset;
            int n3 = this.editEngine.getWindowStartLine();
            int n4 = this.insets.top + (this.cursorLine - n3) * this.fontHeight + this.baseLineOffset;
            int n5 = this.insets.left + n2 - n;
            if (this.cursor != null) {
                this.cursor.draw(graphics, n5, n4);
            }
        }
    }

    private synchronized void writeCursor() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.writeCursor(graphics);
            graphics.dispose();
        }
    }

    private void setFontMetrics() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.fontMetrics = graphics.getFontMetrics();
        if (this.fontMetrics == null) {
            return;
        }
        this.fontWidth = this.fontMetrics.charWidth('A');
        this.spaceWidth = this.fontMetrics.charWidth(' ');
        this.baseLineOffset = this.fontMetrics.getAscent();
        this.fontHeight = this.fontMetrics.getHeight();
        Dimension dimension = this.getSize();
        graphics.dispose();
    }

    private void setScrollMetrics() {
        this.horizontalSize = MAX_COLUMN * this.fontWidth + this.insets.left + this.insets.right;
        this.bubble = this.getSize().width;
        this.horizontalScrollbar.setUnitIncrement(this.fontWidth);
        this.horizontalScrollbar.setBlockIncrement(this.fontWidth * 8);
        this.verticalScrollbar.setUnitIncrement(VERTICAL_UNIT_INCREMENT);
        if (this.numberOfLines > 1) {
            this.verticalScrollbar.setBlockIncrement(this.numberOfLines - 1);
        } else {
            this.verticalScrollbar.setBlockIncrement(1);
        }
    }

    private char getCharacter(int n, int n2) {
        this.fileList.push();
        Line line = !this.fileList.setTo(n) ? this.fillLine : (Line)this.fileList.get();
        this.fileList.pop();
        return line.getCharacter(n2);
    }

    private void writeCharacter(Graphics graphics, int n, int n2) {
        int n3;
        char[] cArray = new char[1];
        this.fileList.push();
        this.fileList.setTo(n);
        String string = ((Line)this.fileList.get()).getText();
        this.fileList.pop();
        cArray[0] = '\u0000';
        if (string.length() == 0) {
            n3 = this.spaceWidth * n2 - string.length();
        } else if (n2 < string.length()) {
            n3 = this.fontMetrics.stringWidth(string.substring(0, n2));
            cArray[0] = string.charAt(n2);
        } else {
            n3 = this.fontMetrics.stringWidth(string);
            n3 += this.spaceWidth * (n2 - string.length());
        }
        int n4 = this.insets.top + (n - this.editEngine.getWindowStartLine()) * this.fontHeight;
        int n5 = this.insets.left + n3 - this.horizontalOffset;
        int n6 = cArray[0] == '\u0000' ? this.fontMetrics.charWidth(' ') : this.fontMetrics.charWidth(cArray[0]);
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(n5, n4, n6, this.fontHeight);
        graphics.setColor(this.textColor);
        if (cArray[0] != '\u0000') {
            graphics.drawChars(cArray, 0, 1, n5, n4 + this.baseLineOffset);
        }
    }

    private void setupNumberOfLines() {
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = this.fontHeight == 0 ? (n - this.insets.top - this.insets.bottom) / 12 : (n - this.insets.top - this.insets.bottom) / this.fontHeight;
        this.numberOfLines = n2;
    }

    private void setupNumberOfColumns() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = this.fontWidth == 0 ? (n - this.insets.left - this.insets.right) / 9 : (n - this.insets.left - this.insets.right) / this.fontWidth;
        this.numberOfColumns = n2;
    }

    private void setCursorMetrics() {
        if (this.cursor != null) {
            this.cursor.setStyle(this.cursorStyle, this.fontMetrics);
        }
    }

    public void setCursorStyle(int n) {
        this.cursorStyle = n;
        this.setCursorMetrics();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.scrollMode = true;
        this.windowStartLine = this.verticalScrollbar.getValue();
        this.editEngine.setWindowPosition(this.windowStartLine);
        this.horizontalOffset = this.horizontalScrollbar.getValue();
        this.windowNeedsUpdate = true;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl = true;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            if (!this.markAreaValid) {
                this.markAreaSetEnabled(true);
                bl = false;
            }
            this.markAreaSetEnabled(true);
            this.setMouseMarks(mouseEvent.getX(), mouseEvent.getY());
            this.endMarkAreaColumn = this.mouseMarkColumn;
            this.endMarkAreaAbsoluteX = this.mouseMarkAbsoluteX;
            this.endMarkAreaLine = this.mouseMarkLine;
            this.setEditEngineStuff();
            this.windowNeedsUpdate = true;
            this.setMarkedArea(bl);
            this.highlightMarkedArea(graphics, bl);
            graphics.dispose();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.pressedRat) {
            this.removeMouseMotionListener(this);
        }
    }

    public void updateOptions() {
        this.markAreaSetEnabled(false);
        this.scrollMode = false;
        this.defaultFont = this.options.isFontBold() ? new Font(this.options.getFontName(), 1, this.options.getFontPoint()) : new Font(this.options.getFontName(), 0, this.options.getFontPoint());
        this.textColor = this.options.getTextColor().equals("Default") ? SystemColor.windowText : this.text2Color(this.options.getTextColor());
        this.backgroundColor = this.options.getBackgroundColor().equals("Default") ? SystemColor.window : this.text2Color(this.options.getBackgroundColor());
        this.setFont(this.defaultFont);
        this.metricsChanged = true;
        this.windowNeedsUpdate = true;
        this.repaint();
    }

    private Color text2Color(String string) {
        if (string.compareTo("Default") == 0) {
            return Color.black;
        }
        if (string.compareTo("White") == 0) {
            return Color.white;
        }
        if (string.compareTo("Light gray") == 0) {
            return Color.lightGray;
        }
        if (string.compareTo("Gray") == 0) {
            return Color.gray;
        }
        if (string.compareTo("Dark gray") == 0) {
            return Color.darkGray;
        }
        if (string.compareTo("Black") == 0) {
            return Color.black;
        }
        if (string.compareTo("Red") == 0) {
            return Color.red;
        }
        if (string.compareTo("Pink") == 0) {
            return Color.pink;
        }
        if (string.compareTo("Orange") == 0) {
            return Color.orange;
        }
        if (string.compareTo("Green") == 0) {
            return Color.green;
        }
        if (string.compareTo("Magenta") == 0) {
            return Color.magenta;
        }
        if (string.compareTo("Cyan") == 0) {
            return Color.cyan;
        }
        if (string.compareTo("Blue") == 0) {
            return Color.blue;
        }
        if (string.compareTo("Yellow") == 0) {
            return Color.yellow;
        }
        return Color.black;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.focus) {
            this.requestFocus();
        }
        if (this.pressedRat) {
            return;
        }
        this.scrollMode = false;
        if (this.markAreaValid) {
            if (mouseEvent.isShiftDown()) {
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    this.setMouseMarks(mouseEvent.getX(), mouseEvent.getY());
                    this.endMarkAreaColumn = this.mouseMarkColumn;
                    this.endMarkAreaAbsoluteX = this.mouseMarkAbsoluteX;
                    this.endMarkAreaLine = this.mouseMarkLine;
                    this.setEditEngineStuff();
                    this.setMarkedArea(true);
                    this.highlightMarkedArea(graphics, true);
                    graphics.dispose();
                    this.pressedRat = true;
                    this.addMouseMotionListener(this);
                }
                return;
            }
            this.markAreaSetEnabled(false);
            this.windowNeedsUpdate = true;
            this.repaint();
        }
        this.pressedRat = true;
        this.addMouseMotionListener(this);
        this.markAreaSetEnabled(false);
        this.setMouseMarks(mouseEvent.getX(), mouseEvent.getY());
        this.startMarkAreaColumn = this.mouseMarkColumn;
        this.startMarkAreaAbsoluteX = this.mouseMarkAbsoluteX;
        this.startMarkAreaLine = this.mouseMarkLine;
    }

    private synchronized void setMouseMarks(int n, int n2) {
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = n2 - this.insets.top;
        int n5 = n4 / this.fontHeight;
        int n6 = n4 / this.fontHeight + this.windowStartLine;
        if (n6 >= this.fileList.getSize()) {
            n6 = this.fileList.getSize() - 1;
        }
        this.scrollEventX = n;
        this.scrollEventY = n2;
        this.scrollEventLine = n6;
        if (n6 < this.windowStartLine) {
            n6 = this.windowStartLine;
            if (this.pressedRat && this.mouseInBounds) {
                this.scrollEnabled = true;
                this.scrollRetryCount = 0;
                this.mouseInBounds = false;
            }
        } else if (n6 >= this.windowStartLine + this.numberOfLines) {
            if (this.windowStartLine + this.numberOfLines < this.fileList.getSize()) {
                n6 = this.windowStartLine + this.numberOfLines - 1;
                if (this.pressedRat && this.mouseInBounds) {
                    this.scrollEnabled = true;
                    this.scrollRetryCount = 0;
                    this.mouseInBounds = false;
                }
            }
        } else {
            bl = true;
        }
        this.fileList.push();
        this.fileList.setTo(n6);
        String string = ((Line)this.fileList.get()).getText();
        this.fileList.pop();
        Dimension dimension = this.getSize();
        if (n < this.insets.left) {
            if (n < 0) {
                n = 0;
            }
            if (this.pressedRat && this.mouseInBounds) {
                this.mouseInBounds = false;
                this.scrollEnabled = true;
                this.scrollRetryCount = 0;
            }
        } else if (n > dimension.width - this.insets.right) {
            n = dimension.width;
            if (this.pressedRat && this.mouseInBounds) {
                this.mouseInBounds = false;
                this.scrollEnabled = true;
                this.scrollRetryCount = 0;
            }
        } else if (bl) {
            this.mouseInBounds = true;
        }
        int n7 = n;
        n7 += this.horizontalOffset - this.insets.left;
        int n8 = string.length();
        int n9 = -1;
        int n10 = 0;
        do {
            n3 = n10;
            if (++n9 < n8) {
                n10 += this.fontMetrics.charWidth(string.charAt(n9));
                continue;
            }
            n10 += this.spaceWidth;
        } while (n10 <= n7);
        this.mouseMarkColumn = n9;
        this.mouseMarkLine = n6;
        this.mouseMarkAbsoluteX = n3;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (this.fontMetrics == null) {
            return;
        }
        if (!this.pressedRat) {
            return;
        }
        this.pressedRat = false;
        this.horizontalOffset = this.horizontalScrollbar.getValue();
        this.editEngine.setWindowCursorPosition(this.numberOfLines, this.windowStartLine, this.mouseMarkLine, this.mouseMarkColumn);
        this.setMouseMarks(mouseEvent.getX(), mouseEvent.getY());
        if (mouseEvent.getClickCount() == 1) {
            this.endMarkAreaColumn = this.mouseMarkColumn;
            this.endMarkAreaAbsoluteX = this.mouseMarkAbsoluteX;
            this.endMarkAreaLine = this.mouseMarkLine;
        } else if (mouseEvent.getClickCount() == 2 && (n = this.markCurrentWord(this.mouseMarkLine, this.mouseMarkColumn)) != -1) {
            this.mouseMarkColumn = n;
        }
        this.setCursor(this.mouseMarkLine, this.mouseMarkColumn, false);
        this.windowNeedsUpdate = true;
        this.repaint();
    }

    private void setMarkedArea(boolean bl) {
        if (!bl) {
            if (this.startMarkAreaLine < this.endMarkAreaLine || this.startMarkAreaLine == this.endMarkAreaLine && this.startMarkAreaAbsoluteX < this.endMarkAreaAbsoluteX) {
                this.markHighlightStartLine = this.startMarkAreaLine;
                this.markHighlightStartX = this.startMarkAreaAbsoluteX;
                this.markHighlightEndLine = this.endMarkAreaLine;
                this.markHighlightEndX = this.endMarkAreaAbsoluteX;
            } else {
                this.markHighlightStartLine = this.endMarkAreaLine;
                this.markHighlightStartX = this.endMarkAreaAbsoluteX;
                this.markHighlightEndLine = this.startMarkAreaLine;
                this.markHighlightEndX = this.startMarkAreaAbsoluteX;
            }
        } else if (this.endMarkAreaLine > this.lastEndMarkAreaLine || this.endMarkAreaLine == this.lastEndMarkAreaLine && this.endMarkAreaAbsoluteX > this.lastEndMarkAreaAbsoluteX) {
            this.markHighlightStartLine = this.lastEndMarkAreaLine;
            this.markHighlightStartX = this.lastEndMarkAreaAbsoluteX;
            this.markHighlightEndLine = this.endMarkAreaLine;
            this.markHighlightEndX = this.endMarkAreaAbsoluteX;
        } else {
            this.markHighlightStartLine = this.endMarkAreaLine;
            this.markHighlightStartX = this.endMarkAreaAbsoluteX;
            this.markHighlightEndLine = this.lastEndMarkAreaLine;
            this.markHighlightEndX = this.lastEndMarkAreaAbsoluteX;
        }
        this.lastEndMarkAreaAbsoluteX = this.endMarkAreaAbsoluteX;
        this.lastEndMarkAreaLine = this.endMarkAreaLine;
    }

    private void highlightMarkedArea(Graphics graphics, boolean bl) {
        int n;
        int n2 = this.editEngine.getWindowStartLine();
        int n3 = this.horizontalOffset;
        Dimension dimension = this.getSize();
        int n4 = n2 + this.numberOfLines;
        int n5 = this.markHighlightStartLine;
        int n6 = this.markHighlightStartX - n3;
        int n7 = this.markHighlightEndLine;
        int n8 = this.markHighlightEndX - n3;
        if (n5 >= n2 + this.numberOfLines || n7 < n2) {
            graphics.setPaintMode();
            return;
        }
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        int n9 = n5;
        if (n5 >= n2) {
            n = this.insets.top + (n5 - n2) * this.fontHeight;
            if (n5 == n7) {
                graphics.fillRect(n6 + this.insets.left, n, dimension.width - n6 - (dimension.width - n8), this.fontHeight);
                graphics.setPaintMode();
                return;
            }
            graphics.fillRect(n6 + this.insets.left, n, dimension.width - n6, this.fontHeight);
            n9 = n5 + 1;
            if (n9 == n4) {
                graphics.setPaintMode();
                return;
            }
        }
        if ((n9 = n5 + 1) != n7) {
            int n10 = n7 > n4 ? (n4 - n9) * this.fontHeight : (n7 - n9) * this.fontHeight;
            n = this.insets.top + (n9 - n2) * this.fontHeight;
            graphics.fillRect(this.insets.left, n, dimension.width, n10);
        }
        if (n7 < n4) {
            n = this.insets.top + (n7 - n2) * this.fontHeight;
            graphics.fillRect(this.insets.left, n, n8, this.fontHeight);
        }
        graphics.setPaintMode();
    }

    public void setFont(Font font) {
        if (this.imageGraphics != null) {
            this.imageGraphics.setFont(font);
        }
        super.setFont(font);
    }

    public void markAreaSetEnabled(boolean bl) {
        this.markedArea.setValid(bl);
        this.markedArea.setEditable(bl);
        if (bl != this.markAreaValid) {
            this.markAreaValid = bl;
            this.session.editDisplayMarkAreaSetEnabled(bl);
        }
    }

    private void setEditEngineStuff() {
        this.markedArea.setStartLine(this.startMarkAreaLine);
        this.markedArea.setStartColumn(this.startMarkAreaColumn);
        this.markedArea.setEndLine(this.endMarkAreaLine);
        this.markedArea.setEndColumn(this.endMarkAreaColumn);
    }

    public boolean isMarkAreaValid() {
        return this.markAreaValid;
    }

    public void checkImageBuffer() {
        boolean bl = false;
        if (this.getSize().width > this.imageBufferWidth) {
            this.imageBufferWidth = this.getSize().width;
            bl = true;
        }
        if (this.getSize().height > this.imageBufferHeight) {
            this.imageBufferHeight = this.getSize().height;
            bl = true;
        }
        if (bl) {
            if (this.imageBuffer != null) {
                this.imageBuffer.flush();
                this.imageGraphics.dispose();
            }
            this.imageBuffer = this.createImage(this.imageBufferWidth, this.imageBufferHeight);
            this.imageGraphics = this.imageBuffer.getGraphics();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int markCurrentWord(int var1_1, int var2_2) {
        block9: {
            this.fileList.push();
            this.fileList.setTo(var1_1);
            var3_3 = ((Line)this.fileList.get()).getText();
            this.fileList.pop();
            if (var2_2 >= var3_3.length()) {
                return -1;
            }
            var4_4 = var2_2;
            var5_5 = var2_2;
            if (var3_3.charAt(var2_2) != ' ') ** GOTO lbl22
            while (var4_4 > 0 && var3_3.charAt(var4_4 - 1) == ' ') {
                --var4_4;
            }
            while (var5_5 < var3_3.length() - 1 && var3_3.charAt(var5_5 + 1) == ' ') {
                ++var5_5;
            }
            if (var4_4 != 0 || var5_5 < var3_3.length()) break block9;
            return -1;
lbl-1000:
            // 1 sources

            {
                --var4_4;
lbl22:
                // 2 sources

                ** while (var4_4 > 0 && var3_3.charAt((int)(var4_4 - 1)) != ' ')
            }
lbl23:
            // 2 sources

            while (var5_5 < var3_3.length() - 1 && var3_3.charAt(var5_5 + 1) != ' ') {
                ++var5_5;
            }
            if (var4_4 == 0 && var5_5 >= var3_3.length()) {
                return -1;
            }
        }
        this.startMarkAreaColumn = var4_4;
        this.startMarkAreaAbsoluteX = this.fontMetrics.stringWidth(var3_3.substring(0, var4_4));
        this.startMarkAreaLine = var1_1;
        this.endMarkAreaColumn = var5_5 + 1;
        this.endMarkAreaAbsoluteX = this.fontMetrics.stringWidth(var3_3.substring(0, var5_5)) + this.fontMetrics.charWidth(var3_3.charAt(var5_5));
        this.endMarkAreaLine = var1_1;
        this.markAreaSetEnabled(true);
        this.setEditEngineStuff();
        return var5_5;
    }

    public void setMarkArea(int n, int n2, int n3) {
        this.fileList.push();
        this.fileList.setTo(n);
        String string = ((Line)this.fileList.get()).getText();
        this.fileList.pop();
        if (n2 >= string.length() || n3 == 0) {
            return;
        }
        int n4 = n2;
        int n5 = n2 + n3 - 1;
        this.startMarkAreaColumn = n4;
        this.startMarkAreaAbsoluteX = this.fontMetrics.stringWidth(string.substring(0, n4));
        this.startMarkAreaLine = n;
        this.endMarkAreaColumn = n5 + 1;
        this.endMarkAreaAbsoluteX = this.fontMetrics.stringWidth(string.substring(0, n5)) + this.fontMetrics.charWidth(string.charAt(n5));
        this.endMarkAreaLine = n;
        this.markAreaSetEnabled(true);
        this.setEditEngineStuff();
        this.windowNeedsUpdate = true;
        this.repaint();
    }

    public void updateMarkedArea() {
        if (!this.markedArea.isValid()) {
            this.markAreaSetEnabled(false);
            return;
        }
        int n = this.markedArea.getStartLine();
        int n2 = this.markedArea.getStartColumn();
        int n3 = this.markedArea.getEndLine();
        int n4 = this.markedArea.getEndColumn();
        int n5 = 0;
        int n6 = 0;
        this.fileList.push();
        this.fileList.setTo(n);
        String string = ((Line)this.fileList.get()).getText();
        this.fileList.setTo(n3);
        String string2 = ((Line)this.fileList.get()).getText();
        this.fileList.pop();
        this.startMarkAreaColumn = n2;
        if (n2 > string.length()) {
            n5 = n2 - string.length();
            n2 = string.length();
        }
        this.startMarkAreaAbsoluteX = this.fontMetrics.stringWidth(string.substring(0, n2));
        this.startMarkAreaAbsoluteX += n5 * this.spaceWidth;
        this.startMarkAreaLine = n;
        this.endMarkAreaColumn = n4;
        if (n4 > string2.length()) {
            n6 = n4 - string2.length();
            n4 = string2.length();
        }
        this.endMarkAreaAbsoluteX = this.fontMetrics.stringWidth(string2.substring(0, n4));
        this.endMarkAreaAbsoluteX += n6 * this.spaceWidth;
        this.endMarkAreaLine = n3;
        this.markAreaValid = true;
        this.windowNeedsUpdate = true;
        this.repaint();
    }

    public void resetMarkArea() {
        if (this.isMarkAreaValid()) {
            this.markAreaSetEnabled(false);
            this.windowNeedsUpdate = true;
            this.repaint();
        }
    }

    protected void finalize() {
        if (this.imageBuffer != null) {
            this.imageBuffer.flush();
            this.imageGraphics.dispose();
        }
    }

    public void closeDisplay() {
        this.scrollEnabled = false;
        this.scrollTimer.removeTimerListener(this);
        this.cursor.setEnabled(false);
        this.cursor.kill();
        this.cursor = null;
        this.session = null;
        this.editEngine = null;
        this.horizontalScrollbar.removeAdjustmentListener(this);
        this.verticalScrollbar.removeAdjustmentListener(this);
        this.removeFocusListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.fileList = null;
    }
}

