/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.Options;
import com.sonoransoft.codequill.SyntaxMgr;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class SyntaxMetaMgr {
    private Hashtable syntaxMgrList = new Hashtable();
    private Hashtable syntaxMgrBuiltInList = new Hashtable();
    private SyntaxMgr defaultSyntaxMgr = null;
    private SyntaxMgr builtInDefaultSyntaxMgr = null;

    public SyntaxMetaMgr(Options options) {
        this.buildBuiltInSyntaxList();
        this.buildSyntaxMgrList(options);
        SyntaxMgr syntaxMgr = new SyntaxMgr();
        if (this.builtInDefaultSyntaxMgr == null) {
            this.builtInDefaultSyntaxMgr = new SyntaxMgr();
        }
        if (syntaxMgr.add(options.getSyntaxFile())) {
            this.defaultSyntaxMgr = syntaxMgr;
        }
    }

    private void buildSyntaxMgrList(Options options) {
        Enumeration enumeration = options.getSyntaxExtensionList();
        this.syntaxMgrList.clear();
        while (enumeration.hasMoreElements()) {
            String string = ((String)enumeration.nextElement()).toLowerCase();
            String string2 = options.getSyntaxFileName(string);
            if (string2 == null) continue;
            SyntaxMgr syntaxMgr = this.getSyntaxMgr(this.syntaxMgrList, string2);
            if (syntaxMgr == null) {
                syntaxMgr = new SyntaxMgr();
                if (!syntaxMgr.add(string2)) continue;
                syntaxMgr.setSource(string2);
                this.syntaxMgrList.put(string, syntaxMgr);
                continue;
            }
            this.syntaxMgrList.put(string, syntaxMgr);
        }
    }

    public SyntaxMgr getSyntaxMgr(String string) {
        if (this.syntaxMgrList.containsKey(string.toLowerCase())) {
            return (SyntaxMgr)this.syntaxMgrList.get(string.toLowerCase());
        }
        if (this.syntaxMgrBuiltInList.containsKey(string.toLowerCase())) {
            return (SyntaxMgr)this.syntaxMgrBuiltInList.get(string.toLowerCase());
        }
        if (this.defaultSyntaxMgr == null) {
            return this.builtInDefaultSyntaxMgr;
        }
        return this.defaultSyntaxMgr;
    }

    public SyntaxMgr getSyntaxMgr() {
        if (this.defaultSyntaxMgr == null) {
            return this.builtInDefaultSyntaxMgr;
        }
        return this.defaultSyntaxMgr;
    }

    private void buildBuiltInSyntaxList() {
        String string = null;
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("BuiltInSyntax.properties");
        if (inputStream == null) {
            return;
        }
        SyntaxMgr syntaxMgr = new SyntaxMgr();
        try {
            properties.load(inputStream);
        }
        catch (Exception exception) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        this.syntaxMgrBuiltInList.clear();
        InputStream inputStream2 = null;
        while (enumeration.hasMoreElements()) {
            String string2 = ((String)enumeration.nextElement()).toLowerCase();
            string = properties.getProperty(string2);
            if (string == null) continue;
            syntaxMgr = this.getSyntaxMgr(this.syntaxMgrBuiltInList, string);
            if (syntaxMgr == null) {
                syntaxMgr = new SyntaxMgr();
                inputStream2 = this.getClass().getResourceAsStream(string);
                if (inputStream2 == null || !syntaxMgr.add(inputStream2)) continue;
                syntaxMgr.setSource(string);
                if (string2.equals("default")) {
                    this.builtInDefaultSyntaxMgr = syntaxMgr;
                    continue;
                }
                this.syntaxMgrBuiltInList.put(string2, syntaxMgr);
                continue;
            }
            if (string2.equals("default")) {
                this.builtInDefaultSyntaxMgr = syntaxMgr;
                continue;
            }
            this.syntaxMgrBuiltInList.put(string2, syntaxMgr);
        }
    }

    private SyntaxMgr getSyntaxMgr(Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.keys();
        SyntaxMgr syntaxMgr = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            syntaxMgr = (SyntaxMgr)hashtable.get(string2);
            if (syntaxMgr.getSource().compareTo(string) != 0) continue;
            return syntaxMgr;
        }
        return null;
    }

    public Enumeration getBuiltInExtensionList() {
        return this.syntaxMgrBuiltInList.keys();
    }
}

