/*
 * Decompiled with CFR 0.152.
 */
package commands;

import com.inet.jortho.SpellChecker;
import commands.CommandType;
import commands.ICommandGateway;
import gui.Application;
import java.awt.Window;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.LineChooser;
import neutrino.dialogs.TextFinder;
import neutrino.text.ITextComponent;

class EditingCommandGateway
implements ICommandGateway {
    private Application application = null;

    public EditingCommandGateway(Application application) {
        this.application = application;
    }

    @Override
    public void performCommand(CommandType commandType) {
        switch (commandType) {
            case UNDO: {
                this.undo();
                break;
            }
            case REDO: {
                this.redo();
                break;
            }
            case REVERT: {
                this.revert();
                break;
            }
            case CUT: {
                this.cut();
                break;
            }
            case COPY: {
                this.copy();
                break;
            }
            case PASTE: {
                this.paste();
                break;
            }
            case CLEAR: {
                this.clear();
                break;
            }
            case READ_ONLY_MODE: {
                this.readOnlyMode();
                break;
            }
            case GO_TO: {
                this.goTo();
                break;
            }
            case FIND: {
                this.find();
                break;
            }
            case REPLACE: {
                this.replace();
                break;
            }
            case CHECK_SPELLING: {
                this.checkSpelling();
                break;
            }
            case SELECT_ALL: {
                this.selectAll();
                break;
            }
            case DESELECT: {
                this.deselect();
            }
        }
    }

    @Override
    public boolean containsCommand(CommandType commandType) {
        switch (commandType) {
            case UNDO: 
            case REDO: 
            case REVERT: 
            case CUT: 
            case COPY: 
            case PASTE: 
            case CLEAR: 
            case READ_ONLY_MODE: 
            case GO_TO: 
            case FIND: 
            case REPLACE: 
            case CHECK_SPELLING: 
            case SELECT_ALL: 
            case DESELECT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canPerformCommand(CommandType commandType) {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        switch (commandType) {
            case UNDO: {
                return this.canUndo();
            }
            case REDO: {
                return this.canRedo();
            }
            case REVERT: {
                return this.canRevert();
            }
            case CUT: {
                return this.canCut();
            }
            case COPY: {
                return this.canCopy();
            }
            case PASTE: {
                return this.canPaste();
            }
            case CLEAR: {
                return this.canClear();
            }
            case READ_ONLY_MODE: {
                return this.canReadOnlyMode();
            }
            case GO_TO: {
                return this.canGoTo();
            }
            case FIND: {
                return this.canFind();
            }
            case REPLACE: {
                return this.canReplace();
            }
            case CHECK_SPELLING: {
                return this.canCheckSpelling();
            }
            case SELECT_ALL: {
                return this.canSelectAll();
            }
            case DESELECT: {
                return this.canDeselect();
            }
        }
        return true;
    }

    private boolean canUndo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canUndo();
        }
        return false;
    }

    private void undo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            ((ITextComponent)((Object)jTextComponent)).undo();
        }
    }

    private boolean canRedo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canRedo();
        }
        return false;
    }

    private void redo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            ((ITextComponent)((Object)jTextComponent)).redo();
        }
    }

    private boolean canRevert() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canRevert();
        }
        return false;
    }

    private void revert() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            ((ITextComponent)((Object)jTextComponent)).revert();
        }
    }

    private boolean canCut() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canCut();
        }
        return true;
    }

    private void cut() {
        this.application.getTextEditor().getTextComponent().cut();
    }

    private boolean canCopy() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canCopy();
        }
        return true;
    }

    private void copy() {
        this.application.getTextEditor().getTextComponent().copy();
    }

    private boolean canPaste() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canPaste();
        }
        return true;
    }

    private void paste() {
        this.application.getTextEditor().getTextComponent().paste();
    }

    private boolean canClear() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canClear();
        }
        return false;
    }

    private void clear() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            ((ITextComponent)((Object)jTextComponent)).clear();
        }
    }

    private boolean canReadOnlyMode() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canToggleReadOnlyMode();
        }
        return false;
    }

    private void readOnlyMode() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            ((ITextComponent)((Object)jTextComponent)).toggleReadOnlyMode();
        }
    }

    private boolean canGoTo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return !((ITextComponent)((Object)jTextComponent)).isTextEmpty();
        }
        return true;
    }

    private void goTo() {
        LineChooser.showGoToLineDialog(this.application, this.application.getTextEditor().getTextComponent());
    }

    private boolean canFind() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return !((ITextComponent)((Object)jTextComponent)).isTextEmpty();
        }
        return true;
    }

    private void find() {
        TextFinder.showFindDialog((Window)this.application, this.application.getTextEditor().getTextComponent());
    }

    private boolean canReplace() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return !((ITextComponent)((Object)jTextComponent)).isTextEmpty();
        }
        return true;
    }

    private void replace() {
        TextFinder.showReplaceDialog((Window)this.application, this.application.getTextEditor().getTextComponent());
    }

    private boolean canCheckSpelling() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return !((ITextComponent)((Object)jTextComponent)).isTextEmpty();
        }
        return true;
    }

    private void checkSpelling() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        SpellChecker.showSpellCheckerDialog(jTextComponent, SpellChecker.getOptions());
    }

    private boolean canSelectAll() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canSelectAll();
        }
        return true;
    }

    private void selectAll() {
        this.application.getTextEditor().getTextComponent().selectAll();
    }

    private boolean canDeselect() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            return ((ITextComponent)((Object)jTextComponent)).canDeselect();
        }
        return false;
    }

    private void deselect() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            ((ITextComponent)((Object)jTextComponent)).deselect();
        }
    }
}

