/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.CommandType;
import commands.ICommandGateway;
import gui.Application;
import gui.dialog.AdvancedDialog;
import java.awt.Color;
import java.awt.Font;
import java.nio.charset.Charset;
import javax.swing.JColorChooser;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.EncodingChooser;
import neutrino.dialogs.FontChooser;
import neutrino.dialogs.SpellingOptionsChooser;
import neutrino.dialogs.TextOptionsChooser;
import neutrino.dialogs.WindowOptionsChooser;
import neutrino.text.components.plain.PlainTextArea;

class SettingsCommandGateway
implements ICommandGateway {
    private Application application = null;

    public SettingsCommandGateway(Application application) {
        this.application = application;
    }

    @Override
    public void performCommand(CommandType commandType) {
        switch (commandType) {
            case FOREGROUND: {
                this.foreground();
                break;
            }
            case BACKGROUND: {
                this.background();
                break;
            }
            case FONT: {
                this.font();
                break;
            }
            case ENCODING: {
                this.encoding();
                break;
            }
            case SPELLING: {
                this.spelling();
                break;
            }
            case TEXT_OPTIONS: {
                this.changeTextOptions();
                break;
            }
            case WINDOW_OPTIONS: {
                this.changeWindowOptions();
                break;
            }
            case ADVANCED: {
                this.advanced();
            }
        }
    }

    @Override
    public boolean containsCommand(CommandType commandType) {
        switch (commandType) {
            case FOREGROUND: 
            case BACKGROUND: 
            case FONT: 
            case ENCODING: 
            case SPELLING: 
            case TEXT_OPTIONS: 
            case WINDOW_OPTIONS: 
            case ADVANCED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canPerformCommand(CommandType commandType) {
        return true;
    }

    private void foreground() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        Color color = jTextComponent.getForeground();
        Color color2 = JColorChooser.showDialog(this.application, "Foreground", color);
        if (color2 == null) {
            return;
        }
        jTextComponent.setForeground(color2);
    }

    private void background() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        Color color = jTextComponent.getBackground();
        Color color2 = JColorChooser.showDialog(this.application, "Background", color);
        if (color2 == null) {
            return;
        }
        jTextComponent.setBackground(color2);
    }

    private void font() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        Font font = jTextComponent.getFont();
        Font font2 = FontChooser.showFontDialog(this.application, font);
        if (font2 == null) {
            return;
        }
        jTextComponent.setFont(font2);
    }

    private void encoding() {
        Charset charset = this.application.getTextEditor().getEncoding();
        Charset charset2 = EncodingChooser.showEncodingDialog(this.application, charset);
        if (charset2 != null) {
            this.application.getTextEditor().setEncoding(charset2);
        }
    }

    private void spelling() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        SpellingOptionsChooser.showSpellingOptionsDialog(this.application, jTextComponent, null);
    }

    private void changeTextOptions() {
        PlainTextArea plainTextArea = (PlainTextArea)this.application.getTextEditor().getTextComponent();
        TextOptionsChooser.showPlainTextOptionsDialog(this.application, plainTextArea);
    }

    private void changeWindowOptions() {
        WindowOptionsChooser.showWindowOptionsDialog(this.application);
    }

    private void advanced() {
        AdvancedDialog.showAdvancedDialog(this.application);
    }
}

