/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JScrollPane;
import neutrino.text.FileChangeEvent;
import neutrino.text.FileChangeListener;
import neutrino.text.TextEditor;
import neutrino.text.components.plain.PlainTextArea;

abstract class ContentBuilder
extends Application {
    private TextEditor textEditor = null;
    private JScrollPane scrollPane = null;
    private FileChangeListener editorListener = new FileChangeListener(){

        @Override
        public void fileChanged(FileChangeEvent fileChangeEvent) {
            switch (fileChangeEvent.getType()) {
                case CLEARING: 
                case REMOVING: {
                    ContentBuilder.this.setTitle("Extended Text Editor");
                    break;
                }
                case OPENING: 
                case SAVING: 
                case RESTORING: 
                case RENAMING: 
                case MOVING: {
                    File file = fileChangeEvent.getSource().getFile();
                    if (file == null) break;
                    ContentBuilder.this.getTextEditor().setCurrentDirectory(file.getParentFile());
                    ContentBuilder.this.setTitle("Extended Text Editor - " + fileChangeEvent.getSource().getFile().getAbsolutePath());
                }
            }
        }
    };

    public ContentBuilder() {
        PlainTextArea plainTextArea = new PlainTextArea();
        plainTextArea.setUndoable(true);
        this.textEditor = new TextEditor(plainTextArea);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.textEditor.getTextComponent());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.textEditor.addFileChangeListener(this.editorListener);
    }

    @Override
    public TextEditor getTextEditor() {
        return this.textEditor;
    }
}

