/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.inet.jortho.SpellChecker;
import commands.CommandType;
import gui.ContentBuilder;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.LookAndFeelChooser;
import neutrino.text.ITextComponent;
import neutrino.text.ReadModeEvent;
import neutrino.text.ReadModeListener;

abstract class MenuBarBuilder
extends ContentBuilder {
    private JMenuBar menuBar = null;
    private ClassLoader loader = MenuBarBuilder.class.getClassLoader();
    protected ImageIcon iconNew = new ImageIcon(this.loader.getResource("icons/new.gif"));
    protected ImageIcon iconOpen = new ImageIcon(this.loader.getResource("icons/open.gif"));
    protected ImageIcon iconReload = new ImageIcon(this.loader.getResource("icons/reload.gif"));
    protected ImageIcon iconRestore = new ImageIcon(this.loader.getResource("icons/restore.gif"));
    protected ImageIcon iconSave = new ImageIcon(this.loader.getResource("icons/save.gif"));
    protected ImageIcon iconRevert = new ImageIcon(this.loader.getResource("icons/revert.gif"));
    protected ImageIcon iconPrint = new ImageIcon(this.loader.getResource("icons/print.gif"));
    protected ImageIcon iconExit = new ImageIcon(this.loader.getResource("icons/exit.gif"));
    protected ImageIcon iconUndo = new ImageIcon(this.loader.getResource("icons/undo.gif"));
    protected ImageIcon iconRedo = new ImageIcon(this.loader.getResource("icons/redo.gif"));
    protected ImageIcon iconCut = new ImageIcon(this.loader.getResource("icons/cut.gif"));
    protected ImageIcon iconCopy = new ImageIcon(this.loader.getResource("icons/copy.gif"));
    protected ImageIcon iconPaste = new ImageIcon(this.loader.getResource("icons/paste.gif"));
    protected ImageIcon iconClear = new ImageIcon(this.loader.getResource("icons/clear.gif"));
    protected ImageIcon iconGoTo = new ImageIcon(this.loader.getResource("icons/goTo.gif"));
    protected ImageIcon iconFind = new ImageIcon(this.loader.getResource("icons/find.gif"));
    protected ImageIcon iconReplace = new ImageIcon(this.loader.getResource("icons/replace.gif"));
    protected ImageIcon iconSpelling = new ImageIcon(this.loader.getResource("icons/spelling.gif"));
    protected ImageIcon iconLanguages = new ImageIcon(this.loader.getResource("icons/languages.gif"));
    protected ImageIcon iconSelectAll = new ImageIcon(this.loader.getResource("icons/selectAll.gif"));
    protected ImageIcon iconDeselect = new ImageIcon(this.loader.getResource("icons/deselect.gif"));
    protected ImageIcon iconForeground = new ImageIcon(this.loader.getResource("icons/foreground.gif"));
    protected ImageIcon iconBackground = new ImageIcon(this.loader.getResource("icons/background.gif"));
    protected ImageIcon iconFont = new ImageIcon(this.loader.getResource("icons/font.gif"));
    protected ImageIcon iconEncoding = new ImageIcon(this.loader.getResource("icons/encoding.gif"));
    protected ImageIcon iconAdvanced = new ImageIcon(this.loader.getResource("icons/advanced.gif"));
    protected ImageIcon iconUpperCase = new ImageIcon(this.loader.getResource("icons/upperCase.gif"));
    protected ImageIcon iconLowerCase = new ImageIcon(this.loader.getResource("icons/lowerCase.gif"));
    protected ImageIcon iconDeleteHorizontalWhiteSpace = new ImageIcon(this.loader.getResource("icons/deleteHorizontalWhiteSpace.gif"));
    protected ImageIcon iconShiftLeft = new ImageIcon(this.loader.getResource("icons/shiftLeft.gif"));
    protected ImageIcon iconShiftRight = new ImageIcon(this.loader.getResource("icons/shiftRight.gif"));
    protected ImageIcon iconComplexOperation = new ImageIcon(this.loader.getResource("icons/complexOperation.gif"));
    protected ImageIcon iconHelp = new ImageIcon(this.loader.getResource("icons/help.gif"));
    protected ImageIcon iconAbout = new ImageIcon(this.loader.getResource("icons/about.gif"));
    protected JMenu mFile = new JMenu("File");
    protected JMenuItem miNew = new JMenuItem("New", this.iconNew);
    protected JMenuItem miOpen = new JMenuItem("Open...", this.iconOpen);
    protected JMenuItem miRestore = new JMenuItem("Restore...", this.iconRestore);
    protected JMenuItem miReload = new JMenuItem("Reload", this.iconReload);
    protected JMenuItem miSave = new JMenuItem("Save", this.iconSave);
    protected JMenuItem miSaveAs = new JMenuItem("Save as...");
    protected JMenuItem miPrint = new JMenuItem("Print...", this.iconPrint);
    protected JMenuItem miCopyFile = new JMenuItem("Copy...", this.iconCopy);
    protected JMenuItem miMove = new JMenuItem("Move...");
    protected JMenuItem miRemove = new JMenuItem("Remove", this.iconClear);
    protected JMenuItem miRename = new JMenuItem("Rename...");
    protected JCheckBoxMenuItem miExecute = new JCheckBoxMenuItem("Execute");
    protected JCheckBoxMenuItem miReadOnly = new JCheckBoxMenuItem("Read Only");
    protected JCheckBoxMenuItem miWriteOnly = new JCheckBoxMenuItem("Write Only");
    protected JCheckBoxMenuItem miHidden = new JCheckBoxMenuItem("Hidden");
    protected JMenuItem miExit = new JMenuItem("Exit", this.iconExit);
    protected JMenu mEdit = new JMenu("Edit");
    protected JMenuItem miUndo = new JMenuItem("Undo", this.iconUndo);
    protected JMenuItem miRedo = new JMenuItem("Redo", this.iconRedo);
    protected JMenuItem miRevert = new JMenuItem("Revert", this.iconRevert);
    protected JMenuItem miCut = new JMenuItem("Cut", this.iconCut);
    protected JMenuItem miCopy = new JMenuItem("Copy", this.iconCopy);
    protected JMenuItem miPaste = new JMenuItem("Paste", this.iconPaste);
    protected JMenuItem miClear = new JMenuItem("Clear", this.iconClear);
    protected JCheckBoxMenuItem miReadOnlyMode = new JCheckBoxMenuItem("Read Only Mode");
    protected JMenuItem miGoTo = new JMenuItem("Go to...", this.iconGoTo);
    protected JMenuItem miFind = new JMenuItem("Find...", this.iconFind);
    protected JMenuItem miReplace = new JMenuItem("Replace...", this.iconReplace);
    protected JMenuItem miCheckSpelling = new JMenuItem("Spelling...", this.iconSpelling);
    protected JMenu mLanguages;
    protected JMenuItem miSelectAll = new JMenuItem("Select all", this.iconSelectAll);
    protected JMenuItem miDeselect = new JMenuItem("Deselect", this.iconDeselect);
    protected JMenu mCommand = new JMenu("Command");
    protected JMenu mChangeCaseLetters = new JMenu("Change Case Letters");
    protected JMenuItem miMakeUpperCase = new JMenuItem("Make Upper Case", this.iconUpperCase);
    protected JMenuItem miMakeLowerCase = new JMenuItem("Make Lower Case", this.iconLowerCase);
    protected JMenuItem miMakeTitleCase = new JMenuItem("Make Title Case");
    protected JMenuItem miInvertCaseLetters = new JMenuItem("Invert Case Letters");
    protected JMenuItem miCapitalizeWords = new JMenuItem("Capitalize Words");
    protected JMenuItem miInvertCapitalization = new JMenuItem("Invert Capitalization");
    protected JMenu mManageWhiteSpace = new JMenu("Manage White Space");
    protected JMenuItem miTabifySelectedLines = new JMenuItem("Tabify Selected Lines");
    protected JMenuItem miUntabifySelectedLines = new JMenuItem("Untabify Selected Lines");
    protected JMenuItem miTrimSelectedLines = new JMenuItem("Trim Selected Lines");
    protected JMenuItem miRemoveEmptyLines = new JMenuItem("Remove Empty Lines");
    protected JMenuItem miDeleteHorizontalWhiteSpace = new JMenuItem("Delete Horizontal White Space", this.iconDeleteHorizontalWhiteSpace);
    protected JMenuItem miRemoveTrailingWhitespaces = new JMenuItem("Remove Trailing White Space");
    protected JMenu mSortSelectedLines = new JMenu("Sort Selected Lines");
    protected JMenuItem miJoinSelectedLines = new JMenuItem("Join Selected Lines");
    protected JMenuItem miDuplicateSelectedLines = new JMenuItem("Duplicate Selected Lines");
    protected JMenuItem miSplitIntoLines = new JMenuItem("Split Into Lines");
    protected JMenuItem miSortLinesAscendant = new JMenuItem("Sort Lines Ascendant");
    protected JMenuItem miSortLinesDescendant = new JMenuItem("Sort Lines Descendant");
    protected JMenu mMoveText = new JMenu("Move Text");
    protected JMenuItem miShiftInRight = new JMenuItem("Increase Line Indent", this.iconShiftRight);
    protected JMenuItem miShiftInLeft = new JMenuItem("Decrease Line Indent", this.iconShiftLeft);
    protected JMenuItem miMoveLinesUp = new JMenuItem("Move Lines Up");
    protected JMenuItem miMoveLinesDown = new JMenuItem("Move Lines Down");
    protected JMenu mAlignSelectedText = new JMenu("Align Selected Text");
    protected JMenuItem miAlignTextLeft = new JMenuItem("Align Text Left");
    protected JMenuItem miAlignTextRight = new JMenuItem("Align Text Right");
    protected JMenuItem miCenterText = new JMenuItem("Center Text");
    protected JMenuItem miJustifyText = new JMenuItem("Justify Text");
    protected JMenuItem miMakeLatinParagraph = new JMenuItem("Make Latin Paragraph");
    protected JMenuItem miMakeCyrillicParagraph = new JMenuItem("Make Cyrillic Paragraph");
    protected JMenuItem miPerformComplexOperation = new JMenuItem("Perform Complex Operation...", this.iconComplexOperation);
    protected JMenu mOptions = new JMenu("Options");
    protected JMenuItem miForeground = new JMenuItem("Foreground...", this.iconForeground);
    protected JMenuItem miBackground = new JMenuItem("Background...", this.iconBackground);
    protected JMenuItem miFont = new JMenuItem("Font...", this.iconFont);
    protected JMenuItem miEncoding = new JMenuItem("Encoding...", this.iconEncoding);
    protected JMenuItem miSpelling = new JMenuItem("Spelling...", this.iconSpelling);
    protected JMenuItem miText = new JMenuItem("Text...");
    protected JMenuItem miWindow = new JMenuItem("Window...");
    protected JMenu mLookAndFeel;
    protected JMenuItem miAdvanced = new JMenuItem("Advanced...", this.iconAdvanced);
    protected JMenu mHelp = new JMenu("Help");
    protected JMenuItem miHelp = new JMenuItem("Help", this.iconHelp);
    protected JMenuItem miGame = new JMenuItem("Game");
    protected JMenuItem miLicense = new JMenuItem("License");
    protected JMenuItem miAbout = new JMenuItem("About", this.iconAbout);
    private MenuListener mlFile = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.miNew.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.NEW));
            MenuBarBuilder.this.miSave.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.SAVE));
            MenuBarBuilder.this.miSaveAs.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.SAVE_AS));
            MenuBarBuilder.this.miReload.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.RELOAD));
            MenuBarBuilder.this.miPrint.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.PRINT));
            MenuBarBuilder.this.miRestore.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.RESTORE));
            MenuBarBuilder.this.miMove.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MOVE));
            MenuBarBuilder.this.miCopyFile.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.COPY_FILE));
            MenuBarBuilder.this.miRemove.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.REMOVE));
            MenuBarBuilder.this.miRename.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.RENAME));
            MenuBarBuilder.this.miExecute.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.EXECUTE));
            MenuBarBuilder.this.miReadOnly.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.READ_ONLY));
            MenuBarBuilder.this.miWriteOnly.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.WRITE_ONLY));
            MenuBarBuilder.this.miHidden.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.HIDDEN));
            MenuBarBuilder.this.miExecute.setSelected(MenuBarBuilder.this.getTextEditor().isExecute());
            MenuBarBuilder.this.miReadOnly.setSelected(MenuBarBuilder.this.getTextEditor().isReadOnly());
            MenuBarBuilder.this.miWriteOnly.setSelected(MenuBarBuilder.this.getTextEditor().isWriteOnly());
            MenuBarBuilder.this.miHidden.setSelected(MenuBarBuilder.this.getTextEditor().isHidden());
        }
    };
    private MenuListener mlEdit = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.miUndo.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.UNDO));
            MenuBarBuilder.this.miRedo.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.REDO));
            MenuBarBuilder.this.miRevert.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.REVERT));
            MenuBarBuilder.this.miCut.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.CUT));
            MenuBarBuilder.this.miCopy.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.COPY));
            MenuBarBuilder.this.miPaste.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.PASTE));
            MenuBarBuilder.this.miClear.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.CLEAR));
            MenuBarBuilder.this.miReadOnlyMode.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.READ_ONLY_MODE));
            MenuBarBuilder.this.miGoTo.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.GO_TO));
            MenuBarBuilder.this.miFind.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.FIND));
            MenuBarBuilder.this.miReplace.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.REPLACE));
            MenuBarBuilder.this.miCheckSpelling.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.CHECK_SPELLING));
            MenuBarBuilder.this.miSelectAll.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.SELECT_ALL));
            MenuBarBuilder.this.miDeselect.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.DESELECT));
            JTextComponent jTextComponent = MenuBarBuilder.this.getTextEditor().getTextComponent();
            if (jTextComponent instanceof ITextComponent) {
                MenuBarBuilder.this.miReadOnlyMode.setSelected(((ITextComponent)((Object)jTextComponent)).isReadOnlyMode());
            } else {
                MenuBarBuilder.this.miReadOnlyMode.setSelected(false);
            }
        }
    };
    private MenuListener mlCommand = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.miMakeUpperCase.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MAKE_UPPER_CASE));
            MenuBarBuilder.this.miMakeLowerCase.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MAKE_LOWER_CASE));
            MenuBarBuilder.this.miMakeTitleCase.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MAKE_TITLE_CASE));
            MenuBarBuilder.this.miInvertCaseLetters.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.INVERT_CASE_LETTERS));
            MenuBarBuilder.this.miCapitalizeWords.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.CAPITALIZE_WORDS));
            MenuBarBuilder.this.miInvertCapitalization.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.INVERT_CAPITALIZATION));
            MenuBarBuilder.this.miTabifySelectedLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.TABIFY_SELECTED_LINES));
            MenuBarBuilder.this.miUntabifySelectedLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.UNTABIFY_SELECTED_LINES));
            MenuBarBuilder.this.miTrimSelectedLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.TRIM_SELECTED_LINES));
            MenuBarBuilder.this.miDeleteHorizontalWhiteSpace.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.DELETE_HORIZONTAL_WHITE_SPACE));
            MenuBarBuilder.this.miRemoveTrailingWhitespaces.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.REMOVE_TRAILING_WHITESPACES));
            MenuBarBuilder.this.miJoinSelectedLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.JOIN_SELECTED_LINES));
            MenuBarBuilder.this.miDuplicateSelectedLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.DUPLICATE_SELECTED_LINES));
            MenuBarBuilder.this.miRemoveEmptyLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.REMOVE_EMPTY_LIENS));
            MenuBarBuilder.this.miSplitIntoLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.SPLIT_INTO_LINES));
            MenuBarBuilder.this.miSortLinesAscendant.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.SORT_LINES_ASCENDANT));
            MenuBarBuilder.this.miSortLinesDescendant.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.SORT_LINES_DESCENDANT));
            MenuBarBuilder.this.miMoveLinesUp.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MOVE_LINES_UP));
            MenuBarBuilder.this.miMoveLinesDown.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MOVE_LINES_DOWN));
            MenuBarBuilder.this.miShiftInLeft.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.DECREASE_LINE_INDENT));
            MenuBarBuilder.this.miShiftInRight.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.INCREASE_LINE_INDENT));
            MenuBarBuilder.this.miAlignTextLeft.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.ALIGN_TEXT_LEFT));
            MenuBarBuilder.this.miAlignTextRight.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.ALIGN_TEXT_RIGHT));
            MenuBarBuilder.this.miCenterText.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.CENTER_TEXT));
            MenuBarBuilder.this.miJustifyText.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.JUSTIFY_TEXT));
            MenuBarBuilder.this.miMakeLatinParagraph.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MAKE_LATIN_PARAGRAPH));
            MenuBarBuilder.this.miMakeCyrillicParagraph.setEnabled(MenuBarBuilder.this.getCommandGateway().canPerformCommand(CommandType.MAKE_CYRILLIC_PARAGRAPH));
        }
    };
    private ReadModeListener readModeListener = new ReadModeListener(){

        @Override
        public void readModeChanged(ReadModeEvent readModeEvent) {
            JTextComponent jTextComponent = MenuBarBuilder.this.getTextEditor().getTextComponent();
            if (jTextComponent instanceof ITextComponent) {
                MenuBarBuilder.this.mCommand.setEnabled(!((ITextComponent)((Object)jTextComponent)).isReadOnlyMode());
            }
        }
    };

    public MenuBarBuilder() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.mLanguages = SpellChecker.createLanguagesMenu();
        this.mLanguages.setIcon(this.iconLanguages);
        this.mLookAndFeel = LookAndFeelChooser.createLookAndFeelMenu(this);
        JTextComponent jTextComponent = this.getTextEditor().getTextComponent();
        if (jTextComponent instanceof ITextComponent) {
            ((ITextComponent)((Object)jTextComponent)).addReadModeListener(this.readModeListener);
        }
    }

    private void buildMenus() {
        this.menuBar.add(this.mFile);
        this.menuBar.add(this.mEdit);
        this.menuBar.add(this.mCommand);
        this.menuBar.add(this.mOptions);
        this.menuBar.add(this.mHelp);
        this.mFile.add(this.miNew);
        this.mFile.add(this.miOpen);
        this.mFile.add(this.miReload);
        this.mFile.add(this.miRestore);
        this.mFile.addSeparator();
        this.mFile.add(this.miSave);
        this.mFile.add(this.miSaveAs);
        this.mFile.add(this.miPrint);
        this.mFile.addSeparator();
        this.mFile.add(this.miCopyFile);
        this.mFile.add(this.miMove);
        this.mFile.add(this.miRemove);
        this.mFile.add(this.miRename);
        this.mFile.addSeparator();
        this.mFile.add(this.miExecute);
        this.mFile.add(this.miReadOnly);
        this.mFile.add(this.miWriteOnly);
        this.mFile.add(this.miHidden);
        this.mFile.addSeparator();
        this.mFile.add(this.miExit);
        this.mEdit.add(this.miUndo);
        this.mEdit.add(this.miRedo);
        this.mEdit.add(this.miRevert);
        this.mEdit.addSeparator();
        this.mEdit.add(this.miCut);
        this.mEdit.add(this.miCopy);
        this.mEdit.add(this.miPaste);
        this.mEdit.add(this.miClear);
        this.mEdit.addSeparator();
        this.mEdit.add(this.miReadOnlyMode);
        this.mEdit.add(this.miGoTo);
        this.mEdit.add(this.miFind);
        this.mEdit.add(this.miReplace);
        this.mEdit.add(this.miCheckSpelling);
        this.mEdit.add(this.mLanguages);
        this.mEdit.addSeparator();
        this.mEdit.add(this.miSelectAll);
        this.mEdit.add(this.miDeselect);
        this.mCommand.add(this.mChangeCaseLetters);
        this.mCommand.add(this.mManageWhiteSpace);
        this.mCommand.add(this.mSortSelectedLines);
        this.mCommand.add(this.mMoveText);
        this.mCommand.add(this.mAlignSelectedText);
        this.mChangeCaseLetters.add(this.miMakeUpperCase);
        this.mChangeCaseLetters.add(this.miMakeLowerCase);
        this.mChangeCaseLetters.add(this.miMakeTitleCase);
        this.mChangeCaseLetters.add(this.miInvertCaseLetters);
        this.mChangeCaseLetters.add(this.miCapitalizeWords);
        this.mChangeCaseLetters.add(this.miInvertCapitalization);
        this.mManageWhiteSpace.add(this.miTabifySelectedLines);
        this.mManageWhiteSpace.add(this.miUntabifySelectedLines);
        this.mManageWhiteSpace.add(this.miTrimSelectedLines);
        this.mManageWhiteSpace.add(this.miRemoveEmptyLines);
        this.mManageWhiteSpace.add(this.miDeleteHorizontalWhiteSpace);
        this.mManageWhiteSpace.add(this.miRemoveTrailingWhitespaces);
        this.mSortSelectedLines.add(this.miJoinSelectedLines);
        this.mSortSelectedLines.add(this.miDuplicateSelectedLines);
        this.mSortSelectedLines.add(this.miSplitIntoLines);
        this.mSortSelectedLines.add(this.miSortLinesAscendant);
        this.mSortSelectedLines.add(this.miSortLinesDescendant);
        this.mMoveText.add(this.miShiftInRight);
        this.mMoveText.add(this.miShiftInLeft);
        this.mMoveText.add(this.miMoveLinesUp);
        this.mMoveText.add(this.miMoveLinesDown);
        this.mAlignSelectedText.add(this.miAlignTextLeft);
        this.mAlignSelectedText.add(this.miAlignTextRight);
        this.mAlignSelectedText.add(this.miCenterText);
        this.mAlignSelectedText.add(this.miJustifyText);
        this.mAlignSelectedText.add(this.miMakeLatinParagraph);
        this.mAlignSelectedText.add(this.miMakeCyrillicParagraph);
        this.mCommand.addSeparator();
        this.mCommand.add(this.miPerformComplexOperation);
        this.mOptions.add(this.miForeground);
        this.mOptions.add(this.miBackground);
        this.mOptions.add(this.miFont);
        this.mOptions.add(this.miEncoding);
        this.mOptions.add(this.miSpelling);
        this.mOptions.add(this.miText);
        this.mOptions.add(this.miWindow);
        this.mOptions.add(this.mLookAndFeel);
        this.mOptions.add(this.miAdvanced);
        this.mHelp.add(this.miHelp);
        this.mHelp.add(this.miGame);
        this.mHelp.add(this.miLicense);
        this.mHelp.add(this.miAbout);
    }

    private void buildAccelerators() {
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.miOpen.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.miSave.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.miReload.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.miExit.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.miRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.miCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.miClear.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.miGoTo.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.miFind.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.miReplace.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.miCheckSpelling.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.miSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.miDeselect.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.miMakeUpperCase.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        this.miMakeLowerCase.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.miDeleteHorizontalWhiteSpace.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        this.miRemoveTrailingWhitespaces.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.miShiftInLeft.setAccelerator(KeyStroke.getKeyStroke(37, 512));
        this.miShiftInRight.setAccelerator(KeyStroke.getKeyStroke(39, 512));
        this.miMoveLinesUp.setAccelerator(KeyStroke.getKeyStroke(38, 128));
        this.miMoveLinesDown.setAccelerator(KeyStroke.getKeyStroke(40, 128));
        this.miFont.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.miEncoding.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.miAdvanced.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        this.miHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
    }

    private void buildMnemonics() {
        this.mFile.setMnemonic(70);
        this.mEdit.setMnemonic(69);
        this.mCommand.setMnemonic(67);
        this.mHelp.setMnemonic(72);
        this.mOptions.setMnemonic(79);
        this.miNew.setMnemonic(78);
        this.miOpen.setMnemonic(79);
        this.miRestore.setMnemonic(69);
        this.miSave.setMnemonic(83);
        this.miSaveAs.setMnemonic(65);
        this.miReload.setMnemonic(76);
        this.miPrint.setMnemonic(80);
        this.miCopyFile.setMnemonic(67);
        this.miMove.setMnemonic(86);
        this.miRemove.setMnemonic(82);
        this.miRename.setMnemonic(77);
        this.miExecute.setMnemonic(85);
        this.miReadOnly.setMnemonic(68);
        this.miWriteOnly.setMnemonic(87);
        this.miHidden.setMnemonic(72);
        this.miExit.setMnemonic(88);
        this.miUndo.setMnemonic(85);
        this.miRedo.setMnemonic(82);
        this.miRevert.setMnemonic(69);
        this.miCut.setMnemonic(67);
        this.miCopy.setMnemonic(79);
        this.miPaste.setMnemonic(84);
        this.miClear.setMnemonic(76);
        this.miReadOnlyMode.setMnemonic(65);
        this.miGoTo.setMnemonic(71);
        this.miFind.setMnemonic(70);
        this.miReplace.setMnemonic(82);
        this.miCheckSpelling.setMnemonic(80);
        this.mLanguages.setMnemonic(78);
        this.miSelectAll.setMnemonic(83);
        this.miDeselect.setMnemonic(68);
        this.mChangeCaseLetters.setMnemonic(76);
        this.mManageWhiteSpace.setMnemonic(83);
        this.mSortSelectedLines.setMnemonic(79);
        this.mMoveText.setMnemonic(77);
        this.mAlignSelectedText.setMnemonic(65);
        this.miPerformComplexOperation.setMnemonic(70);
        this.miMakeUpperCase.setMnemonic(80);
        this.miMakeLowerCase.setMnemonic(76);
        this.miMakeTitleCase.setMnemonic(75);
        this.miInvertCaseLetters.setMnemonic(78);
        this.miCapitalizeWords.setMnemonic(67);
        this.miInvertCapitalization.setMnemonic(90);
        this.miTabifySelectedLines.setMnemonic(84);
        this.miUntabifySelectedLines.setMnemonic(66);
        this.miTrimSelectedLines.setMnemonic(77);
        this.miRemoveEmptyLines.setMnemonic(79);
        this.miDeleteHorizontalWhiteSpace.setMnemonic(87);
        this.miRemoveTrailingWhitespaces.setMnemonic(71);
        this.miJoinSelectedLines.setMnemonic(74);
        this.miSplitIntoLines.setMnemonic(83);
        this.miDuplicateSelectedLines.setMnemonic(65);
        this.miSortLinesAscendant.setMnemonic(82);
        this.miSortLinesDescendant.setMnemonic(68);
        this.miShiftInRight.setMnemonic(73);
        this.miShiftInLeft.setMnemonic(69);
        this.miMoveLinesUp.setMnemonic(85);
        this.miMoveLinesDown.setMnemonic(86);
        this.miAlignTextLeft.setMnemonic(70);
        this.miAlignTextRight.setMnemonic(72);
        this.miCenterText.setMnemonic(88);
        this.miJustifyText.setMnemonic(74);
        this.miMakeLatinParagraph.setMnemonic(75);
        this.miMakeCyrillicParagraph.setMnemonic(89);
        this.miForeground.setMnemonic(79);
        this.miBackground.setMnemonic(66);
        this.miFont.setMnemonic(70);
        this.miEncoding.setMnemonic(69);
        this.miSpelling.setMnemonic(83);
        this.miText.setMnemonic(84);
        this.miWindow.setMnemonic(87);
        this.miAdvanced.setMnemonic(65);
        this.miHelp.setMnemonic(72);
        this.miGame.setMnemonic(71);
        this.miLicense.setMnemonic(76);
        this.miAbout.setMnemonic(65);
    }

    protected void buildActions() {
        this.mFile.addMenuListener(this.mlFile);
        this.mEdit.addMenuListener(this.mlEdit);
        this.mCommand.addMenuListener(this.mlCommand);
    }

    protected void buildMenuBar() {
        this.buildMenus();
        this.buildAccelerators();
        this.buildMnemonics();
    }
}

