/*
 * Decompiled with CFR 0.152.
 */
package properties;

import gui.Application;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import properties.EditorProperties;

public class PropertiesManager {
    private static final String PROPERTIES_FILE_NAME = "properties.dat";
    private Application application = null;
    private EditorProperties properties = null;

    public PropertiesManager(Application application) {
        this.application = application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(String[] stringArray) {
        File file = new File(PROPERTIES_FILE_NAME);
        ObjectInputStream objectInputStream = null;
        boolean bl = false;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.properties = (EditorProperties)objectInputStream.readObject();
            if (this.properties != null) {
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (!bl) {
            this.properties = new EditorProperties();
        }
        this.properties.establishProperties(this.application, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        File file = new File(PROPERTIES_FILE_NAME);
        ObjectOutputStream objectOutputStream = null;
        try {
            this.properties.buildProperties(this.application);
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(this.properties);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

