package commands;

/**
 * Interface to command gateways
 * @author Oleh Radvanskyj
 * @version 1.0
 * Date: 8/21/16
 * Time: 5:08 AM
 */
public interface ICommandGateway {

    /**
     * Performs command appropriate to given type
     * @param command - CommandType
     */
    public void performCommand(CommandType command);

    /**
     * Returns true when the command gateway contains the command
     * @param command - CommandType
     * @return - boolean
     */
    public boolean containsCommand(CommandType command);

    /**
     * Returns true when can perform command appropriate to given type
     * @param command - CommandType
     * @return boolean
     */
    public boolean canPerformCommand(CommandType command);

}
