package commands;

import gui.Application;
import gui.dialog.AdvancedDialog;
import java.awt.Color;
import java.awt.Font;
import java.nio.charset.Charset;
import javax.swing.JColorChooser;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.*;
import neutrino.text.components.plain.PlainTextArea;

/**
 * Gateway to program settings.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
class SettingsCommandGateway implements ICommandGateway {

	private Application application = null;
	
	public SettingsCommandGateway(Application application) {
		this.application = application;
	}

    /**
     * Performs command appropriate to given type
     * @param command - CommandType
     */
    public void performCommand(CommandType command) {
        switch (command) {
            case FOREGROUND:
                foreground();
                break;
            case BACKGROUND:
                background();
                break;
            case FONT:
                font();
                break;
            case ENCODING:
                encoding();
                break;
            case SPELLING:
                spelling();
                break;
            case TEXT_OPTIONS:
                changeTextOptions();
                break;
            case WINDOW_OPTIONS:
                changeWindowOptions();
                break;
            case ADVANCED:
                advanced();
                break;
        }
    }

    /**
     * Returns true when the command gateway contains the command
     * @param command - CommandType
     * @return - boolean
     */
    public boolean containsCommand(CommandType command) {
        switch (command) {
            case FOREGROUND:
            case BACKGROUND:
            case FONT:
            case ENCODING:
            case SPELLING:
            case TEXT_OPTIONS:
            case WINDOW_OPTIONS:
            case ADVANCED:
                return true;
            default:
                return false;
        }
    }

    /**
     * Returns true when can perform command appropriate to given type
     * @param command - CommandType
     * @return boolean
     */
    public boolean canPerformCommand(CommandType command) {
        return true;
    }

	private void foreground() {
		JTextComponent textComponent = application.getTextEditor().getTextComponent();
		Color currentColor = textComponent.getForeground();
		Color color = JColorChooser.showDialog(application, "Foreground", currentColor);
		if (color == null) return;
		textComponent.setForeground(color);
	}

    private void background() {
		JTextComponent textComponent = application.getTextEditor().getTextComponent();
		Color currentColor = textComponent.getBackground();
		Color color = JColorChooser.showDialog(application, "Background", currentColor);
		if (color == null) return;
		textComponent.setBackground(color);
	}

    private void font() {
		JTextComponent textComponent = application.getTextEditor().getTextComponent();
		Font currentFont = textComponent.getFont();
		Font font = FontChooser.showFontDialog(application, currentFont);
		if (font == null) return;
		textComponent.setFont(font);
	}

    private void encoding() {
		Charset currentEncoding = application.getTextEditor().getEncoding();
		Charset encoding = EncodingChooser.showEncodingDialog(application, currentEncoding);
		if (encoding != null) {
			application.getTextEditor().setEncoding(encoding);
		}
	}

    private void spelling() {
        JTextComponent textComponent = application.getTextEditor().getTextComponent();
        SpellingOptionsChooser.showSpellingOptionsDialog(application, textComponent, null);
    }

    private void changeTextOptions() {
        PlainTextArea textComponent = (PlainTextArea) application.getTextEditor().getTextComponent();
        TextOptionsChooser.showPlainTextOptionsDialog(application, textComponent);
    }

    private void changeWindowOptions() {
        WindowOptionsChooser.showWindowOptionsDialog(application);
    }

    private void advanced() {
		AdvancedDialog.showAdvancedDialog(application);
	}	

}
