package gui;

import neutrino.TextEditorWindow;
import commands.CommandGateway;
import properties.PropertiesManager;
import properties.Settings;

/**
 * Supply services of program.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public abstract class Application extends TextEditorWindow {

    protected final String PROGRAM_NAME = "Extended Text Editor";
    protected final String TITLE_HEAD = "Extended Text Editor - ";
    private final String ICON_FILE_NAME = "extendedTextEditor.gif";

	private PropertiesManager propertiesManager = null;
	private Settings settings = null;
		
	public Application() {
		super();
        DEFAULT_WINDOW_WIDTH = 800;
        DEFAULT_WINDOW_HEIGHT = 500;
		setTitle(PROGRAM_NAME);
        setSize(getDefaultSize());
        centerWindowOnScreen();
        setIconImage(getToolkit().createImage(ICON_FILE_NAME));
		propertiesManager = new PropertiesManager(this);
		settings = new Settings();
	}
	
	/**
	 * Returns settings of programs object
	 * @return Settings instance
	 */
	public Settings getSettings() {
		return this.settings;
	}

    /**
     * Sets settings of program.
     * @param settings - Settings
     */
    public void setSettings(Settings settings) {
        if (settings == null) return;
        this.settings = settings;
    }

	/**
	 * Obtain CommandGateway.
	 * @return instance of CommandGateway
	 */
	public abstract CommandGateway getCommandGateway();

	/**
	 * Obtain PropertiesManager.
	 * @return instance of PropertiesManager.
	 */
	public PropertiesManager getPropertiesManager() {
		return this.propertiesManager;
	}

}
