package gui;

import java.awt.BorderLayout;
import java.io.File;
import javax.swing.JScrollPane;
import neutrino.text.components.plain.*;
import neutrino.text.*;

/**
 * Builds content of main window.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
abstract class ContentBuilder extends Application {
	
	private TextEditor textEditor = null;
	private JScrollPane scrollPane = null;
	
	public ContentBuilder() {
		super();
		PlainTextArea textComponent = new PlainTextArea();
		textComponent.setUndoable(true);
		textEditor = new TextEditor(textComponent);
		scrollPane = new JScrollPane();
		scrollPane.getViewport().add(textEditor.getTextComponent());
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(scrollPane, BorderLayout.CENTER);
		textEditor.addFileChangeListener(editorListener);
	}
	
	public TextEditor getTextEditor() {
		return this.textEditor;
	}

	private FileChangeListener editorListener = new FileChangeListener() {

		public void fileChanged(FileChangeEvent event) {
			switch (event.getType()) {
			case CLEARING :
            case REMOVING:
				setTitle(PROGRAM_NAME);
				break;
			case OPENING :
			case SAVING :
			case RESTORING :
            case RENAMING :
            case MOVING:
				File file = event.getSource().getFile();
				if (file != null) {
					getTextEditor().setCurrentDirectory(file.getParentFile());
					setTitle(TITLE_HEAD + event.getSource().getFile().getAbsolutePath());
				}
				break;
			}
		}
		
	};
	
}
