package gui;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.*;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;

import com.inet.jortho.SpellChecker;
import commands.CommandType;
import neutrino.dialogs.LookAndFeelChooser;
import neutrino.text.ITextComponent;
import neutrino.text.ReadModeEvent;
import neutrino.text.ReadModeListener;

/**
 * Build menus.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
abstract class MenuBarBuilder extends ContentBuilder {

	private JMenuBar menuBar = null;
	private ClassLoader loader = MenuBarBuilder.class.getClassLoader();
	
	protected ImageIcon iconNew = new ImageIcon(loader.getResource("icons/new.gif"));
	protected ImageIcon iconOpen = new ImageIcon(loader.getResource("icons/open.gif"));
	protected ImageIcon iconReload = new ImageIcon(loader.getResource("icons/reload.gif"));
	protected ImageIcon iconRestore = new ImageIcon(loader.getResource("icons/restore.gif"));
	protected ImageIcon iconSave = new ImageIcon(loader.getResource("icons/save.gif"));
	protected ImageIcon iconRevert = new ImageIcon(loader.getResource("icons/revert.gif"));
	protected ImageIcon iconPrint = new ImageIcon(loader.getResource("icons/print.gif"));
	protected ImageIcon iconExit = new ImageIcon(loader.getResource("icons/exit.gif"));
	protected ImageIcon iconUndo = new ImageIcon(loader.getResource("icons/undo.gif"));
	protected ImageIcon iconRedo = new ImageIcon(loader.getResource("icons/redo.gif"));
	protected ImageIcon iconCut = new ImageIcon(loader.getResource("icons/cut.gif"));
	protected ImageIcon iconCopy = new ImageIcon(loader.getResource("icons/copy.gif"));
	protected ImageIcon iconPaste = new ImageIcon(loader.getResource("icons/paste.gif"));
    protected ImageIcon iconClear = new ImageIcon(loader.getResource("icons/clear.gif"));
    protected ImageIcon iconGoTo = new ImageIcon(loader.getResource("icons/goTo.gif"));
	protected ImageIcon iconFind = new ImageIcon(loader.getResource("icons/find.gif"));
	protected ImageIcon iconReplace = new ImageIcon(loader.getResource("icons/replace.gif"));
    protected ImageIcon iconSpelling = new ImageIcon(loader.getResource("icons/spelling.gif"));
    protected ImageIcon iconLanguages = new ImageIcon(loader.getResource("icons/languages.gif"));
	protected ImageIcon iconSelectAll = new ImageIcon(loader.getResource("icons/selectAll.gif"));
    protected ImageIcon iconDeselect = new ImageIcon(loader.getResource("icons/deselect.gif"));
	protected ImageIcon iconForeground = new ImageIcon(loader.getResource("icons/foreground.gif"));
	protected ImageIcon iconBackground = new ImageIcon(loader.getResource("icons/background.gif"));
	protected ImageIcon iconFont = new ImageIcon(loader.getResource("icons/font.gif"));
	protected ImageIcon iconEncoding = new ImageIcon(loader.getResource("icons/encoding.gif"));
	protected ImageIcon iconAdvanced = new ImageIcon(loader.getResource("icons/advanced.gif"));
	protected ImageIcon iconUpperCase = new ImageIcon(loader.getResource("icons/upperCase.gif"));
	protected ImageIcon iconLowerCase = new ImageIcon(loader.getResource("icons/lowerCase.gif"));
	protected ImageIcon iconDeleteHorizontalWhiteSpace = new ImageIcon(loader.getResource("icons/deleteHorizontalWhiteSpace.gif"));	
	protected ImageIcon iconShiftLeft = new ImageIcon(loader.getResource("icons/shiftLeft.gif"));
	protected ImageIcon iconShiftRight = new ImageIcon(loader.getResource("icons/shiftRight.gif"));
	protected ImageIcon iconComplexOperation = new ImageIcon(loader.getResource("icons/complexOperation.gif"));
	protected ImageIcon iconHelp = new ImageIcon(loader.getResource("icons/help.gif"));
	protected ImageIcon iconAbout = new ImageIcon(loader.getResource("icons/about.gif"));	
	
	protected JMenu mFile = new JMenu("File");
	protected JMenuItem miNew = new JMenuItem("New", iconNew);
	protected JMenuItem miOpen = new JMenuItem("Open...", iconOpen);
	protected JMenuItem miRestore = new JMenuItem("Restore...", iconRestore);
	protected JMenuItem miReload = new JMenuItem("Reload", iconReload);
	protected JMenuItem miSave = new JMenuItem("Save", iconSave);
	protected JMenuItem miSaveAs = new JMenuItem("Save as...");
	protected JMenuItem miPrint = new JMenuItem("Print...", iconPrint);
    protected JMenuItem miCopyFile = new JMenuItem("Copy...", iconCopy);
    protected JMenuItem miMove = new JMenuItem("Move...");
    protected JMenuItem miRemove = new JMenuItem("Remove", iconClear);
    protected JMenuItem miRename = new JMenuItem("Rename...");
    protected JCheckBoxMenuItem miExecute = new JCheckBoxMenuItem("Execute");
    protected JCheckBoxMenuItem miReadOnly = new JCheckBoxMenuItem("Read Only");
    protected JCheckBoxMenuItem miWriteOnly = new JCheckBoxMenuItem("Write Only");
    protected JCheckBoxMenuItem miHidden = new JCheckBoxMenuItem("Hidden");
	protected JMenuItem miExit = new JMenuItem("Exit", iconExit);
	protected JMenu mEdit = new JMenu("Edit");
	protected JMenuItem miUndo = new JMenuItem("Undo", iconUndo);
	protected JMenuItem miRedo = new JMenuItem("Redo", iconRedo);
    protected JMenuItem miRevert = new JMenuItem("Revert", iconRevert);
	protected JMenuItem miCut = new JMenuItem("Cut", iconCut);
	protected JMenuItem miCopy = new JMenuItem("Copy", iconCopy);
	protected JMenuItem miPaste = new JMenuItem("Paste", iconPaste);
    protected JMenuItem miClear = new JMenuItem("Clear", iconClear);
    protected JCheckBoxMenuItem miReadOnlyMode = new JCheckBoxMenuItem("Read Only Mode");
	protected JMenuItem miGoTo = new JMenuItem("Go to...", iconGoTo);
	protected JMenuItem miFind = new JMenuItem("Find...", iconFind);
	protected JMenuItem miReplace = new JMenuItem("Replace...", iconReplace);
    protected JMenuItem miCheckSpelling = new JMenuItem("Spelling...", iconSpelling);
    protected JMenu mLanguages;
	protected JMenuItem miSelectAll = new JMenuItem("Select all", iconSelectAll);
    protected JMenuItem miDeselect = new JMenuItem("Deselect", iconDeselect);
	protected JMenu mCommand = new JMenu("Command");
    protected JMenu mChangeCaseLetters = new JMenu("Change Case Letters");
	protected JMenuItem miMakeUpperCase = new JMenuItem("Make Upper Case", iconUpperCase);
	protected JMenuItem miMakeLowerCase = new JMenuItem("Make Lower Case", iconLowerCase);
    protected JMenuItem miMakeTitleCase = new JMenuItem("Make Title Case");
    protected JMenuItem miInvertCaseLetters = new JMenuItem("Invert Case Letters");
    protected JMenuItem miCapitalizeWords = new JMenuItem("Capitalize Words");
    protected JMenuItem miInvertCapitalization = new JMenuItem("Invert Capitalization");
    protected JMenu mManageWhiteSpace = new JMenu("Manage White Space");
	protected JMenuItem miTabifySelectedLines = new JMenuItem("Tabify Selected Lines");
	protected JMenuItem miUntabifySelectedLines = new JMenuItem("Untabify Selected Lines");
    protected JMenuItem miTrimSelectedLines = new JMenuItem("Trim Selected Lines");
    protected JMenuItem miRemoveEmptyLines = new JMenuItem("Remove Empty Lines");
    protected JMenuItem miDeleteHorizontalWhiteSpace = new JMenuItem("Delete Horizontal White Space",
            iconDeleteHorizontalWhiteSpace);
    protected JMenuItem miRemoveTrailingWhitespaces = new JMenuItem("Remove Trailing White Space");
    protected JMenu mSortSelectedLines = new JMenu("Sort Selected Lines");
    protected JMenuItem miJoinSelectedLines = new JMenuItem("Join Selected Lines");
    protected JMenuItem miDuplicateSelectedLines = new JMenuItem("Duplicate Selected Lines");
    protected JMenuItem miSplitIntoLines = new JMenuItem("Split Into Lines");
    protected JMenuItem miSortLinesAscendant = new JMenuItem("Sort Lines Ascendant");
    protected JMenuItem miSortLinesDescendant = new JMenuItem("Sort Lines Descendant");
    protected JMenu mMoveText = new JMenu("Move Text");
	protected JMenuItem miShiftInRight = new JMenuItem("Increase Line Indent", iconShiftRight);
	protected JMenuItem miShiftInLeft = new JMenuItem("Decrease Line Indent", iconShiftLeft);
    protected JMenuItem miMoveLinesUp = new JMenuItem("Move Lines Up");
    protected JMenuItem miMoveLinesDown = new JMenuItem("Move Lines Down");
    protected JMenu mAlignSelectedText = new JMenu("Align Selected Text");
    protected JMenuItem miAlignTextLeft = new JMenuItem("Align Text Left");
    protected JMenuItem miAlignTextRight = new JMenuItem("Align Text Right");
    protected JMenuItem miCenterText = new JMenuItem("Center Text");
    protected JMenuItem miJustifyText = new JMenuItem("Justify Text");
    protected JMenuItem miMakeLatinParagraph = new JMenuItem("Make Latin Paragraph");
    protected JMenuItem miMakeCyrillicParagraph = new JMenuItem("Make Cyrillic Paragraph");
	protected JMenuItem miPerformComplexOperation = new JMenuItem("Perform Complex Operation...",
			iconComplexOperation);
	protected JMenu mOptions = new JMenu("Options");
	protected JMenuItem miForeground = new JMenuItem("Foreground...", iconForeground);
	protected JMenuItem miBackground = new JMenuItem("Background...", iconBackground);
	protected JMenuItem miFont = new JMenuItem("Font...", iconFont);
	protected JMenuItem miEncoding = new JMenuItem("Encoding...", iconEncoding);
    protected JMenuItem miSpelling = new JMenuItem("Spelling...", iconSpelling);
    protected JMenuItem miText = new JMenuItem("Text...");
    protected JMenuItem miWindow = new JMenuItem("Window...");
    protected JMenu mLookAndFeel;
	protected JMenuItem miAdvanced = new JMenuItem("Advanced...", iconAdvanced);
	protected JMenu mHelp = new JMenu("Help");
	protected JMenuItem miHelp = new JMenuItem("Help", iconHelp);
    protected JMenuItem miGame = new JMenuItem("Game");
    protected JMenuItem miLicense = new JMenuItem("License");
	protected JMenuItem miAbout = new JMenuItem("About", iconAbout);
	
	public MenuBarBuilder() {
		super();
		menuBar = new JMenuBar();
		setJMenuBar(menuBar);
        // initialize Languages menu
        mLanguages = SpellChecker.createLanguagesMenu();
        mLanguages.setIcon(iconLanguages);
        // initialize Look and feel menu
        mLookAndFeel = LookAndFeelChooser.createLookAndFeelMenu(this);
        // add read only mode listener
        JTextComponent textComponent = getTextEditor().getTextComponent();
        if (textComponent instanceof ITextComponent) {
            ((ITextComponent) textComponent).addReadModeListener(readModeListener);
        }
	}
	
	private void buildMenus() {
		menuBar.add(mFile);
		menuBar.add(mEdit);
        menuBar.add(mCommand);
		menuBar.add(mOptions);
		menuBar.add(mHelp);
		
		mFile.add(miNew);
		mFile.add(miOpen);
		mFile.add(miReload);
		mFile.add(miRestore);
		mFile.addSeparator();
		mFile.add(miSave);
		mFile.add(miSaveAs);
		mFile.add(miPrint);
		mFile.addSeparator();
        mFile.add(miCopyFile);
        mFile.add(miMove);
        mFile.add(miRemove);
        mFile.add(miRename);
        mFile.addSeparator();
        mFile.add(miExecute);
        mFile.add(miReadOnly);
        mFile.add(miWriteOnly);
        mFile.add(miHidden);
        mFile.addSeparator();
		mFile.add(miExit);
		
		mEdit.add(miUndo);
		mEdit.add(miRedo);
        mEdit.add(miRevert);
		mEdit.addSeparator();
		mEdit.add(miCut);
		mEdit.add(miCopy);
		mEdit.add(miPaste);
        mEdit.add(miClear);
		mEdit.addSeparator();
        mEdit.add(miReadOnlyMode);
		mEdit.add(miGoTo);
		mEdit.add(miFind);
		mEdit.add(miReplace);
        mEdit.add(miCheckSpelling);
        mEdit.add(mLanguages);
		mEdit.addSeparator();
		mEdit.add(miSelectAll);
        mEdit.add(miDeselect);

        mCommand.add(mChangeCaseLetters);
        mCommand.add(mManageWhiteSpace);
        mCommand.add(mSortSelectedLines);
        mCommand.add(mMoveText);
        mCommand.add(mAlignSelectedText);

        mChangeCaseLetters.add(miMakeUpperCase);
        mChangeCaseLetters.add(miMakeLowerCase);
        mChangeCaseLetters.add(miMakeTitleCase);
        mChangeCaseLetters.add(miInvertCaseLetters);
        mChangeCaseLetters.add(miCapitalizeWords);
        mChangeCaseLetters.add(miInvertCapitalization);

        mManageWhiteSpace.add(miTabifySelectedLines);
        mManageWhiteSpace.add(miUntabifySelectedLines);
        mManageWhiteSpace.add(miTrimSelectedLines);
        mManageWhiteSpace.add(miRemoveEmptyLines);
        mManageWhiteSpace.add(miDeleteHorizontalWhiteSpace);
        mManageWhiteSpace.add(miRemoveTrailingWhitespaces);

        mSortSelectedLines.add(miJoinSelectedLines);
        mSortSelectedLines.add(miDuplicateSelectedLines);
        mSortSelectedLines.add(miSplitIntoLines);
        mSortSelectedLines.add(miSortLinesAscendant);
        mSortSelectedLines.add(miSortLinesDescendant);

        mMoveText.add(miShiftInRight);
        mMoveText.add(miShiftInLeft);
        mMoveText.add(miMoveLinesUp);
        mMoveText.add(miMoveLinesDown);

        mAlignSelectedText.add(miAlignTextLeft);
        mAlignSelectedText.add(miAlignTextRight);
        mAlignSelectedText.add(miCenterText);
        mAlignSelectedText.add(miJustifyText);
        mAlignSelectedText.add(miMakeLatinParagraph);
        mAlignSelectedText.add(miMakeCyrillicParagraph);
		mCommand.addSeparator();
		mCommand.add(miPerformComplexOperation);
		
		mOptions.add(miForeground);
		mOptions.add(miBackground);
		mOptions.add(miFont);
		mOptions.add(miEncoding);
        mOptions.add(miSpelling);
        mOptions.add(miText);
        mOptions.add(miWindow);
        mOptions.add(mLookAndFeel);
		mOptions.add(miAdvanced);
		
		mHelp.add(miHelp);
        mHelp.add(miGame);
        mHelp.add(miLicense);
		mHelp.add(miAbout);
	}
	
	private void buildAccelerators() {
		miNew.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, 0));
		miOpen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F3, 0));
		miSave.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
		miReload.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0));
		miPrint.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, InputEvent.CTRL_DOWN_MASK));
		miExit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, InputEvent.ALT_DOWN_MASK));
		miUndo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z, InputEvent.CTRL_DOWN_MASK));
		miRedo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Y, InputEvent.CTRL_DOWN_MASK));
		miCut.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, InputEvent.CTRL_DOWN_MASK));
		miCopy.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK));
		miPaste.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, InputEvent.CTRL_DOWN_MASK));
        miClear.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0));
		miGoTo.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_G, InputEvent.CTRL_DOWN_MASK));
		miFind.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, InputEvent.CTRL_DOWN_MASK));
		miReplace.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, InputEvent.CTRL_DOWN_MASK));
        miCheckSpelling.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F7, 0));
		miSelectAll.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, InputEvent.CTRL_DOWN_MASK));
        miDeselect.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0));
		miMakeUpperCase.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_U, InputEvent.CTRL_DOWN_MASK));
		miMakeLowerCase.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L, InputEvent.CTRL_DOWN_MASK));
		miDeleteHorizontalWhiteSpace.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_W, InputEvent.CTRL_DOWN_MASK));
		miRemoveTrailingWhitespaces.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, InputEvent.CTRL_DOWN_MASK));
		miShiftInLeft.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, InputEvent.ALT_DOWN_MASK));
		miShiftInRight.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, InputEvent.ALT_DOWN_MASK));
        miMoveLinesUp.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_UP, InputEvent.CTRL_DOWN_MASK));
        miMoveLinesDown.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, InputEvent.CTRL_DOWN_MASK));
		miFont.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, InputEvent.CTRL_DOWN_MASK));
		miEncoding.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, InputEvent.CTRL_DOWN_MASK));
		miAdvanced.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D, InputEvent.CTRL_DOWN_MASK));
		miHelp.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
	}
	
	private void buildMnemonics() {
		mFile.setMnemonic(KeyEvent.VK_F);
		mEdit.setMnemonic(KeyEvent.VK_E);
        mCommand.setMnemonic(KeyEvent.VK_C);
		mHelp.setMnemonic(KeyEvent.VK_H);
		mOptions.setMnemonic(KeyEvent.VK_O);
		
		miNew.setMnemonic(KeyEvent.VK_N);
		miOpen.setMnemonic(KeyEvent.VK_O);
		miRestore.setMnemonic(KeyEvent.VK_E);
		miSave.setMnemonic(KeyEvent.VK_S);
		miSaveAs.setMnemonic(KeyEvent.VK_A);
		miReload.setMnemonic(KeyEvent.VK_L);
		miPrint.setMnemonic(KeyEvent.VK_P);
        miCopyFile.setMnemonic(KeyEvent.VK_C);
        miMove.setMnemonic(KeyEvent.VK_V);
        miRemove.setMnemonic(KeyEvent.VK_R);
        miRename.setMnemonic(KeyEvent.VK_M);
        miExecute.setMnemonic(KeyEvent.VK_U);
        miReadOnly.setMnemonic(KeyEvent.VK_D);
        miWriteOnly.setMnemonic(KeyEvent.VK_W);
        miHidden.setMnemonic(KeyEvent.VK_H);
		miExit.setMnemonic(KeyEvent.VK_X);
		
		miUndo.setMnemonic(KeyEvent.VK_U);
		miRedo.setMnemonic(KeyEvent.VK_R);
        miRevert.setMnemonic(KeyEvent.VK_E);
		miCut.setMnemonic(KeyEvent.VK_C);
		miCopy.setMnemonic(KeyEvent.VK_O);
		miPaste.setMnemonic(KeyEvent.VK_T);
        miClear.setMnemonic(KeyEvent.VK_L);
        miReadOnlyMode.setMnemonic(KeyEvent.VK_A);
		miGoTo.setMnemonic(KeyEvent.VK_G);
		miFind.setMnemonic(KeyEvent.VK_F);
		miReplace.setMnemonic(KeyEvent.VK_R);
        miCheckSpelling.setMnemonic(KeyEvent.VK_P);
        mLanguages.setMnemonic(KeyEvent.VK_N);
		miSelectAll.setMnemonic(KeyEvent.VK_S);
        miDeselect.setMnemonic(KeyEvent.VK_D);

        mChangeCaseLetters.setMnemonic(KeyEvent.VK_L);
        mManageWhiteSpace.setMnemonic(KeyEvent.VK_S);
        mSortSelectedLines.setMnemonic(KeyEvent.VK_O);
        mMoveText.setMnemonic(KeyEvent.VK_M);
        mAlignSelectedText.setMnemonic(KeyEvent.VK_A);
        miPerformComplexOperation.setMnemonic(KeyEvent.VK_F);

		miMakeUpperCase.setMnemonic(KeyEvent.VK_P);
		miMakeLowerCase.setMnemonic(KeyEvent.VK_L);
        miMakeTitleCase.setMnemonic(KeyEvent.VK_K);
        miInvertCaseLetters.setMnemonic(KeyEvent.VK_N);
        miCapitalizeWords.setMnemonic(KeyEvent.VK_C);
        miInvertCapitalization.setMnemonic(KeyEvent.VK_Z);

		miTabifySelectedLines.setMnemonic(KeyEvent.VK_T);
		miUntabifySelectedLines.setMnemonic(KeyEvent.VK_B);
        miTrimSelectedLines.setMnemonic(KeyEvent.VK_M);
        miRemoveEmptyLines.setMnemonic(KeyEvent.VK_O);
        miDeleteHorizontalWhiteSpace.setMnemonic(KeyEvent.VK_W);
        miRemoveTrailingWhitespaces.setMnemonic(KeyEvent.VK_G);

        miJoinSelectedLines.setMnemonic(KeyEvent.VK_J);
        miSplitIntoLines.setMnemonic(KeyEvent.VK_S);
        miDuplicateSelectedLines.setMnemonic(KeyEvent.VK_A);
        miSortLinesAscendant.setMnemonic(KeyEvent.VK_R);
        miSortLinesDescendant.setMnemonic(KeyEvent.VK_D);

		miShiftInRight.setMnemonic(KeyEvent.VK_I);
		miShiftInLeft.setMnemonic(KeyEvent.VK_E);
        miMoveLinesUp.setMnemonic(KeyEvent.VK_U);
        miMoveLinesDown.setMnemonic(KeyEvent.VK_V);

        miAlignTextLeft.setMnemonic(KeyEvent.VK_F);
        miAlignTextRight.setMnemonic(KeyEvent.VK_H);
        miCenterText.setMnemonic(KeyEvent.VK_X);
        miJustifyText.setMnemonic(KeyEvent.VK_J);
        miMakeLatinParagraph.setMnemonic(KeyEvent.VK_K);
        miMakeCyrillicParagraph.setMnemonic(KeyEvent.VK_Y);

		miForeground.setMnemonic(KeyEvent.VK_O);
		miBackground.setMnemonic(KeyEvent.VK_B);
		miFont.setMnemonic(KeyEvent.VK_F);
		miEncoding.setMnemonic(KeyEvent.VK_E);
        miSpelling.setMnemonic(KeyEvent.VK_S);
        miText.setMnemonic(KeyEvent.VK_T);
        miWindow.setMnemonic(KeyEvent.VK_W);
		miAdvanced.setMnemonic(KeyEvent.VK_A);
		
		miHelp.setMnemonic(KeyEvent.VK_H);
        miGame.setMnemonic(KeyEvent.VK_G);
        miLicense.setMnemonic(KeyEvent.VK_L);
		miAbout.setMnemonic(KeyEvent.VK_A);
	}
	
	protected void buildActions() {
		mFile.addMenuListener(mlFile);
		mEdit.addMenuListener(mlEdit);
		mCommand.addMenuListener(mlCommand);
	}

	protected void buildMenuBar() {
		buildMenus();
		buildAccelerators();
		buildMnemonics();
	}
	
	private MenuListener mlFile = new MenuListener() {

		public void menuCanceled(MenuEvent e) { }

		public void menuDeselected(MenuEvent e) { }

		public void menuSelected(MenuEvent e) {
			miNew.setEnabled(getCommandGateway().canPerformCommand(CommandType.NEW));
			miSave.setEnabled(getCommandGateway().canPerformCommand(CommandType.SAVE));
			miSaveAs.setEnabled(getCommandGateway().canPerformCommand(CommandType.SAVE_AS));
			miReload.setEnabled(getCommandGateway().canPerformCommand(CommandType.RELOAD));
			miPrint.setEnabled(getCommandGateway().canPerformCommand(CommandType.PRINT));
			miRestore.setEnabled(getCommandGateway().canPerformCommand(CommandType.RESTORE));
            miMove.setEnabled(getCommandGateway().canPerformCommand(CommandType.MOVE));
            miCopyFile.setEnabled(getCommandGateway().canPerformCommand(CommandType.COPY_FILE));
            miRemove.setEnabled(getCommandGateway().canPerformCommand(CommandType.REMOVE));
            miRename.setEnabled(getCommandGateway().canPerformCommand(CommandType.RENAME));
            miExecute.setEnabled(getCommandGateway().canPerformCommand(CommandType.EXECUTE));
            miReadOnly.setEnabled(getCommandGateway().canPerformCommand(CommandType.READ_ONLY));
            miWriteOnly.setEnabled(getCommandGateway().canPerformCommand(CommandType.WRITE_ONLY));
            miHidden.setEnabled(getCommandGateway().canPerformCommand(CommandType.HIDDEN));

            miExecute.setSelected(getTextEditor().isExecute());
            miReadOnly.setSelected(getTextEditor().isReadOnly());
            miWriteOnly.setSelected(getTextEditor().isWriteOnly());
            miHidden.setSelected(getTextEditor().isHidden());
		}
		
	};
	
	private MenuListener mlEdit = new MenuListener() {

		public void menuCanceled(MenuEvent e) {	}

		public void menuDeselected(MenuEvent e) { }

		public void menuSelected(MenuEvent e) {
			miUndo.setEnabled(getCommandGateway().canPerformCommand(CommandType.UNDO));
			miRedo.setEnabled(getCommandGateway().canPerformCommand(CommandType.REDO));
            miRevert.setEnabled(getCommandGateway().canPerformCommand(CommandType.REVERT));
			miCut.setEnabled(getCommandGateway().canPerformCommand(CommandType.CUT));
			miCopy.setEnabled(getCommandGateway().canPerformCommand(CommandType.COPY));
			miPaste.setEnabled(getCommandGateway().canPerformCommand(CommandType.PASTE));
            miClear.setEnabled(getCommandGateway().canPerformCommand(CommandType.CLEAR));
            miReadOnlyMode.setEnabled(getCommandGateway().canPerformCommand(CommandType.READ_ONLY_MODE));
			miGoTo.setEnabled(getCommandGateway().canPerformCommand(CommandType.GO_TO));
			miFind.setEnabled(getCommandGateway().canPerformCommand(CommandType.FIND));
			miReplace.setEnabled(getCommandGateway().canPerformCommand(CommandType.REPLACE));
            miCheckSpelling.setEnabled(getCommandGateway().canPerformCommand(CommandType.CHECK_SPELLING));
			miSelectAll.setEnabled(getCommandGateway().canPerformCommand(CommandType.SELECT_ALL));
            miDeselect.setEnabled(getCommandGateway().canPerformCommand(CommandType.DESELECT));
            JTextComponent textComponent = getTextEditor().getTextComponent();
            if (textComponent instanceof ITextComponent) {
                miReadOnlyMode.setSelected(((ITextComponent) textComponent).isReadOnlyMode());
            } else {
                miReadOnlyMode.setSelected(false);
            }
		}
		
	};
	
	private MenuListener mlCommand = new MenuListener() {

		public void menuCanceled(MenuEvent e) {	}

		public void menuDeselected(MenuEvent e) { }

		public void menuSelected(MenuEvent e) { 
			miMakeUpperCase.setEnabled(getCommandGateway().canPerformCommand(CommandType.MAKE_UPPER_CASE));
			miMakeLowerCase.setEnabled(getCommandGateway().canPerformCommand(CommandType.MAKE_LOWER_CASE));
            miMakeTitleCase.setEnabled(getCommandGateway().canPerformCommand(CommandType.MAKE_TITLE_CASE));
            miInvertCaseLetters.setEnabled(getCommandGateway().canPerformCommand(CommandType.INVERT_CASE_LETTERS));
            miCapitalizeWords.setEnabled(getCommandGateway().canPerformCommand(CommandType.CAPITALIZE_WORDS));
            miInvertCapitalization.setEnabled(getCommandGateway().canPerformCommand(CommandType.INVERT_CAPITALIZATION));
			miTabifySelectedLines.setEnabled(getCommandGateway().canPerformCommand(CommandType.TABIFY_SELECTED_LINES));
			miUntabifySelectedLines.setEnabled(getCommandGateway().canPerformCommand(CommandType.UNTABIFY_SELECTED_LINES));
            miTrimSelectedLines.setEnabled(getCommandGateway().canPerformCommand(CommandType.TRIM_SELECTED_LINES));
            miDeleteHorizontalWhiteSpace.setEnabled(getCommandGateway().canPerformCommand(CommandType.DELETE_HORIZONTAL_WHITE_SPACE));
            miRemoveTrailingWhitespaces.setEnabled(getCommandGateway().canPerformCommand(CommandType.REMOVE_TRAILING_WHITESPACES));
            miJoinSelectedLines.setEnabled(getCommandGateway().canPerformCommand(CommandType.JOIN_SELECTED_LINES));
            miDuplicateSelectedLines.setEnabled(getCommandGateway().canPerformCommand(CommandType.DUPLICATE_SELECTED_LINES));
            miRemoveEmptyLines.setEnabled(getCommandGateway().canPerformCommand(CommandType.REMOVE_EMPTY_LIENS));
            miSplitIntoLines.setEnabled(getCommandGateway().canPerformCommand(CommandType.SPLIT_INTO_LINES));
            miSortLinesAscendant.setEnabled(getCommandGateway().canPerformCommand(CommandType.SORT_LINES_ASCENDANT));
            miSortLinesDescendant.setEnabled(getCommandGateway().canPerformCommand(CommandType.SORT_LINES_DESCENDANT));
            miMoveLinesUp.setEnabled(getCommandGateway().canPerformCommand(CommandType.MOVE_LINES_UP));
            miMoveLinesDown.setEnabled(getCommandGateway().canPerformCommand(CommandType.MOVE_LINES_DOWN));
            miShiftInLeft.setEnabled(getCommandGateway().canPerformCommand(CommandType.DECREASE_LINE_INDENT));
            miShiftInRight.setEnabled(getCommandGateway().canPerformCommand(CommandType.INCREASE_LINE_INDENT));
            miAlignTextLeft.setEnabled(getCommandGateway().canPerformCommand(CommandType.ALIGN_TEXT_LEFT));
            miAlignTextRight.setEnabled(getCommandGateway().canPerformCommand(CommandType.ALIGN_TEXT_RIGHT));
            miCenterText.setEnabled(getCommandGateway().canPerformCommand(CommandType.CENTER_TEXT));
            miJustifyText.setEnabled(getCommandGateway().canPerformCommand(CommandType.JUSTIFY_TEXT));
            miMakeLatinParagraph.setEnabled(getCommandGateway().canPerformCommand(CommandType.MAKE_LATIN_PARAGRAPH));
            miMakeCyrillicParagraph.setEnabled(getCommandGateway().canPerformCommand(CommandType.MAKE_CYRILLIC_PARAGRAPH));
		}
		
	};

    private ReadModeListener readModeListener = new ReadModeListener() {

        @Override
        public void readModeChanged(ReadModeEvent event) {
            JTextComponent textComponent = getTextEditor().getTextComponent();
            if (textComponent instanceof ITextComponent) {
                mCommand.setEnabled(!((ITextComponent) textComponent).isReadOnlyMode());
            }
        }

    };
	
}
