package gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.Timer;

import commands.CommandType;

/**
 * Builds toolbar for main window
 * @author Oleh Radvanskyj
 * @version 1.0
 */
abstract class ToolBarBuilder extends PopupMenuBuilder {

	private JToolBar toolBar = new JToolBar();
	
	protected JButton bNew = new JButton(iconNew);
	protected JButton bOpen = new JButton(iconOpen);
	protected JButton bReload = new JButton(iconReload);
	protected JButton bSave = new JButton(iconSave);
	protected JButton bPrint = new JButton(iconPrint);
	protected JButton bUndo = new JButton(iconUndo);
	protected JButton bRedo = new JButton(iconRedo);
    protected JButton bRevert = new JButton(iconRevert);
	protected JButton bCut = new JButton(iconCut);
	protected JButton bCopy = new JButton(iconCopy);
	protected JButton bPaste = new JButton(iconPaste);
    protected JButton bClear = new JButton(iconClear);
    protected JButton bGoTo = new JButton(iconGoTo);
	protected JButton bFind = new JButton(iconFind);
	protected JButton bReplace = new JButton(iconReplace);
    protected JButton bCheckSpelling = new JButton(iconSpelling);
	protected JButton bMakeUpperCase = new JButton(iconUpperCase);
	protected JButton bMakeLowerCase = new JButton(iconLowerCase);
	protected JButton bDeleteHorizontalWhiteSpace = new JButton(iconDeleteHorizontalWhiteSpace);
	protected JButton bIncreaseLineIndent = new JButton(iconShiftRight); 
	protected JButton bDecreaseLineIndent = new JButton(iconShiftLeft); 
	protected JButton bPerformComplexOperation = new JButton(iconComplexOperation); 
	protected JButton bHelp = new JButton(iconHelp);
	protected JButton bExit = new JButton(iconExit);
	
	public ToolBarBuilder() {
		super();
		getContentPane().add(toolBar, BorderLayout.NORTH);
	}
	
	protected void buildToolBar() {
		toolBar.add(bNew);
		toolBar.add(bOpen);
		toolBar.add(bReload);
		toolBar.add(bSave);
		toolBar.add(bPrint);
		toolBar.addSeparator();
		toolBar.add(bUndo);
		toolBar.add(bRedo);
        toolBar.add(bRevert);
		toolBar.addSeparator();
		toolBar.add(bCut);
		toolBar.add(bCopy);
		toolBar.add(bPaste);
        toolBar.add(bClear);
		toolBar.addSeparator();
        toolBar.add(bGoTo);
		toolBar.add(bFind);
		toolBar.add(bReplace);
        toolBar.add(bCheckSpelling);
		toolBar.addSeparator();
		toolBar.add(bMakeUpperCase);
		toolBar.add(bMakeLowerCase);
		toolBar.add(bDeleteHorizontalWhiteSpace);
		toolBar.add(bIncreaseLineIndent);
		toolBar.add(bDecreaseLineIndent);
		toolBar.add(bPerformComplexOperation);
		toolBar.addSeparator();
		toolBar.add(bHelp);		
		toolBar.add(bExit);		
		
		buildToolTips();
	}
	
	private void buildToolTips() {
		bNew.setToolTipText("New");
		bOpen.setToolTipText("Open");
		bReload.setToolTipText("Reload");
		bSave.setToolTipText("Save");
		bRevert.setToolTipText("Revert");
		bPrint.setToolTipText("Print");
		bUndo.setToolTipText("Undo");
		bRedo.setToolTipText("Redo");
		bCut.setToolTipText("Cut");
		bCopy.setToolTipText("Copy");
		bPaste.setToolTipText("Paste");
        bClear.setToolTipText("Clear");
        bGoTo.setToolTipText("Go To");
		bFind.setToolTipText("Find");
		bReplace.setToolTipText("Replace");
        bCheckSpelling.setToolTipText("Check Spelling");
		bMakeUpperCase.setToolTipText("Make Uppercase");
		bMakeLowerCase.setToolTipText("Make Lowercase");
		bDeleteHorizontalWhiteSpace.setToolTipText("Delete Horizontal White Space");
		bIncreaseLineIndent.setToolTipText("Increase Line Indent");
		bDecreaseLineIndent.setToolTipText("Decrease Line Indent");
		bPerformComplexOperation.setToolTipText("Perform Complex Operation");
		bHelp.setToolTipText("Help");
		bExit.setToolTipText("Exit");
	}
	
	private void updateButtonsState() {
		bNew.setEnabled(getCommandGateway().canPerformCommand(CommandType.NEW));
		bSave.setEnabled(getCommandGateway().canPerformCommand(CommandType.SAVE));
		bReload.setEnabled(getCommandGateway().canPerformCommand(CommandType.RELOAD));
		bRevert.setEnabled(getCommandGateway().canPerformCommand(CommandType.REVERT));
		bPrint.setEnabled(getCommandGateway().canPerformCommand(CommandType.PRINT));
		bUndo.setEnabled(getCommandGateway().canPerformCommand(CommandType.UNDO));
		bRedo.setEnabled(getCommandGateway().canPerformCommand(CommandType.REDO));
		bCut.setEnabled(getCommandGateway().canPerformCommand(CommandType.CUT));
		bCopy.setEnabled(getCommandGateway().canPerformCommand(CommandType.COPY));
		bPaste.setEnabled(getCommandGateway().canPerformCommand(CommandType.PASTE));
        bClear.setEnabled(getCommandGateway().canPerformCommand(CommandType.CLEAR));
        bGoTo.setEnabled(getCommandGateway().canPerformCommand(CommandType.GO_TO));
		bFind.setEnabled(getCommandGateway().canPerformCommand(CommandType.FIND));
		bReplace.setEnabled(getCommandGateway().canPerformCommand(CommandType.REPLACE));
        bCheckSpelling.setEnabled(getCommandGateway().canPerformCommand(CommandType.CHECK_SPELLING));
		bMakeUpperCase.setEnabled(getCommandGateway().canPerformCommand(CommandType.MAKE_UPPER_CASE));
		bMakeLowerCase.setEnabled(getCommandGateway().canPerformCommand(CommandType.MAKE_LOWER_CASE));
		bDeleteHorizontalWhiteSpace.setEnabled(getCommandGateway().canPerformCommand(CommandType.DELETE_HORIZONTAL_WHITE_SPACE));
		bIncreaseLineIndent.setEnabled(getCommandGateway().canPerformCommand(CommandType.INCREASE_LINE_INDENT));
		bDecreaseLineIndent.setEnabled(getCommandGateway().canPerformCommand(CommandType.DECREASE_LINE_INDENT));
		bPerformComplexOperation.setEnabled(getCommandGateway().canPerformCommand(CommandType.PERFORM_COMPLEX_OPERATION));
	}
	
	private Timer toolBarUpdatingTimer = new Timer(100, new ActionListener() {
		@Override
		public void actionPerformed(ActionEvent e) {
			if (toolBar.isVisible()) 
				try {
					updateButtonsState();
				} catch (Exception e1) {
					// skip iteration
				}	
		}
	});	
	
	protected void buildActions() {
		super.buildActions();
		toolBarUpdatingTimer.start();
	}
	
	public void setToolBarVisible(boolean isVisible) {
		toolBar.setVisible(isVisible);
	}
	
	public boolean isToolBarVisible() {
		return toolBar.isVisible();
	}

}
