package gui.dialog;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class AboutDialog extends JDialog {

	private final String logo = "logo.jpg";
	private JLabel lLogo = new JLabel();
	private JLabel lVersion = new JLabel("Version 1.3");
	private JLabel lLicence = new JLabel("Copyright (C) 2012 - 2016 Oleh Radvanskyj");
    private JLabel lGNU = new JLabel("GNU General Public License (GPLv3)");
    private JLabel lAddress = new JLabel("http://sourceforge.net/projects/extendedtexteditor/");
	private JButton bClose = new JButton("Close");
	
	private AboutDialog(JFrame owner) {
		super(owner);
		setTitle("About");
		bClose.setMnemonic(KeyEvent.VK_C);
		bClose.addActionListener(alClose);
		lLogo.setIcon(new ImageIcon(logo));
		getRootPane().setDefaultButton(bClose);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		setResizable(false);
		setModal(true);
		
		getContentPane().setBackground(new Color(238, 238, 238));
		GridBagLayout layout = new GridBagLayout();
		getContentPane().setLayout(layout);
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		getContentPane().add(lLogo, c);
		c.gridy = 1;
		c.anchor = GridBagConstraints.CENTER;
		getContentPane().add(lVersion, c);
		c.gridy = 2;
		getContentPane().add(lLicence, c);
		c.gridy = 3;
        getContentPane().add(lGNU, c);
        c.gridy = 4;
        getContentPane().add(lAddress, c);
        c.gridy = 5;
		c.insets = new Insets(5, 0, 5, 0);
		getContentPane().add(bClose, c);
		pack();
	}
	
	private ActionListener alClose = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			setVisible(false);
			dispose();
		}
	};
	
	public static void showAboutDialog(JFrame owner) {
		AboutDialog dialog = new AboutDialog(owner);
        Dimension d1 = dialog.getSize(); 
        Dimension d2 = owner.getSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + owner.getX(), y + owner.getY(), d1.width, d1.height);
		dialog.setVisible(true);
	}

}
