package properties;

import java.io.Serializable;

/**
 * Incapsulate settings of program.
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class Settings implements Serializable {

	private boolean isPersistCurrentFile = true;
	private boolean isSaveCaretPosition = false;

	/**
	 * Sets persisting current file option.
	 * @param value - boolean
	 */
	public void setPersistingCurrentFile(boolean value) {
		this.isPersistCurrentFile = value;
	}

	/**
	 * Returns the state of persisting current file option
	 * @return boolean
	 */
	public boolean isPersistCurrentFile() {
		return this.isPersistCurrentFile;
	}
	
	/**
	 * Sets saving of caret position after quitting.
	 * @param value - boolean
	 */
	public void setSavingCaretPosition(boolean value) {
		this.isSaveCaretPosition = value;
	}
	
	/**
	 * Returns true if caret position will been saved after quitting.
	 * @return boolean
	 */	
	public boolean isSaveCaretPosition() {
		return this.isSaveCaretPosition;
	}

}
