<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	
	<!-- architecture -->

    <xsl:template match="architecture">
        <h2 id="architecture">Architecture</h2>
        <xsl:apply-templates select="description" />
        <xsl:apply-templates select="." mode="overview" />
        <xsl:apply-templates select="specification" />
        <xsl:apply-templates select="packages" />
        <xsl:apply-templates select="diagrams" />
        <xsl:apply-templates select="capsules" />
        <xsl:apply-templates select="classes" />
    </xsl:template>

    <xsl:template match="architecture/description">
        <h3>Description</h3>
        <div class="indent"><xsl:apply-templates /></div>
    </xsl:template>

    <!-- table of contents -->

	<xsl:template match="analysis" mode="table_of_contents_architecture">
		<xsl:if test="architecture/pd-package or architecture/cd-package or architecture/crc-package or architecture/specification or architecture/packages or architecture/classes or architecture/capsules or architecture/diagrams">
			<li>
				<a href="#architecture"  onclick="expandAncestors('architecture')">Architecture</a>
				<ul>
                    <xsl:apply-templates select="." mode="table_of_contents_architecture_overview" />
                    <xsl:apply-templates select="architecture" mode="table_of_contents_specification" />
                    <xsl:apply-templates select="architecture" mode="table_of_contents_packages" />
                    <xsl:apply-templates select="architecture" mode="table_of_contents_diagrams" />
                    <xsl:apply-templates select="architecture" mode="table_of_contents_capsules" />
                    <xsl:apply-templates select="architecture" mode="table_of_contents_interfaces" />
                    <xsl:apply-templates select="architecture" mode="table_of_contents_classes" />
				</ul>
			</li>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
