<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>

	<!-- overview -->

    <!-- architecture -->

    <xsl:template match="analysis" mode="table_of_contents_architecture_overview">
        <xsl:if test="architecture/pd-package or architecture/cd-package or architecture/crc-package or architecture/packages or architecture/classes or architecture/capsules">
            <li><a href="#architecture-overview"  onclick="expandAncestors('architecture-overview')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="architecture" mode="overview">
        <xsl:if test="pd-package or cd-package or crc-package or packages or classes or capsules">
            <h3 id="architecture-overview"  onclick="toggleTag('{generate-id(.)}-overview')">Overview</h3>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_package_description" />
                <xsl:apply-templates select="." mode="overview_capsules" />
                <xsl:apply-templates select="." mode="overview_class_description" />
                <xsl:apply-templates select="." mode="overview_class_responsibilities_collaboration" />
            </div>
        </xsl:if>
    </xsl:template>

    <!-- package -->

    <xsl:template match="package" mode="table_of_contents_architecture_package_overview">
        <xsl:if test="pd-package or cd-package or crc-package or packages or classes or capsules">
            <li><a href="#{generate-id(.)}-overview-header" onclick="expandAncestors('{generate-id(.)}-overview-header')">Overview</a></li>
        </xsl:if>
    </xsl:template>

    <xsl:template match="architecture//package" mode="overview">
        <xsl:if test="pd-package or cd-package or crc-package or classes or packages or capsules">
            <h4 id="{generate-id(.)}-overview-header" onclick="toggleTag('{generate-id(.)}-overview')">Overview</h4>
            <div id="{generate-id(.)}-overview" class="indent" style="display:none">
                <xsl:apply-templates select="." mode="overview_package_description" />
                <xsl:apply-templates select="." mode="overview_capsules" />
                <xsl:apply-templates select="." mode="overview_class_description" />
                <xsl:apply-templates select="." mode="overview_class_responsibilities_collaboration" />
            </div>
        </xsl:if>
    </xsl:template>

    <!-- content -->

    <xsl:template match="architecture | package" mode="overview_package_description">
        <xsl:if test="pd-package or packages">
            <table class="overview">
                <caption>Package - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="packages/package" mode="pd" />
                    <xsl:apply-templates select="pd-package/pd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="architecture | package" mode="overview_class_description">
        <xsl:if test="cd-package or classes">
            <table class="overview">
                <caption>Class - Description</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="classes/interface" mode="cd" />
                    <xsl:apply-templates select="classes/class" mode="cd" />
                    <xsl:apply-templates select="cd-package/cd" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

    <xsl:template match="architecture | package" mode="overview_class_responsibilities_collaboration">
        <xsl:if test="crc-package or classes">
            <table class="overview">
                <caption>Class - Responsibilities - Collaboration</caption>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Responsibilities</th>
                        <th>Collaboration</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:apply-templates select="classes/interface" mode="crc" />
                    <xsl:apply-templates select="classes/class" mode="crc" />
                    <xsl:apply-templates select="crc-package/crc" />
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
