<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2012 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- short packages -->

    <xsl:template match="cd-package/cd">
        <tr>
            <td><xsl:value-of select="@name" /></td>
            <td><xsl:value-of select="@description" /></td>
        </tr>
    </xsl:template>

    <xsl:template match="crc-package/crc">
        <tr>
            <td><xsl:apply-templates select="@name" /></td>
            <td>
                <xsl:if test="not(responsibilities)">
                    <br />
                </xsl:if>
                <xsl:apply-templates select="responsibilities" />
            </td>
            <td>
                <xsl:if test="not(collaboration)">
                    <br />
                </xsl:if>
                <xsl:apply-templates select="collaboration" />
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="crc/responsibilities">
        <xsl:if test="not(responsibility)">
            <br />
        </xsl:if>
        <xsl:apply-templates select="responsibility" />
    </xsl:template>

    <xsl:template match="crc/responsibilities/responsibility">
        <xsl:apply-templates />
        <br />
    </xsl:template>

    <xsl:template match="crc/collaboration">
        <xsl:if test="not(relationship)">
            <br />
        </xsl:if>
        <xsl:apply-templates select="relationship" />
    </xsl:template>

    <xsl:template match="crc/collaboration/relationship">
        <xsl:apply-templates />
        <br />
    </xsl:template>

    <!-- common -->

    <xsl:template match="pd">
        <tr>
            <td><xsl:value-of select="@name" /></td>
            <td><xsl:value-of select="@description" /></td>
        </tr>
    </xsl:template>

</xsl:stylesheet>