<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
	
	<!-- database -->

	<xsl:template match="analysis" mode="table_of_contents_database">
		<xsl:if test="database">
			<li>
				<a href="#database" onclick="expandAncestors('database')">Database</a>
				<ul>
					<xsl:if test="database/pd-package or database/database-package">
						<li><a href="#{generate-id(database)}-overview" onclick="expandAncestors('{generate-id(database)}-overview')">Overview</a></li>
					</xsl:if>
					<xsl:if test="database/specification">
						<li><a href="#{generate-id(database/specification)}-header"  onclick="expandAncestors('{generate-id(database/specification)}-header')">Specification</a></li>
					</xsl:if>					
					<xsl:if test="database/database-package">
						<li>Packages 
							<ul>
								<xsl:for-each select="database/database-package">
									<li>
										<xsl:choose>
											<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
											<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
										</xsl:choose>
									</li>
								</xsl:for-each>
							</ul>
						</li>
					</xsl:if>
					<xsl:if test="database/types">
						<li><a href="#{generate-id(database/types)}-header" onclick="expandAncestors('{generate-id(database/types)}-header')">Types</a></li>
					</xsl:if>
					<xsl:if test="database/diagram">
						<li>Diagrams
							<ul>
								<xsl:for-each select="database/diagram">
									<li>
										<xsl:choose>
											<xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
											<xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
										</xsl:choose>
									</li>
								</xsl:for-each>
							</ul>
						</li>
					</xsl:if>
				</ul>
			</li>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="database">
		<h2 id="database">Database</h2>
		<xsl:apply-templates select="description" />
		<xsl:apply-templates select="." mode="overview" />
		<xsl:apply-templates select="specification" />
		<xsl:apply-templates select="database-package" />
		<xsl:apply-templates select="types" />
		<xsl:apply-templates select="diagram" />
	</xsl:template>

	<xsl:template match="database/description">
		<h3>Description</h3>
		<div class="indent">
			<xsl:apply-templates />
		</div>
	</xsl:template>	

	<xsl:template match="database/specification">
		<h3 id="{generate-id(.)}-header" onclick="toggleSpecification('{generate-id(.)}')">Specification</h3>
		<ol id="{generate-id(.)}" state="hidden" class="specification" style="display:none">
			<xsl:apply-templates />
		</ol>
	</xsl:template>

	<xsl:template match="database/types">
		<h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Types</h3>
		<ul id="{generate-id(.)}" class="attributes">
			<xsl:apply-templates />
		</ul>
	</xsl:template>
	
	<xsl:template match="database/diagram">
		<xsl:choose>
			<xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:when>
			<xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')"><xsl:value-of select="@name" /></h3></xsl:otherwise>
		</xsl:choose>
		<img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
	</xsl:template>

</xsl:stylesheet>
