<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- gui package -->

    <xsl:template match="gui/gui-package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="gui-package" />
            <xsl:if test="menu">
                <h4 id="{generate-id(.)}-menu-header" onclick="toggleTag('{generate-id(.)}-menu')">Menu</h4>
                <ul id="{generate-id(.)}-menu" class="menu">
                    <xsl:apply-templates select="menu" />
                </ul>
            </xsl:if>
            <xsl:if test="toolbar">
                <h4 id="{generate-id(.)}-toolbar-header" onclick="toggleTag('{generate-id(.)}-toolbar')">Toolbar</h4>
                <ul id="{generate-id(.)}-toolbar" class="toolbar">
                    <xsl:apply-templates select="toolbar" />
                </ul>
            </xsl:if>
            <xsl:apply-templates select="screen" />
        </div>
    </xsl:template>

    <xsl:template match="gui-package/gui-package">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="gui-package" />
            <xsl:if test="menu">
                <h4 id="{generate-id(.)}-menu-header" onclick="toggleTag('{generate-id(.)}-menu')">Menu</h4>
                <ul id="{generate-id(.)}-menu" class="menu">
                    <xsl:apply-templates select="menu" />
                </ul>
            </xsl:if>
            <xsl:if test="toolbar">
                <h4 id="{generate-id(.)}-toolbar-header" onclick="toggleTag('{generate-id(.)}-toolbar')">Toolbar</h4>
                <ul id="{generate-id(.)}-toolbar" class="toolbar">
                    <xsl:apply-templates select="toolbar" />
                </ul>
            </xsl:if>
            <xsl:apply-templates select="screen" />
        </div>
    </xsl:template>

    <xsl:template match="gui-package" mode="table_of_contents">
        <xsl:if test="pd-package or gui-package or menu or toolbar or screen">
            <h4>Table of contents</h4>
            <ul class="contents">
                <xsl:if test="pd-package or gui-package">
                    <li><a href="#{generate-id(.)}-overview" onclick="expandAncestors('{generate-id(.)}-overview')">Overview</a></li>
                </xsl:if>
                <xsl:if test="specification">
                    <li><a href="#{generate-id(specification)}-header"  onclick="expandAncestors('{generate-id(specification)}-header')">Specification</a></li>
                </xsl:if>
                <xsl:if test="gui-package">
                    <li>Packages
                        <ul>
                            <xsl:for-each select="gui-package">
                                <li>
                                    <xsl:choose>
                                        <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                        <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                                    </xsl:choose>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </li>
                </xsl:if>
                <xsl:if test="menu">
                    <li><a href="#{generate-id(.)}-menu-header" onclick="expandAncestors('{generate-id(.)}-menu-header')">Menu</a></li>
                </xsl:if>
                <xsl:if test="toolbar">
                    <li><a href="#{generate-id(.)}-toolbar-header" onclick="expandAncestors('{generate-id(.)}-toolbar-header')">Toolbar</a></li>
                </xsl:if>
                <xsl:if test="screen">
                    <li>Screens
                        <ul>
                            <xsl:for-each select="screen">
                                <xsl:choose>
                                    <xsl:when test="@id"><li><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></li></xsl:when>
                                    <xsl:otherwise><li><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></li></xsl:otherwise>
                                </xsl:choose>
                            </xsl:for-each>
                        </ul>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="gui-package/description">
        <h4>Description</h4>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

    <xsl:template match="gui-package/screen">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Screen : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Screen : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}">
            <img alt="{@name}" src="{@image}" style="float:left; padding-right:10px" />
            <div style="display:inline">
                <xsl:apply-templates />
            </div>
            <br style="clear:left" />
        </div>
    </xsl:template>

</xsl:stylesheet>