<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright (C) 2013 Oleh Radvanskyj -->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- use case package -->

    <xsl:template match="use-case-model/use-case-package">
        <xsl:choose>
            <xsl:when test="@id"><h3 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:when>
            <xsl:otherwise><h3 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h3></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="use-case-package" />
            <xsl:apply-templates select="use-case-diagram" />
        </div>
    </xsl:template>

    <xsl:template match="use-case-package/description">
        <h4>Description</h4>
        <div class="indent">
            <xsl:apply-templates />
        </div>
    </xsl:template>

    <xsl:template match="use-case-package" mode="table_of_contents">
        <xsl:if test="pd-package or use-case-package or use-case-diagram">
            <h4>Table of contents</h4>
            <ul class="contents">
                <xsl:if test="pd-package or use-case-package">
                    <li><a href="#{generate-id(.)}-overview" onclick="expandAncestors('{generate-id(.)}-overview')">Overview</a></li>
                </xsl:if>
                <xsl:if test="specification">
                    <li><a href="#{generate-id(specification)}-header"  onclick="expandAncestors('{generate-id(specification)}-header')">Specification</a></li>
                </xsl:if>
                <xsl:if test="use-case-package">
                    <li>Packages
                        <ul>
                            <xsl:for-each select="use-case-package">
                                <li>
                                    <xsl:choose>
                                        <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                        <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                                    </xsl:choose>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </li>
                </xsl:if>
                <xsl:if test="use-case-diagram">
                    <li>Diagrams
                        <ul>
                            <xsl:for-each select="use-case-diagram">
                                <li>
                                    <xsl:choose>
                                        <xsl:when test="@id"><a href="#{@id}" onclick="expandAncestors('{@id}')"><xsl:value-of select="@name" /></a></xsl:when>
                                        <xsl:otherwise><a href="#{generate-id(.)}-header" onclick="expandAncestors('{generate-id(.)}-header')"><xsl:value-of select="@name" /></a></xsl:otherwise>
                                    </xsl:choose>
                                </li>
                            </xsl:for-each>
                        </ul>
                    </li>
                </xsl:if>
            </ul>
        </xsl:if>
    </xsl:template>

    <xsl:template match="use-case-package/use-case-package">
        <xsl:choose>
            <xsl:when test="@id"><h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:when>
            <xsl:otherwise><h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Package : <xsl:value-of select="@name" /></h4></xsl:otherwise>
        </xsl:choose>
        <div id="{generate-id(.)}" class="indent" style="display:none">
            <xsl:apply-templates select="description" />
            <xsl:apply-templates select="." mode="table_of_contents" />
            <xsl:apply-templates select="." mode="overview" />
            <xsl:apply-templates select="specification" />
            <xsl:apply-templates select="use-case-package" />
            <xsl:apply-templates select="use-case-diagram" />
        </div>
    </xsl:template>

    <xsl:template match="use-case-package/use-case-diagram">
        <xsl:choose>
            <xsl:when test="$out = 'file'">
                <xsl:choose>
                    <xsl:when test="@page">
                        <xsl:choose>
                            <xsl:when test="@id">
                                <h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <a href="{@page}"><xsl:value-of select="@name" /></a></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:when>
                            <xsl:otherwise>
                                <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <a href="{@page}"><xsl:value-of select="@name" /></a></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="@id">
                                <h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <xsl:value-of select="@name" /></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:when>
                            <xsl:otherwise>
                                <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <xsl:value-of select="@name" /></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when test="@document">
                        <xsl:choose>
                            <xsl:when test="@id">
                                <h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <a href="{@document}"><xsl:value-of select="@name" /></a></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:when>
                            <xsl:otherwise>
                                <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <a href="{@document}"><xsl:value-of select="@name" /></a></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="@id">
                                <h4 id="{@id}" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <xsl:value-of select="@name" /></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:when>
                            <xsl:otherwise>
                                <h4 id="{generate-id(.)}-header" onclick="toggleTag('{generate-id(.)}')">Use case diagram : <xsl:value-of select="@name" /></h4>
                                <img id="{generate-id(.)}" alt="{@name}" src="{@image}" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>